#ifndef	_USER_INTERFACE_
#define	_USER_INTERFACE_

// <<< Use Configuration Wizard in Context Menu >>>
//<o> Drive_Wave <0=> Sinusoidal <1=> Squarewave 
#define 	Drive_Wave 0
#if (Drive_Wave == 0)
	#define	SINUSOLIDAL_CONTROL			// Else for Square Wave
#endif

//<o> SVPWM Mode <0=> 7-SVPWM <1=> 5-SVPWM 
#define SVPWM_Mode  0
#if (SVPWM_Mode == 0)
	#define	SVPWM_7
#elif (SVPWM_Mode == 1)	
	#define	SVPWM_5
#endif
	

//#define	LOWSIDESWITHCING															// Else for High-Side Swithcing(P-MOS)
// 	<o> Control_Mode <0=> Open Loop <1=> Speed Loop <2=> Current Loop <3=> Tuning Mode
#define Control_Mode 0
#if (Control_Mode == 0)
	#define	DUTY_CONTROL
#elif (Control_Mode == 1)
	#define	SPEEDLOOP_CONTROL
#elif (Control_Mode == 2)
	#define	CURRENTLOOP_CONTROL
#elif (Control_Mode == 3)
	#define	SPEEDLOOP_CONTROL
#endif
// <e> BootStrap Function (Enable / Disable)
// <i> Condition : N + N MOS should be Enable this Function
#define BOOTSTRAP_ENABLE 0
#if (BOOTSTRAP_ENABLE == 1)
	#define	BOOTSTRAP	
#endif
// <o> BootStrap Time
#define BOOTSTRAP_TIME				(300) // @1ms
// </e>
// <o> Pole <4=> 4 <6=> 6 <8=> 8 <10=> 10 <12=> 12 <14=> 14
#define Pole 8
#if (Pole == 14)
	#define	POLE_14
#elif (Pole == 12)
	#define	POLE_12
#elif (Pole == 10)
	#define	POLE_10
#elif (Pole == 8)
	#define	POLE_8
#elif (Pole == 6)
	#define	POLE_6
#elif (Pole == 4)
	#define	POLE_4
#endif
//#define POLE_PAIRS POLE>>1
// <o> Direction <0=> Forward (CW) <1=> Reverse (CCW)
#define Direction 0

#define	CW													(0)
#define	CCW													(1)

// <o> PWM_Frequency (unit : Hz) <11724-60000>
// <i> Limit : 11724Hz - 60000Hz
#define	PWM_Frequency										(16000)																				 // @Hz (>14KHz), Define the PWM frequency of the motor

// <o> Duty_Amplitude_Minimum (unit : %) <0-100>
// <i> Limit : 0 ~ 100%
#define	AMP_MIN									(unsigned int)((float)15.0  / 100 * DUTY_MAX)	 // Define Minimum Amplitude
// <o> Duty_Amplitude_Maximum (unit : %) <0-100>
// <i> Limit : 0 ~ 100%
#define	AMP_MAX									(unsigned int)((float)100.0  / 100 * DUTY_MAX)	 // Define Maximum Amplitude //300 RPM
// <o> Speed_Minimum (unit : RPM)
#define	SPEED_MIN								((50)  >> SPEED_SHIFT)															 // @RPM
// <o> Speed_Maximum (unit : RPM)
#define	SPEED_MAX								((1200) >> SPEED_SHIFT)										 					// @RPM
// <o> Speed_Error_Rate (unit : %)
#define	SPEED_ERROR_RATE				(unsigned int)((float)(3) / 100 * SPEED_MAX)				 // @RPM
// <o> HCKS <1=> HCKS_1 <2=> HCKS_2 <3=> HCKS_3 <4=> HCKS_4 <5=> HCKS_5 <6=> HCKS_6 <7=> HCKS_7
//<i> Speed_Minimum = 1/(65535*(1/(48000000/(2<<(HCKS+1))))*(POLE/2))*60 
#define HCKS 5
#if (HCKS == 1)
	#define	HCKS_1																				// Rotor Clock = 48MHz / 8
#elif (HCKS == 2)
	#define	HCKS_2																				// Rotor Clock = 48MHz / 16
#elif (HCKS == 3)
	#define	HCKS_3																					// Rotor Clock = 48MHz / 32
#elif (HCKS == 4)
	#define	HCKS_4																				// Rotor Clock = 48MHz / 64
#elif (HCKS == 5)
	#define	HCKS_5																				// Rotor Clock = 48MHz / 128
#elif (HCKS == 6)
	#define	HCKS_6																				// Rotor Clock = 48MHz / 256
#elif (HCKS == 7)
	#define	HCKS_7																				// Rotor Clock = 48MHz / 512
#endif
// <o> Speed_Shift
// <i> Limit : Speed Range Over 32767
#define	SPEED_SHIFT							(0)		
// <h> OpenLoop Parameter
// <i> Condition : Control_Mode In OpenLoop
//	<o> Slope_Time (unit : value * 1ms)
#define	dDUTY_SLOPE_TIME				(2)																								// @ 1ms
//  <o> Slope_Delta (unit : x)
#define	dDUTY_SLOPE_DELTA				(1)																								// @ PWM Cnt / ms
// <o> Speed_Limit (unit : RPM)
#define	SPEED_LIMIT										((1800) >> SPEED_SHIFT)										 			// @RPM
// <o> Speed_Limit_Error_Rate (unit : %)
#define	SPEED_Limit_ERROR_RATE				(unsigned int)((float)(1) / 100 * SPEED_LIMIT)				 	// @RPM

#ifdef	DUTY_CONTROL
// <h> Reverse_AS
//	<o> AS_Min (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MIN_REV								(0)												// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
//  <o> AS_Max  (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MAX_REV								(15)										// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
// </h>
// <h> Forward_AS
//	<o> AS_Min (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MIN_FRD								(0)												// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
//  <o> AS_Max  (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MAX_FRD								(15)										// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
// </h>
//	<o> AS_Time (unit : value * 1ms)
#define	AS_TIME										(100)											// @1ms
#endif
// </h>
//  <h> SpeedLoop Parameter
//  <i> Condition : Control_Mode In SpeedLoop
//	<o> Slope_Time (unit : value * 1ms)
#define	dSPEED_SLOPE_TIME				(2)							// @ 1ms
//  <o> Slope_Delta	(unit : 1 RPM)
#define	dSPEED_SLOPE_DELTA			(1)							 	// @ RPM / ms
//  <h> Speed PI Parameter
#ifdef	SPEEDLOOP_CONTROL
//	<o> PI_Cycle
#define		WFreInHz									(1000)
#define		WFreSet										(1000 / WFreInHz)
#define		WRefMin										(SPEED_MIN)
#define		WRefMax										(SPEED_MAX)
#ifdef	CURRENTLOOP_CONTROL
#define		WOutMin										(IBUS_MIN)
#define		WOutMax										(IBUS_MAX)
#else
//  <o> PI_Out_Min <0-32767>
#define		WOutMin										(signed long)(0)
//  <o> PI_Out_Max <0-32767>
#define		WOutMax										(signed long)(32767)
#define		WFSOutMax									(signed long) 32767 * (0)  / 100
#endif
#define		WNko											(2)
// 	<o> Kp <0-32767>
#define		WKp												((signed int)  (16384))
// 	<o> Ki <0-32767>
#define		WKi												((signed int)  (400))
#define		WKd												((signed int)  (32767 * 0.05))
// 	<o> Kt <0-32767>
#define		WKc												((signed int)  (32734))
#endif
// </h>
#ifdef	SPEEDLOOP_CONTROL
// <h> Reverse_AS
//	<o> AS_Min (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MIN_REV								(0)												// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
//  <o> AS_Max (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MAX_REV								(30)										// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
// </h>
// <h> Forward_AS
//	<o> AS_Min (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MIN_FRD								(0)										   // @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
//  <o> AS_Max (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MAX_FRD								(30)									// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
// </h>
//	<o> AS_Time (unit : value * 1ms)
#define	AS_TIME										(3)											// @1ms
#endif
// </h>
//  <h> CurrentLoop Parameter
//  <i> Condition : Control_Mode In CurrentLoop
//  <o> IBUS_CH <0=> CH0 <1=> CH1  <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5  <6=> CH6 <7=> CH7
#define	IBUS_CH								(6)												// ADC Channel of the VSP, CH7 as IBUS
//	<o> Shunt (unit : mohm)
#define	dBUSSHUNT_R						(float)((float)(250)/1000)
//  <o> OPA_Gain (unit : %)
#define	dBUSOPA_GAIN					(float)((float)(2000)/100)
//  <o> COEFF (unit : x/1000)
#define	dBUS_COEFF						(float)((float)(1000)/1000)
//	<o> Slope_Time (unit : value * 1ms)
#define	dIBUS_SLOPE_TIME										(10)																								 		// @ 1ms
//  <o> Slope_Delta (unit : 0.001 mA)
#define	dIBUS_SLOPE_DELTA										(unsigned int)(((float)(1)/1000) * dAMP_PER_CONSTANT) 	// @Amps / ms
//	<o> Slope_Time_For_Speed_Limit (unit : value * 1ms)
#define	dIBUS_SLOPE_SPEED_LIMIT_TIME				(5)																								 			// @ 1ms
//  <o> Slope_Delta_For_Speed_Limit (unit : 0.001 mA)	
#define	dIBUS_SLOPE_SPEED_LIMIT_DELTA				(unsigned int)(((float)(1)/1000) * dAMP_PER_CONSTANT) 	// @Amps / ms
//  <o> Current_Command_Minimum (unit : mA)
#define	IBUS_MIN								(unsigned int)(((float)(0)/1000)			* dAMP_PER_CONSTANT) // @Amps
//	<o> Current_Command_Maximum (unit : mA)
#define	IBUS_MAX								(unsigned int)(((float)(300)/1000)		* dAMP_PER_CONSTANT) // @Amps
// <h> Current PI Parameter
#ifdef	CURRENTLOOP_CONTROL
//	<o> PI_Cycle
#define		IBUSFreInHz								(500)
#define		IBUSFreSet								(1000 / IBUSFreInHz)
#define		IBUSRefMin								(IBUS_MIN)
#define		IBUSRefMax								(IBUS_MAX)
//  <o> PI_Out_Min <0-32767>
#define		IBUSOutMin								(signed long)(0)
//  <o> PI_Out_Max <0-32767>
#define		IBUSOutMax								(signed long)(32767)
#define		IBUSNko										(2)
// 	<o> Kp <0-32767>
#define		IBUSKp										((signed int)  (8000))
// 	<o> Ki <0-32767>
#define		IBUSKi										((signed int)  (100))
#define		IBUSKd										((signed int)  (32767 * 0.05))
// 	<o> Kt <0-32767>
#define		IBUSKc										((signed int)  (32734))
#endif
// </h>
#ifdef	CURRENTLOOP_CONTROL
// <h> Reverse_AS
//	<o> AS_Min (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MIN_REV								(0)												// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
//  <o> AS_Max (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MAX_REV								(5)										// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
// </h>
// <h> Forward_AS
//	<o> AS_Min (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MIN_FRD								(0)												// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
//  <o> AS_Max (unit : value * 0.9375deg) <0-630>
//  <i> Maximum Limit is 63(59.0625 Deg)
#define	AS_MAX_FRD								(5)										// @0.9375Degree, Maximum Limit is 63(59.0625 Deg),if AS Expansion Enable Maximum Limit is 630
// </h>
//	<o> AS_Time (unit : value * 1ms)
#define	AS_TIME										(1)											// @1ms
//	<o> Current_Constant_Shift <0-6>
#define	IBUS_CONSTANT_SHIFT		(5)
// <o> IBus Signal Delay <0=> Disable <1=> Enable 
#define IBus_Signal_Delay 0
#endif
// </h>

// <h> Input Command VSP/PWM/Frequency (Enable / Disable)
// <o> Input_Command_Type <0=> VSP <1=> PWM <2=> Frequency
#define	Input_Command_Type				(0)											// ADC Channel of the VSP, CH0 as VSP
// <o> Command_Reverse <0=> Disable <1=> Enable
#define	Command_Revers							(0)										// ADC Channel of the VSP, CH0 as VSP
#if (Command_Revers == 0)
	#define	INPUT_NOINV																			// Else for Inverse the Input																	// @Hz, 50  ~ 100
#endif
// <h> VSP Command
// <o> VSP_CH <0=> CH0 <1=> CH1  <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5  <6=> CH6 <7=> CH7
#define	VSP_CH										(7)												// ADC Channel of the VSP, CH0 as VSP
#if (Input_Command_Type==0)
// <o> Command_Max (unit : 0.01V) 
#define	CMD_MAX									((float)(435) / 100)						// @Volt, VSP is 0 ~ 5V
// <o> Command_Start (unit : 0.01V)
#define	CMD_START								((float)(80) / 100)							// @Volt, VSP for Start the Drive
// <o> Command_Stop (unit : 0.01V)
#define	CMD_STOP								((float)(60) / 100)							// @Volt, VSP for Stop  the Drive
// <o> Cammand_Base (unit : 0.01V) 
#define	CMD_BASE								((float)(680) / 100)						// @Volt, VSP is 0 ~ 5V
#endif
// </h>
#if (Input_Command_Type==1)
// <h> PWM Command
// <i> Capture.h]wJ},Hζ}Capture\
// <i> ӿJ}줺q]wPull low
// <o> Command_Max (unit : 0.1%) <0-1000>
#define	CMD_MAX									((float)(950) / 10)						// @%, PWM Duty Circle is 0 ~ 100%
// <o> Command_Start (unit : 0.1%) <0-1000>
#define	CMD_START								((float)(100) / 10)						// @%, PWM Duty Circle for Start the Drive
// <o> Command_Stop (unit : 0.1%) <0-1000>
#define	CMD_STOP								((float)(70) / 10)						// @%, PWM Duty Circle for Stop  the Drive
// <e> PWM_Command_Slope (Enable / Disable)
#define PWM_CMD_SLOPE_EN 1
//  <o> Command_Slope (unit : value * 1ms) <0-255>
#define	PWM_CMD_SLOPE						(3)							 				// @ RPM / ms
// </e>

// </h>
#endif

#if (Input_Command_Type==2)
// <h> Frequency Command
// <o> Command_Max (unit : Hz)
#define	CMD_MAX									((float)(500))						// @%, PWM Duty Circle is 0 ~ 100%
// <o> Command_Start (unit : Hz)
#define	CMD_START								((float)(149))						// @%, PWM Duty Circle for Start the Drive
// <o> Command_Stop (unit : Hz)
#define	CMD_STOP								((float)(146))						// @%, PWM Duty Circle for Stop  the Drive
//  <o> Command_Slope (unit : value * 1ms)
#define	CMD_SLOPE								(12)							 				// @ RPM / ms
// </h>
#endif
// </h>

// <e> Force Command (Enable / Disable)
// <i> Condition : Disable Input Command
#define Force_Command 					(1)
// <o> Force Command Value
#define	VSP_FORCE_VALUE					(unsigned int)(100)
// <i> VSP Command Range: VSP_Command_Start ~ VSP_Command Max
// <i> PWM Command Range: PWM_Command_Start ~ PWM_Command Max
// <i> Freqency Command Range : Freqency_Command_Start ~ Freqency_Command Max
#if 	(Input_Command_Type==0)
#define	VSP_RATIO								(unsigned int)((float)VSP_FORCE_VALUE / 100 * 1024 / CMD_BASE)
#elif	(Input_Command_Type==1)
#define	VSP_RATIO								(unsigned int)((float)VSP_FORCE_VALUE / 1000 * 1024)
#elif	(Input_Command_Type==2)
#define	VSP_RATIO								(unsigned int)(VSP_FORCE_VALUE)
#endif
// </e>

// <h> FG Output
// <o> FG_PIN <1=> P2_3 <2=> P2_4 <3=> P2_5 <4=> P2_6 <5=> P2_7 <6=> P3_0 <7=> P3_1 <8=> P3_2 <9=> P3_3 <10=> P3_4 <11=> P3_5 <12=> P0_4 <13=> P0_5 <14=> P0_6
#define FG_PIN 9
#if (FG_PIN == 1)
#define	FG		(P2_3)
#elif (FG_PIN == 2)
#define	FG		(P2_4)
#elif (FG_PIN == 3)
#define	FG		(P2_5)
#elif (FG_PIN == 4)
#define	FG		(P2_6)
#elif (FG_PIN == 5)
#define	FG		(P2_7)
#elif (FG_PIN == 6)
#define	FG		(P3_0)
#elif (FG_PIN == 7)
#define	FG		(P3_1)
#elif (FG_PIN == 8)
#define	FG		(P3_2)
#elif (FG_PIN == 9)
#define	FG		(P3_3)
#elif (FG_PIN == 10)
#define	FG		(P3_4)
#elif (FG_PIN == 11)
#define	FG		(P3_5)
#elif (FG_PIN == 12)
#define	FG		(P0_4)
#elif (FG_PIN == 13)
#define	FG		(P0_5)
#elif (FG_PIN == 14)
#define	FG		(P0_6)
#endif
// <e> FG_Use_HallISR (Enable / Disable)
#define FG_Use_HallISR 0
// <o> Pulse_Per_HallClock <1=> 1 <2=> 1.5 <3=> 3
#define Pulse_Per_HallClock 3
#if (Pulse_Per_HallClock == 1)
	#define	FG_2_PULSE_PER_ROUND			
#elif (Pulse_Per_HallClock == 2)
	#define	FG_3_PULSE_PER_ROUND		
#elif (Pulse_Per_HallClock == 3)
	#define	FG_6_PULSE_PER_ROUND
#endif
// </e>
// <e> FG_Use_TimerISR (Enable / Disable)
#define FG_Use_TimerISR 0
// <o> Pulse_Per_Round
#define	FG_CAL_PULSE_PER_ROUND	(12)										// Pole or PPR
#define	FG_RPM_OFFSET						(1000) - (1000)					// Target - Max RPM
// </e>
#if (FG_Use_HallISR == 0 && FG_Use_TimerISR == 1)
	#define	FG_CAL	
#endif
#if (Control_Mode == 3)
	#define	FG_CAL	
#endif	
// </h>

// 	<o> Limit_Current_Function <0=> Disable <1=> Enable 
#define Limit_Current_Function 1
#if (Limit_Current_Function == 1)
	#define OCP_LIMIT_ENABLE
#endif

// <e> WatchDog (Enable / Disable)
// </e>
#define WATCHDOG_ENABLE 1
#if (WATCHDOG_ENABLE == 1)
	#define	WATCHDOG_EN
#endif
// <e> Direction Pin Function (Enable / Disable)
#define Direction_Pin_Function 0
#if (Direction_Pin_Function == 1)
	#define FR_EN
#endif
// <o> FR_CH <1=> P2_3 <2=> P2_4 <3=> P2_5 <4=> P2_6 <5=> P2_7 <6=> P3_0 <7=> P3_1 <8=> P3_2 <9=> P3_3 <10=> P3_4 <11=> P3_5
#define FR_CH 10
#if (FR_CH == 1)
#define	FR_PIN		(P2_3)
#elif (FR_CH == 2)
#define	FR_PIN		(P2_4)
#elif (FR_CH == 3)
#define	FR_PIN		(P2_5)
#elif (FR_CH == 4)
#define	FR_PIN		(P2_6)
#elif (FR_CH == 5)
#define	FR_PIN		(P2_7)
#elif (FR_CH == 6)
#define	FR_PIN		(P3_0)
#elif (FR_CH == 7)
#define	FR_PIN		(P3_1)
#elif (FR_CH == 8)
#define	FR_PIN		(P3_2)
#elif (FR_CH == 9)
#define	FR_PIN		(P3_3)
#elif (FR_CH == 10)
#define	FR_PIN		(P3_4)
#elif (FR_CH == 11)
#define	FR_PIN		(P3_5)
#endif
// <o> Reverse Speed (unit : RPM)
#define Reverse_Speed  	(300)
#define	REVERSE_SPEED		((Reverse_Speed) >> SPEED_SHIFT)
// </e>
// <h> VBus Recharge Protection
// <o> Flying_Startup_Amplitude_Maximum (unit : %) <0-100>
#define	FLYING_STARTUP_AMP_MAX	(unsigned int)((float)80.0  / 100 * DUTY_MAX)	// Define Maximum Amplitude
// <o> Flying_Startup_Speed (unit : RPM)
#define	SPEED_FLYING_STARTUP		((800) >> SPEED_SHIFT)												// @RPM	
// </h>
// <h> AS Expansion
// <o> AS Expansion <0=> Disable <1=> Enable 
#define AS_EXPANSION_ENABLE 0
// </h>
// <h> SVPWM Amplitude Fine-Tune
// <o> SVPWM Amplitude Fine-Tune <0=> Disable <1=> Enable 
#define AMP_FINE_TUNE 1
// </h>
// <h> AS Correction
// <i> ϥΦbiX
// <o> AS Correction <0=> Disable <1=> Enable 
#define AS_CORRECTION_ENABLE 0
// </h>

// <<< end of configuration section >>>

#endif