#ifndef ADC_H
#define ADC_H

// <<< Use Configuration Wizard in Context Menu >>>
// <h> Set ADCCONT 
// <o.3> ADCCKS <0=> 4MHz <1=> 2MHz
// <i> ADC conversion clock select
// <o.4> ADCDS <0=> ADCD2 MSB <1=> ADCD2 LSB
// <o.5..6> ADCSH <0=> 1 clock <1=> 2 clock <2=> 3 clock <3=> 4 clock
// <o.7> ADCPD <0=> Normal <1=> Power Down
// </h>
#define ADCCONT_REGS 0x10

// <h> Set ADCSTR
// <o.6..7> SHCKS <0=> 1MHz <1=> 500KHz <2=> 400KHz <3=> 333KHz
// </h>
#define ADCSTR_REGS 0x00
// <<< end of configuration section >>>

extern void Adc_Init (void);
extern signed int Adc_Channel (unsigned char Channel);
#endif