/**
 * @file    comp_multichannel_polling.c
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the system functions 
 */

/* Define to prevent recursive inclusion */
#define _COMP_MULTICHANNEL_POLLING_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "comp_multichannel_polling.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup COMP
  * @{
  */

/**
  * @addtogroup COMP_MultiChannel_Polling
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP_Configure(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
    COMP_InitTypeDef COMP_InitStruct;

    COMP_POLL_InitTypeDef COMP_POLL_InitStruct;

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_COMP, ENABLE);

    COMP_StructInit(&COMP_InitStruct);
    COMP_InitStruct.COMP_Invert     = COMP_InvertingInput_0;    /* INM_SEL */
    COMP_InitStruct.COMP_NonInvert  = COMP_NonInvertingInput_0; /* INP_SEL */
    COMP_InitStruct.COMP_Output     = COMP_Output_None;
    COMP_InitStruct.COMP_OutputPol  = COMP_Pol_NonInvertedOut;
    COMP_InitStruct.COMP_Hysteresis = COMP_Hysteresis_No;
    COMP_InitStruct.COMP_Mode       = COMP_Mode_LowPower;
    COMP_InitStruct.COMP_OFLT       = COMP_Filter_4_Period;
    COMP_Init(COMP1, &COMP_InitStruct);

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

    /* COMP1 INM0 -> PA4 */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_4;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    /* COMP1 INP1 -> PA5 & INP2 -> PA6 */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_5 | GPIO_Pin_6;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    COMP_Cmd(COMP1, ENABLE);

    COMP_PollStructInit(&COMP_POLL_InitStruct);
    COMP_POLL_InitStruct.COMP_Poll_Ch     = COMP_POLL_1_2;
    COMP_POLL_InitStruct.COMP_Poll_Fixn   = COMP_POLL_INPUT_FIX;    /* INM_SEL = SET & INP_SEL = 1/2 */
    COMP_POLL_InitStruct.COMP_Poll_Period = COMP_POLL_WAIT_128;
    COMP_PollInit(COMP1, &COMP_POLL_InitStruct);

    COMP_PollCmd(COMP1, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP_MultiChannel_Polling_Sample(void)
{
    uint32_t OldLevel = 0, NewLevel = 0;

    printf("\r\nTest %s", __FUNCTION__);

    COMP_Configure();

    printf("\r\nRemove R8");

    printf("\r\nAdjust the comparator channel(PA4(RV3) PA5 and PA6) voltage.");

    while (1)
    {
        NewLevel = READ_BIT(COMP1->COMPx_POLL, COMP_POLL_POUT_Msk);

        if (OldLevel != NewLevel)
        {
            OldLevel = NewLevel;

            printf("\r\nCOMP1 POUT[0]: %d, POUT[1] : %d", (NewLevel & (1 << 8)) ? 1 : 0, (NewLevel & (1 << 9)) ? 1 : 0);
        }

        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */



