/**
 * @file    mg32_opamp.c
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the OPAMP firmware functions 
 */

/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#define _MG32_OPAMP_C_

/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "mg32_opamp_lib.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @addtogroup OPAMP
  * @{
  */

/** @defgroup OPAMP_Private_Defines
  * @{
  */

/**
  * @}
  */

/** @defgroup OPAMP_Private_Functions
  * @{
  */

/**
  * @brief  Enables or disables the specified OPAMP peripheral.
  * @param  opamp: select the opamp peripheral.
  * @param  state: new state of the OPAMP peripheral.
  *         This parameter can be: ENABLE or DISABLE.
  * @retval None.
  */
void OPAMP_Cmd(OPAMP_TypeDef* opamp, FunctionalState state)
{
    (state) ? \
    (opamp->CR |=  (0x01U << OPAMP_CR_OPAEN_Pos)) : \
    (opamp->CR &= ~(0x01U << OPAMP_CR_OPAEN_Pos));
}

/**
  * @brief  Select OPAMP peripheral performance mode.
  * @param  opamp: select the opamp peripheral.
  * @param  opamode: OPAMP peripheral performance mode.
  *     @arg   OPAMP_Mode_HighPerformance  
  *     @arg   OPAMP_Mode_LowPower  
  * @retval None.
  */
void OPAMP_ModeConfig(OPAMP_TypeDef* opamp, uint32_t opamode)
{
    MODIFY_REG(opamp->CR, OPAMP_CR_OPAMSEL_Msk, opamode); 
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
