/**
 * @file    mg32_opamp.h
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the functions prototypes for the OPAMP firmware
 *          library.
 */


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __MG32_OPAMP_H
#define __MG32_OPAMP_H

/* Files includes ------------------------------------------------------------*/
#include <core_cm0.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__CC_ARM)
#pragma anon_unions
#elif defined(__ICCARM__)
#pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic ignored "-Wc11-extensions"
#pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined(__GNUC__)
/* anonymous unions are enabled by default */
#else
#warning Not supported compiler type
#endif

/**
  * @brief OPAMP Base Address Definition
  */
#define OPAMP1_BASE        (APB1PERIPH_BASE + 0x9000)              /*!< Base Address:  */
#define OPAMP2_BASE        (APB1PERIPH_BASE + 0x9400)              /*!< Base Address:  */

/**
  * @brief Operational Amplifier Registers Structure Definition
  */
typedef struct 
{
    __IO uint32_t CR;                                                           /*!< OPAMP Control Status Register                  Offset: 0x00 */
} OPAMP_TypeDef;

/**
  * @brief OPA type pointer Definition
  */
#define OPAMP1                           ((OPAMP_TypeDef*) OPAMP1_BASE)
#define OPAMP2                           ((OPAMP_TypeDef*) OPAMP2_BASE)
/**
  * @brief OPAMP_CR Register Bit Definition
  */
#define OPAMP_CR_OPAEN_Pos              (0)
#define OPAMP_CR_OPAEN_Msk              (0x01U << OPAMP_CR_OPAEN_Pos)            /*!< OPA ENABLE */
#define OPAMP_CR_OPAMSEL_Pos            (1)
#define OPAMP_CR_OPAMSEL_Msk            (0x01U << OPAMP_CR_OPAMSEL_Pos)         /*!< OPA MODE SELECT */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */


#ifdef __cplusplus
}
#endif

/** --------------------------------------------------------------------------*/
#endif
/** --------------------------------------------------------------------------*/
