/**
  ******************************************************************************
 *
 * @file        Sample_MID_TM36_PWM_DTG_CentralAlign.c
 *
 * @brief       TM36 PWM output with 
 *
 * @par         Project
 *              MG32
 * @version     V1.13
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_TM_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static TM_HandleTypeDef mTM36;

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_TM36_PWM_DTG_CentralAlign(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    ADC convert PA1,PA2 with PWM central-align (Top overflow)
 * @details     1.Initial TM36 for 10-bit resolution of PWM with DTG.
 *    \n        2.Initial TM36 clock mode.
 *    \n        3.Set Break in cycle-by-cycle mode.
 *    \n        4.Pin initial for PWM 2's complment (Channel-0~2).
 *    \n        5.Config Central-align.
 *    \n        6.Enable PWM output.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_TM36_PWM_DTG_CentralAlign(void)
{  
    TM_OC_InitTypeDef               sConfig;
    TM_ClockConfigTypeDef           CKConfig;
    TM_BreakDeadTimeConfigTypeDef   BKConfig;

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->TM36 = Enable
    //Configure Peripheral On Mode Clock->DMA = Enable
    //Configure Peripheral On Mode Clock->GPIOC = Enable
    //Configure Peripheral On Mode Clock->GPIOD = Enable
	
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOC->PC0,PC2
    //GPIO port initial is 0xFFFF
    //PC0,PC2 mode is PPO
    //PC0,PC2 function TM36_OC00, TM36_OC10
        
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOD->PD0
    //GPIO port initial is 0xFFFF
    //PD0 mode is PPO
    //PD0 function TM36_OC2
        
    // ------------------------------------------------------------------------
    // 1.Initial TM36 for 10-bit resolution of PWM with DTG.
    // ------------------------------------------------------------------------
    mTM36.Instance                  = TM36;
    mTM36.Init.TM_CounterMode       = TM_CASCADE_UP;
    mTM36.Init.TM_Period            = 1023;
    mTM36.Init.TM_Prescaler         = 0;
    MID_TM_PWM_DTG_Init(&mTM36);
    
    // ------------------------------------------------------------------------
    // 2.Initial TM36 clock mode.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = 0;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    MID_TM_ConfigClockSource(&mTM36, &CKConfig);  

    // ------------------------------------------------------------------------
    // 3.Set Break in cycle-by-cycle mode.
    // ------------------------------------------------------------------------
    BKConfig.BreakMode              = TM_BK_CYCLE_BY_CYCLE;
    BKConfig.BreakCHxOutputMode     = MID_BREAK_STOP_STATE;
    BKConfig.BreakSourceSel         = MID_BK_ExtPin | MID_BK_ClockFailure | MID_BK_CPULOCKUP | MID_BK_BOD1;
    BKConfig.DeatTimeClockDivision  = MID_TM_CKDTG_DIV1;
    BKConfig.DeadTime               = 26;
    MID_TM_ConfigBreakDeadTime(&mTM36, &BKConfig);

    // ------------------------------------------------------------------------
    // 4.Pin initial for PWM 2's complment (Channel-0~2).
    // ------------------------------------------------------------------------
    MID_TM_OC_Struct_Init(&sConfig);
    sConfig.OCMode  = TM_CH_16bit_PWM_COMPLEMENT;
    sConfig.Pulse   = 200;                          // duty cycle of channel0
    MID_TM_PWM_ConfigChannel(&mTM36, &sConfig, MID_TM_Channel0);

    sConfig.Pulse   = 511;                          // duty cycle of channel1
    MID_TM_PWM_ConfigChannel(&mTM36, &sConfig, MID_TM_Channel1);

    sConfig.Pulse   = 1000;                         // duty cycle of channel2
    MID_TM_PWM_ConfigChannel(&mTM36, &sConfig, MID_TM_Channel2);

    // ------------------------------------------------------------------------
    // 5.Config Central-align.
    // ------------------------------------------------------------------------
    __DRV_TM_ENABLE_PWM_CENTRAL(&mTM36);
    
    // ------------------------------------------------------------------------
    // 6.Enable PWM output. 
    // ------------------------------------------------------------------------
    MID_TM_PWM_DTG_Start(&mTM36, MID_TM_Channel0);     
    MID_TM_PWM_DTG_Start(&mTM36, MID_TM_Channel1);     
    MID_TM_PWM_DTG_Start(&mTM36, MID_TM_Channel2);  

}


