/**
  ******************************************************************************
 *
 * @file        Sample_MID_CSC.c
 *
 * @brief       CSC use interrupt sample code
 *
 * @par         Project
 *              MG32
 * @version     V2.41
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_MID.h"
#include "MG32_CSC_MID.h"
#include "MG32_SYS_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void Sample_MID_CSC (void);

/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       CSC sample code.
 * @details     1.Enable/disable periphery clock and select periphery clock  
 *                source CK_AHB/CK_APB
 *    \n        2.Enable/disable periphery clock in SLEEP mode
 *    \n        3.Enable/disable periphery clock in STOP mode
 *    \n        4.Enable MCD function and set interrupt
 * @return      None
 *******************************************************************************
 */
void Sample_MID_CSC (void)
{
    // Unprotect CSC module register write
    MID_UnProtectModuleReg(CSCmodule);
    
    
    // make sure :
    //Keil toolbar "Manage Run-Time Environment" clik.
    //"IRQ handler" must be ticked in "MG32_ChipInit_Wizard"
    //When use CSC, "Enable CSC NVIC" of "MG32_IRQ_Handler" must be ticked in "MG32_ChipInit_Wizard"
    //
    // ------------------------------------------------------------------------
    // 1.Enable/disable periphery clock and select periphery clock source 
    //   CK_AHB/CK_APB 
    // ------------------------------------------------------------------------
    // Periphery clock enable/disable
    __DRV_CSC_GPIOA_CLK_ENABLE();       // GPIOA clock enable
    __DRV_CSC_GPIOB_CLK_ENABLE();       // GPIOB clock enable
    __DRV_CSC_GPIOC_CLK_ENABLE();       // GPIOC clock enable
    __DRV_CSC_GPIOD_CLK_ENABLE();       // GPIOD clock enable
    __DRV_CSC_RTC_CLK_ENABLE();         // RTC clock enable
    __DRV_CSC_IWDT_CLK_ENABLE();        // IWDT clock enable
    
    
    __DRV_CSC_SPI0_CKS_CK_APB();        // SPI0 = CK_APB
    __DRV_CSC_SPI0_CLK_ENABLE();        // SPI0 clock enable
    
    __DRV_CSC_URT0_CKS_CK_APB();        // URT0 = CK_APB
    __DRV_CSC_URT0_CLK_ENABLE();        // URT0 clock enable
    
    __DRV_CSC_URT1_CKS_CK_APB();        // URT1 = CK_APB
    __DRV_CSC_URT1_CLK_ENABLE();        // URT1 clock enable
    
    __DRV_CSC_TM00_CKS_CK_APB();        // TM00 = CK_APB
    __DRV_CSC_TM00_CLK_ENABLE();        // TM00 clock enable
    
    __DRV_CSC_TM36_CKS_CK_AHB();        // TM36 = CK_AHB
    __DRV_CSC_TM36_CLK_ENABLE();        // TM36 clock enable
    
    __DRV_CSC_TM10_CLK_DISABLE();       // TM10 clock disable
    __DRV_CSC_TM16_CLK_DISABLE();       // TM16 clock disable

    // ------------------------------------------------------------------------
    // 2.Enable/disable periphery clock in SLEEP mode
    // ------------------------------------------------------------------------
    // Periphery sleep mode clock enable/disable
    __DRV_CSC_SLP_SPI0_CLK_ENABLE();    // SPI0 SLEEP mode clock enable
    __DRV_CSC_SLP_URT0_CLK_ENABLE();    // URT0 SLEEP mode clock enable
    __DRV_CSC_SLP_URT1_CLK_ENABLE();    // URT1 SLEEP mode clock enable
    __DRV_CSC_SLP_RTC_CLK_ENABLE();     // RTC SLEEP mode clock enable
    __DRV_CSC_SLP_IWDT_CLK_ENABLE();    // IWDT SLEEP mode clock enable

    // ------------------------------------------------------------------------
    // 3.Enable/disable periphery clock in STOP mode
    // ------------------------------------------------------------------------
    // Periphery stop mode clock enable/disable
    __DRV_CSC_STP_RTC_CLK_ENABLE();     // RTC STOP mode clock enable
    __DRV_CSC_STP_IWDT_CLK_ENABLE();    // IWDT STOP mode clock enable

    // ------------------------------------------------------------------------
    // 4.Enable MCD function and set interrupt
    // ------------------------------------------------------------------------
    // Enable MCD(missing clock detect) function. When CK_HS = CK_XOSC MCD will detect.
    MID_CSC_EnableMCD(MID_CSC_MCD_250us);

    // Configure interrupt 
    __DRV_CSC_ENABLE_IT(CSC_IT_MCD | SYS_IT_IEA);
    __DRV_CSC_DISABLE_IT(CSC_IT_XOSC | CSC_IT_ILRCO | CSC_IT_IHRCO | CSC_IT_PLL);
    
    // Protect CSC module register write
    MID_ProtectModuleReg(CSCmodule);
} 


/**
 *******************************************************************************
 * @brief       Middle CSC MCD call back
 * @details  
 * @return      None
 * @note
 * @par         Example
 * @code
    MID_CSC_MCDCallback();
 * @endcode
 *******************************************************************************
 */
void MID_CSC_MCDCallback (void)
{
    // To do ...
}



