/**
 ******************************************************************************
 *
 * @file        MG32_URT_Init.H
 *
 * @brief       This file is to configure URT baudrate setting.
 *              Device : MG32F02A132
 * @par         Project
 *              MG32 
 * @version     V1.00   
 * @date        2022/09/05
 * @author      MG32CoGen: 2.0.0.26 , 2023/8/3 下午 02:11 
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_CSC.h"
#include "MG32_URT.h" 
#include "RTE_Components.h"
#if defined(IRQHandler_Middleware_Level_)
    #include "MG32_URT_MID.h"
    #include "MG32_SPI_MID.h"
#endif

// <<< Use Configuration Wizard in Context Menu >>>
//<h> URT0 Configure
    //<o0> Mode Select <0x00=> Disable
    //                 <0x01=> UART    
    //                 <0x02=> IrDa Mode
    //                 <0x03=> Multi-Processor (Address bit) Mode
    //                 <0x04=> Multi-Processor (Idle Line) Mode
    //                 <0x05=> SPI Master Mode
    //                 <0x07=> SC Mode
    //                 <0x08=> LIN Mode
    //                 <0x09=> General Timer Mode
    #define CONF_URT0_MODE                    1
    //<h> UART Mode Configure
    #if 1
        //<h> Character Format
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT0_UART_DATABIT          0
            //<o0> Data Order <0=> LSB                    
            //                <1=> MSB                    
            #define CONF_URT0_UART_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable        
            //                        <1=> Enable         
            #define CONF_URT0_UART_DATAINV          0
            //<o0> Parity Bit <0=> None                   
            //                <1=> Even                   
            //                <3=> Odd                    
            //                <5=> SPACE                  
            //                <7=> MARK                   
            #define CONF_URT0_UART_PARITY           0
            //<o0> Stop Bit <1=> 1BIT                     
            //              <3=> 2BIT                     
            #define CONF_URT0_UART_STOP             1
        //</h>
        //<h> Buad Rate Control
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT0_UART_BR_CALC          1
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT0_UART_BR_MDS       1 
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT0_UART_BR_CKSEL     0                
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT0_UART_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT0_UART_BR_BR        49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT0_UART_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT0_UART_BR           115200
            //</h>
        //</h>  
        //<h> Hardware Flow Control
            //<o0> CTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT0_HWFLOW_CTS            0
            //<o0> RTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT0_HWFLOW_RTS            0
            //<o0> DE Signal (RS485) <0=> Disable
            //                       <1=> DE is L level in TX + Gaud Time = 1/4 Bit
            //                       <5=> DE is L level in TX + Gaud Time = 1/2 Bit
            //                       <9=> DE is L level in TX + Gaud Time = 1 Bit
            //                       <13=>DE is L level in TX + Gaud Time = 2 Bit
            //                       <3=> DE is H level in TX + Gaud Time = 1/4 Bit
            //                       <7=> DE is H level in TX + Gaud Time = 1/2 Bit
            //                       <11=>DE is H level in TX + Gaud Time = 1 Bit
            //                       <15=>DE is H level in TX + Gaud Time = 2 Bit          
            #define CONF_URT0_HWFLOW_DE             0x00
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT0_UART_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_UART_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_UART_RX_INV            0
        //</h>
    #endif
    //</h>
    //<h> IrDa Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT0_IRDA_DATABIT          0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT0_IRDA_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT0_IRDA_DATAINV          0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT0_IRDA_PARITY           0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT0_IRDA_STOP             1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT0_IRDA_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT0_IRDA_BR_MDS       1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT0_IRDA_BR_CKSEL     0  
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT0_IRDA_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT0_IRDA_BR_BR        49
                //<o0> Oversampling (15~31)<15-31>
                #define CONF_URT0_IRDA_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT0_IRDA_BR           9600
            //</h>
        //</h> 
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT0_IRDA_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_IRDA_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_IRDA_RX_INV            0
        //</h>    
    #endif        
    //</h>
    //<h> Multi-Processor (Address bit) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT0_MULTIADR_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT0_MULTIADR_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT0_MULTIADR_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT0_MULTIADR_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT0_MULTIADR_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT0_MULTIADR_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT0_MULTIADR_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT0_MULTIADR_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT0_MULTIADR_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT0_MULTIADR_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT0_MULTIADR_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT0_MULTIADR_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT0_MULTIADR_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT0_MULTIADR_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT0_MULTIADR_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT0_MULTIADR_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_MULTIADR_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_MULTIADR_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> Multi-Processor (Idle Line) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT0_MULTIIDL_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT0_MULTIIDL_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT0_MULTIIDL_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT0_MULTIIDL_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT0_MULTIIDL_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT0_MULTIIDL_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT0_MULTIIDL_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT0_MULTIIDL_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT0_MULTIIDL_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT0_MULTIIDL_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT0_MULTIIDL_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT0_MULTIIDL_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Idle Line Status is (2~256) Bit Continuous idle <2-256>
            #define CONF_URT0_MULTIIDL_IDL          2
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT0_MULTIIDL_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT0_MULTIIDL_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT0_MULTIIDL_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT0_MULTIIDL_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_MULTIIDL_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT0_MULTIIDL_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> SPI Master Mode Configure
    #if 1
        //<h> Clock Mode
            //<o0> Clock Polarity (CPOL) <0=> 0 (Low)
            //                           <1=> 1 (High)
            #define CONF_URT0_SPIMASTER_CPOL         0
            //<o0> Clock Phase (CPHA) <0=> 0 (Leading Edge)
            //                        <1=> 1 (Trailing Edge)
            #define CONF_URT0_SPIMASTER_CPHA         0            
        //</h>
        //<h> Character Format 
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT0_SPIMASTER_DATAORDER    1
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT0_SPIMASTER_DATAINV      0
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT0_SPIMASTER_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT0_SPIMASTER_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT0_SPIMASTER_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT0_SPIMASTER_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT0_SPIMASTER_BR_BR    49
                //<o0> Oversampling (3~31)<3-31>
                #define CONF_URT0_SPIMASTER_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-12000000)Hz<400-12000000>
                #define CONF_URT0_SPIMASTER_BR       9600
            //</h>
        //</h>
        //<h> Advanced       
           //<o0> TX (MOSI) and RX (MISO) Pin Swap <0=> Disable
           //                                      <1=> Enable
           #define CONF_URT0_SPIMASTER_PINSWAP       0
        //</h>  
    #endif        
    //</h>
    //In URT0 of the Device no support the SPI slave mode.
    #define CONF_URT0_SPISLAVE_CPOL        0        
    #define CONF_URT0_SPISLAVE_CPHA        0            
    #define CONF_URT0_SPISLAVE_DATAORDER   1
    #define CONF_URT0_SPISLAVE_DATAINV     0
    #define CONF_URT0_SPISLAVE_BR_CALC     0
    #define CONF_URT0_SPISLAVE_BR_MDS      1
    #define CONF_URT0_SPISLAVE_BR_CKSEL    0  
    #define CONF_URT0_SPISLAVE_BR_PRE      0
    #define CONF_URT0_SPISLAVE_BR_BR       49
    #define CONF_URT0_SPISLAVE_BR_OS       24
    #define CONF_URT0_SPISLAVE_BR          9600
    #define CONF_URT0_SPISLAVE_PINSWAP     0 
    //<h> SC Mode Configure
    #if 1
        //<o0>Default Coding Convention <0x00000000=> Direct <0x00300028=> Inverse
        //<i> Direct Convention  : Data bit inverse, msb first and parity bit is odd.
        //<i> Inverse Convention : Data bit no inverse, lsb first and parity bit is even.
        #define CONF_URT0_SC_CONVENTION             0x00000000 
        //<o0>TX Guard Time (0-254)Bit <0-254>
        #define CONF_URT0_SC_GT                     0
        //<o0>RX Waiting Time (0-65535) Bit<0-65535>
        //<i> 0 is Disable
        #define CONF_URT0_SC_WT                     13
        //<h> TX Error
            //<o0> TX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT0_SC_TXERRORTIME        3 
        //</h>
        //<h> RX Error
            //<o0> RX Error Signal Length <0=> 1Bit
            //                            <1=> 2Bit
            #define CONF_URT0_SC_RXERRORSIG         0
            //<o0> RX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT0_SC_RXERRORTIME        3          
        //</h>
    #endif
    //</h>
    //<h> LIN Mode Configure
    #if 1
        //<h> Buad Rate 
            //<o0> Baud-rate Calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT0_LIN_BR_CALC           0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT0_LIN_BR_MDS        1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT0_LIN_BR_CKSEL      0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT0_LIN_BR_PRE        0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT0_LIN_BR_BR         49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT0_LIN_BR_OS         24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT0_LIN_BR            9600
            //</h>
            //<o0> Auto Baud Rate Calibration <0x00=> Disable
            //                                <0x02=> Enable and calibration mode is Start
            //                                <0x06=> Enable and calibratoin mode is Edge
            #define CONF_URT0_LIN_CAL               0x00
        //</h>
        //<h> Advanced
            //<o0> Break output length / detect length <0=> 13bit / 11bit 
            //                                         <1=> 16bit / 13bit
            #define CONF_URT0_LIN_BK                0
        //</h>
    #endif
    //</h>
    //<h> General Timer Mode
    #if 1
        //<e0>(1st Timer) Baud-Rate Generator Timer
        #define CONF_URT0_TM_BRT                    0
            //<o0> Timer Overflow Clock (1~4096)<1-4096>
            #define CONF_URT0_TM_BRTRLR             1
        //</e>
        //<e0>(2nd Timer)Timerout Timer
        #define CONF_URT0_TM_TMO                    0
            //<o0> Timeout Timer Overflow Clock (1~65536)<1-65536>
            #define CONF_URT0_TM_TMORLR             1
        //</e>
    #endif
    //</h>
    //<e0> Interrupt Enable (IEA)
    #define CONF_URT0_IEA                           0
    #if 1
        //<q0> Transmit Data Reg. Empty Interrupt (TX_IE)
        #define CONF_URT0_TXIE                      0
        //<q0> Transfer Complete Interrupt (TC_IE)
        #define CONF_URT0_TCIE                      0
        //<q0> Receive Data Reg. not Empty (RX_IE)
        #define CONF_URT0_RXIE                      0
        //<e0> URT General Event Detect Interrupt (UG_IE)
        #define CONF_URT0_UGFIE                     0
            //<q0> Slave Address Match Interrupt (SADR_IE) 
            #define CONF_URT0_SADRIE                0
            //<q0> Baud-Rate Generator Timer Timeout Interrupt (BRT_IE)
            #define CONF_URT0_BRTIE                 0
            //<q0> Timeout Timer Timeout Interrupt (TMO_IE)
            #define CONF_URT0_TMOIE                 0
            //<q0> Calibration Complete Interrupt (CALC_IE)
            #define CONF_URT0_CALCIE                0
        //</e>
        //<e0> Line Status Event Detect Interrupt (LS_IE)
        #define CONF_URT0_LSIE                      0       
            //<q0> Break Condition Detect Interrupt (BK_IE)
            #define CONF_URT0_BKIE                  0
            //<q0> Idle Line Detect Interrupt (IDL_IE)
            #define CONF_URT0_IDLIE                 0
            //<q0> CTS Change Detect Interrupt (CTS_IE)          
            #define CONF_URT0_CTSIE                 0
        //</e>
        //<e0> Error Event Detect Interrupt (ERR_IE)
        #define CONF_URT0_ERRIE                     0
            //<q0> Parity Error Interrupt (PE_IE)
            #define CONF_URT0_PEIE                  0
            //<q0> Frame Error Interrupt (FE_IE)
            #define CONF_URT0_FEIE                  0
            //<q0> RX Data Buffer Overrun Interrupt (ROVR_IE)
            #define CONF_URT0_ROVRIE                0
            //<q0> Receive Noised Character Error Interrupt (NCE_IE)
            #define CONF_URT0_NCEIE                 0
            //<q0> TX Error Detect Interrupt (TXE_IE)
            #define CONF_URT0_TXEIE                 0
            //<q0> Receive Timeout Interrupt (RXTMO_IE)
            #define CONF_URT0_RXTMOIE               0
            //<q0> Idle State Timeout Interrupt (IDMO_IE)
            #define CONF_URT0_IDMO_IE               0
            //<q0> Break Receive Timeout Interrupt (BKTMO_IE)
            #define CONF_URT0_BKTMOIE               0
            //<q0> Auto Baud Rate Calibration Timeout Interrupt (CALTMO_IE)
            #define CONF_URT0_CALTMOIE              0
        //</e>
    #endif
    //</e>
//</h>
//<h> URT1 Configure
    //<o0> Mode Select <0x00=> Disable
    //                 <0x01=> UART    
    //                 <0x02=> IrDa Mode
    //                 <0x03=> Multi-Processor (Address bit) Mode
    //                 <0x04=> Multi-Processor (Idle Line) Mode
    //                 <0x05=> SPI Master Mode
    //                 <0x07=> SC Mode
    //                 <0x08=> LIN Mode
    //                 <0x09=> General Timer Mode
    #define CONF_URT1_MODE                    0
    //<h> UART Mode Configure
    #if 1
        //<h> Character Format
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT1_UART_DATABIT          0
            //<o0> Data Order <0=> LSB                    
            //                <1=> MSB                    
            #define CONF_URT1_UART_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable        
            //                        <1=> Enable         
            #define CONF_URT1_UART_DATAINV          0
            //<o0> Parity Bit <0=> None                   
            //                <1=> Even                   
            //                <3=> Odd                    
            //                <5=> SPACE                  
            //                <7=> MARK                   
            #define CONF_URT1_UART_PARITY           0
            //<o0> Stop Bit <1=> 1BIT                     
            //              <3=> 2BIT                     
            #define CONF_URT1_UART_STOP             1
        //</h>
        //<h> Buad Rate Control
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT1_UART_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT1_UART_BR_MDS       1 
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT1_UART_BR_CKSEL     0                
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT1_UART_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT1_UART_BR_BR        49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT1_UART_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT1_UART_BR           9600
            //</h>
        //</h>  
        //<h> Hardware Flow Control
            //<o0> CTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT1_HWFLOW_CTS            0
            //<o0> RTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT1_HWFLOW_RTS            0
            //<o0> DE Signal (RS485) <0=> Disable
            //                       <1=> DE is L level in TX + Gaud Time = 1/4 Bit
            //                       <5=> DE is L level in TX + Gaud Time = 1/2 Bit
            //                       <9=> DE is L level in TX + Gaud Time = 1 Bit
            //                       <13=>DE is L level in TX + Gaud Time = 2 Bit
            //                       <3=> DE is H level in TX + Gaud Time = 1/4 Bit
            //                       <7=> DE is H level in TX + Gaud Time = 1/2 Bit
            //                       <11=>DE is H level in TX + Gaud Time = 1 Bit
            //                       <15=>DE is H level in TX + Gaud Time = 2 Bit          
            #define CONF_URT1_HWFLOW_DE             0x00
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT1_UART_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_UART_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_UART_RX_INV            0
        //</h>
    #endif
    //</h>
    //<h> IrDa Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT1_IRDA_DATABIT          0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT1_IRDA_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT1_IRDA_DATAINV          0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT1_IRDA_PARITY           0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT1_IRDA_STOP             1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT1_IRDA_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT1_IRDA_BR_MDS       1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT1_IRDA_BR_CKSEL     0  
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT1_IRDA_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT1_IRDA_BR_BR        49
                //<o0> Oversampling (15~31)<15-31>
                #define CONF_URT1_IRDA_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT1_IRDA_BR           9600
            //</h>
        //</h> 
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT1_IRDA_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_IRDA_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_IRDA_RX_INV            0
        //</h>    
    #endif        
    //</h>
    //<h> Multi-Processor (Address bit) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT1_MULTIADR_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT1_MULTIADR_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT1_MULTIADR_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT1_MULTIADR_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT1_MULTIADR_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT1_MULTIADR_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT1_MULTIADR_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT1_MULTIADR_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT1_MULTIADR_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT1_MULTIADR_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT1_MULTIADR_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT1_MULTIADR_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT1_MULTIADR_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT1_MULTIADR_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT1_MULTIADR_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT1_MULTIADR_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_MULTIADR_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_MULTIADR_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> Multi-Processor (Idle Line) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT1_MULTIIDL_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT1_MULTIIDL_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT1_MULTIIDL_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT1_MULTIIDL_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT1_MULTIIDL_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT1_MULTIIDL_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT1_MULTIIDL_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT1_MULTIIDL_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT1_MULTIIDL_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT1_MULTIIDL_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT1_MULTIIDL_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT1_MULTIIDL_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Idle Line Status is (2~256) Bit Continuous idle <2-256>
            #define CONF_URT1_MULTIIDL_IDL          2
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT1_MULTIIDL_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT1_MULTIIDL_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT1_MULTIIDL_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT1_MULTIIDL_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_MULTIIDL_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT1_MULTIIDL_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> SPI Master Mode Configure
    #if 1
        //<h> Clock Mode
            //<o0> Clock Polarity (CPOL) <0=> 0 (Low)
            //                           <1=> 1 (High)
            #define CONF_URT1_SPIMASTER_CPOL         0
            //<o0> Clock Phase (CPHA) <0=> 0 (Leading Edge)
            //                        <1=> 1 (Trailing Edge)
            #define CONF_URT1_SPIMASTER_CPHA         0            
        //</h>
        //<h> Character Format 
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT1_SPIMASTER_DATAORDER    1
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT1_SPIMASTER_DATAINV      0
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT1_SPIMASTER_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT1_SPIMASTER_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT1_SPIMASTER_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT1_SPIMASTER_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT1_SPIMASTER_BR_BR    49
                //<o0> Oversampling (3~31)<3-31>
                #define CONF_URT1_SPIMASTER_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-12000000)Hz<400-12000000>
                #define CONF_URT1_SPIMASTER_BR       9600
            //</h>
        //</h>
        //<h> Advanced       
           //<o0> TX (MOSI) and RX (MISO) Pin Swap <0=> Disable
           //                                      <1=> Enable
           #define CONF_URT1_SPIMASTER_PINSWAP       0
        //</h>  
    #endif        
    //</h>
    //In URT1 of the Device no support the SPI slave mode.
    #define CONF_URT1_SPISLAVE_CPOL        0        
    #define CONF_URT1_SPISLAVE_CPHA        0            
    #define CONF_URT1_SPISLAVE_DATAORDER   1
    #define CONF_URT1_SPISLAVE_DATAINV     0
    #define CONF_URT1_SPISLAVE_BR_CALC     0
    #define CONF_URT1_SPISLAVE_BR_MDS      1
    #define CONF_URT1_SPISLAVE_BR_CKSEL    0  
    #define CONF_URT1_SPISLAVE_BR_PRE      0
    #define CONF_URT1_SPISLAVE_BR_BR       49
    #define CONF_URT1_SPISLAVE_BR_OS       24
    #define CONF_URT1_SPISLAVE_BR          9600
    #define CONF_URT1_SPISLAVE_PINSWAP     0 
    //<h> SC Mode Configure
    #if 1
        //<o0>Default Coding Convention <0x00000000=> Direct <0x00300028=> Inverse
        //<i> Direct Convention  : Data bit inverse, msb first and parity bit is odd.
        //<i> Inverse Convention : Data bit no inverse, lsb first and parity bit is even.
        #define CONF_URT1_SC_CONVENTION             0x00000000 
        //<o0>TX Guard Time (0-254)Bit <0-254>
        #define CONF_URT1_SC_GT                     0
        //<o0>RX Waiting Time (0-65535) Bit<0-65535>
        //<i> 0 is Disable
        #define CONF_URT1_SC_WT                     13
        //<h> TX Error
            //<o0> TX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT1_SC_TXERRORTIME        3 
        //</h>
        //<h> RX Error
            //<o0> RX Error Signal Length <0=> 1Bit
            //                            <1=> 2Bit
            #define CONF_URT1_SC_RXERRORSIG         0
            //<o0> RX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT1_SC_RXERRORTIME        3          
        //</h>
    #endif
    //</h>
    //<h> LIN Mode Configure
    #if 1
        //<h> Buad Rate 
            //<o0> Baud-rate Calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT1_LIN_BR_CALC           0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT1_LIN_BR_MDS        1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT1_LIN_BR_CKSEL      0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT1_LIN_BR_PRE        0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT1_LIN_BR_BR         49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT1_LIN_BR_OS         24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT1_LIN_BR            9600
            //</h>
            //<o0> Auto Baud Rate Calibration <0x00=> Disable
            //                                <0x02=> Enable and calibration mode is Start
            //                                <0x06=> Enable and calibratoin mode is Edge
            #define CONF_URT1_LIN_CAL               0x00
        //</h>
        //<h> Advanced
            //<o0> Break output length / detect length <0=> 13bit / 11bit 
            //                                         <1=> 16bit / 13bit
            #define CONF_URT1_LIN_BK                0
        //</h>
    #endif
    //</h>
    //<h> General Timer Mode
    #if 1
        //<e0>(1st Timer) Baud-Rate Generator Timer
        #define CONF_URT1_TM_BRT                    0
            //<o0> Timer Overflow Clock (1~4096)<1-4096>
            #define CONF_URT1_TM_BRTRLR             1
        //</e>
        //<e0>(2nd Timer)Timerout Timer
        #define CONF_URT1_TM_TMO                    0
            //<o0> Timeout Timer Overflow Clock (1~65536)<1-65536>
            #define CONF_URT1_TM_TMORLR             1
        //</e>
    #endif
    //</h>
    //<e0> Interrupt Enable (IEA)
    #define CONF_URT1_IEA                           0
    #if 1
        //<q0> Transmit Data Reg. Empty Interrupt (TX_IE)
        #define CONF_URT1_TXIE                      0
        //<q0> Transfer Complete Interrupt (TC_IE)
        #define CONF_URT1_TCIE                      0
        //<q0> Receive Data Reg. not Empty (RX_IE)
        #define CONF_URT1_RXIE                      0
        //<e0> URT General Event Detect Interrupt (UG_IE)
        #define CONF_URT1_UGFIE                     0
            //<q0> Slave Address Match Interrupt (SADR_IE) 
            #define CONF_URT1_SADRIE                0
            //<q0> Baud-Rate Generator Timer Timeout Interrupt (BRT_IE)
            #define CONF_URT1_BRTIE                 0
            //<q0> Timeout Timer Timeout Interrupt (TMO_IE)
            #define CONF_URT1_TMOIE                 0
            //<q0> Calibration Complete Interrupt (CALC_IE)
            #define CONF_URT1_CALCIE                0
        //</e>
        //<e0> Line Status Event Detect Interrupt (LS_IE)
        #define CONF_URT1_LSIE                      0       
            //<q0> Break Condition Detect Interrupt (BK_IE)
            #define CONF_URT1_BKIE                  0
            //<q0> Idle Line Detect Interrupt (IDL_IE)
            #define CONF_URT1_IDLIE                 0
            //<q0> CTS Change Detect Interrupt (CTS_IE)          
            #define CONF_URT1_CTSIE                 0
        //</e>
        //<e0> Error Event Detect Interrupt (ERR_IE)
        #define CONF_URT1_ERRIE                     0
            //<q0> Parity Error Interrupt (PE_IE)
            #define CONF_URT1_PEIE                  0
            //<q0> Frame Error Interrupt (FE_IE)
            #define CONF_URT1_FEIE                  0
            //<q0> RX Data Buffer Overrun Interrupt (ROVR_IE)
            #define CONF_URT1_ROVRIE                0
            //<q0> Receive Noised Character Error Interrupt (NCE_IE)
            #define CONF_URT1_NCEIE                 0
            //<q0> TX Error Detect Interrupt (TXE_IE)
            #define CONF_URT1_TXEIE                 0
            //<q0> Receive Timeout Interrupt (RXTMO_IE)
            #define CONF_URT1_RXTMOIE               0
            //<q0> Idle State Timeout Interrupt (IDMO_IE)
            #define CONF_URT1_IDMO_IE               0
            //<q0> Break Receive Timeout Interrupt (BKTMO_IE)
            #define CONF_URT1_BKTMOIE               0
            //<q0> Auto Baud Rate Calibration Timeout Interrupt (CALTMO_IE)
            #define CONF_URT1_CALTMOIE              0
        //</e>
    #endif
    //</e>
//</h>
//<h> URT2 Configure
    //<o0> Mode Select <0x00=> Disable
    //                 <0x01=> UART    
    //                 <0x02=> IrDa Mode
    //                 <0x03=> Multi-Processor (Address bit) Mode
    //                 <0x04=> Multi-Processor (Idle Line) Mode
    //                 <0x05=> SPI Master Mode
    //                 <0x07=> SC Mode
    //                 <0x08=> LIN Mode
    //                 <0x09=> General Timer Mode
    #define CONF_URT2_MODE                    0
    //<h> UART Mode Configure
    #if 1
        //<h> Character Format
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT2_UART_DATABIT          0
            //<o0> Data Order <0=> LSB                    
            //                <1=> MSB                    
            #define CONF_URT2_UART_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable        
            //                        <1=> Enable         
            #define CONF_URT2_UART_DATAINV          0
            //<o0> Parity Bit <0=> None                   
            //                <1=> Even                   
            //                <3=> Odd                    
            //                <5=> SPACE                  
            //                <7=> MARK                   
            #define CONF_URT2_UART_PARITY           0
            //<o0> Stop Bit <1=> 1BIT                     
            //              <3=> 2BIT                     
            #define CONF_URT2_UART_STOP             1
        //</h>
        //<h> Buad Rate Control
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT2_UART_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT2_UART_BR_MDS       1 
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT2_UART_BR_CKSEL     0                
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT2_UART_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT2_UART_BR_BR        49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT2_UART_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT2_UART_BR           9600
            //</h>
        //</h>  
        //<h> Hardware Flow Control
            //<o0> CTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT2_HWFLOW_CTS            0
            //<o0> RTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT2_HWFLOW_RTS            0
            //<o0> DE Signal (RS485) <0=> Disable
            //                       <1=> DE is L level in TX + Gaud Time = 1/4 Bit
            //                       <5=> DE is L level in TX + Gaud Time = 1/2 Bit
            //                       <9=> DE is L level in TX + Gaud Time = 1 Bit
            //                       <13=>DE is L level in TX + Gaud Time = 2 Bit
            //                       <3=> DE is H level in TX + Gaud Time = 1/4 Bit
            //                       <7=> DE is H level in TX + Gaud Time = 1/2 Bit
            //                       <11=>DE is H level in TX + Gaud Time = 1 Bit
            //                       <15=>DE is H level in TX + Gaud Time = 2 Bit          
            #define CONF_URT2_HWFLOW_DE             0x00
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT2_UART_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_UART_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_UART_RX_INV            0
        //</h>
    #endif
    //</h>
    //<h> IrDa Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT2_IRDA_DATABIT          0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT2_IRDA_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT2_IRDA_DATAINV          0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT2_IRDA_PARITY           0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT2_IRDA_STOP             1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT2_IRDA_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT2_IRDA_BR_MDS       1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT2_IRDA_BR_CKSEL     0  
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT2_IRDA_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT2_IRDA_BR_BR        49
                //<o0> Oversampling (15~31)<15-31>
                #define CONF_URT2_IRDA_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT2_IRDA_BR           9600
            //</h>
        //</h> 
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT2_IRDA_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_IRDA_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_IRDA_RX_INV            0
        //</h>    
    #endif        
    //</h>
    //<h> Multi-Processor (Address bit) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT2_MULTIADR_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT2_MULTIADR_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT2_MULTIADR_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT2_MULTIADR_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT2_MULTIADR_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT2_MULTIADR_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT2_MULTIADR_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT2_MULTIADR_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT2_MULTIADR_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT2_MULTIADR_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT2_MULTIADR_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT2_MULTIADR_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT2_MULTIADR_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT2_MULTIADR_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT2_MULTIADR_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT2_MULTIADR_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_MULTIADR_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_MULTIADR_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> Multi-Processor (Idle Line) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT2_MULTIIDL_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT2_MULTIIDL_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT2_MULTIIDL_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT2_MULTIIDL_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT2_MULTIIDL_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT2_MULTIIDL_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT2_MULTIIDL_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT2_MULTIIDL_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT2_MULTIIDL_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT2_MULTIIDL_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT2_MULTIIDL_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT2_MULTIIDL_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Idle Line Status is (2~256) Bit Continuous idle <2-256>
            #define CONF_URT2_MULTIIDL_IDL          2
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT2_MULTIIDL_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT2_MULTIIDL_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT2_MULTIIDL_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT2_MULTIIDL_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_MULTIIDL_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT2_MULTIIDL_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> SPI Master Mode Configure
    #if 1
        //<h> Clock Mode
            //<o0> Clock Polarity (CPOL) <0=> 0 (Low)
            //                           <1=> 1 (High)
            #define CONF_URT2_SPIMASTER_CPOL         0
            //<o0> Clock Phase (CPHA) <0=> 0 (Leading Edge)
            //                        <1=> 1 (Trailing Edge)
            #define CONF_URT2_SPIMASTER_CPHA         0            
        //</h>
        //<h> Character Format 
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT2_SPIMASTER_DATAORDER    1
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT2_SPIMASTER_DATAINV      0
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT2_SPIMASTER_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT2_SPIMASTER_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT2_SPIMASTER_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT2_SPIMASTER_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT2_SPIMASTER_BR_BR    49
                //<o0> Oversampling (3~31)<3-31>
                #define CONF_URT2_SPIMASTER_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-12000000)Hz<400-12000000>
                #define CONF_URT2_SPIMASTER_BR       9600
            //</h>
        //</h>
        //<h> Advanced       
           //<o0> TX (MOSI) and RX (MISO) Pin Swap <0=> Disable
           //                                      <1=> Enable
           #define CONF_URT2_SPIMASTER_PINSWAP       0
        //</h>  
    #endif        
    //</h>
    //In URT2 of the Device no support the SPI slave mode.
    #define CONF_URT2_SPISLAVE_CPOL        0        
    #define CONF_URT2_SPISLAVE_CPHA        0            
    #define CONF_URT2_SPISLAVE_DATAORDER   1
    #define CONF_URT2_SPISLAVE_DATAINV     0
    #define CONF_URT2_SPISLAVE_BR_CALC     0
    #define CONF_URT2_SPISLAVE_BR_MDS      1
    #define CONF_URT2_SPISLAVE_BR_CKSEL    0  
    #define CONF_URT2_SPISLAVE_BR_PRE      0
    #define CONF_URT2_SPISLAVE_BR_BR       49
    #define CONF_URT2_SPISLAVE_BR_OS       24
    #define CONF_URT2_SPISLAVE_BR          9600
    #define CONF_URT2_SPISLAVE_PINSWAP     0 
    //<h> SC Mode Configure
    #if 1
        //<o0>Default Coding Convention <0x00000000=> Direct <0x00300028=> Inverse
        //<i> Direct Convention  : Data bit inverse, msb first and parity bit is odd.
        //<i> Inverse Convention : Data bit no inverse, lsb first and parity bit is even.
        #define CONF_URT2_SC_CONVENTION             0x00000000 
        //<o0>TX Guard Time (0-254)Bit <0-254>
        #define CONF_URT2_SC_GT                     0
        //<o0>RX Waiting Time (0-65535) Bit<0-65535>
        //<i> 0 is Disable
        #define CONF_URT2_SC_WT                     13
        //<h> TX Error
            //<o0> TX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT2_SC_TXERRORTIME        3 
        //</h>
        //<h> RX Error
            //<o0> RX Error Signal Length <0=> 1Bit
            //                            <1=> 2Bit
            #define CONF_URT2_SC_RXERRORSIG         0
            //<o0> RX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT2_SC_RXERRORTIME        3          
        //</h>
    #endif
    //</h>
    //<h> LIN Mode Configure
    #if 1
        //<h> Buad Rate 
            //<o0> Baud-rate Calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT2_LIN_BR_CALC           0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT2_LIN_BR_MDS        1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT2_LIN_BR_CKSEL      0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT2_LIN_BR_PRE        0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT2_LIN_BR_BR         49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT2_LIN_BR_OS         24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT2_LIN_BR            9600
            //</h>
            //<o0> Auto Baud Rate Calibration <0x00=> Disable
            //                                <0x02=> Enable and calibration mode is Start
            //                                <0x06=> Enable and calibratoin mode is Edge
            #define CONF_URT2_LIN_CAL               0x00
        //</h>
        //<h> Advanced
            //<o0> Break output length / detect length <0=> 13bit / 11bit 
            //                                         <1=> 16bit / 13bit
            #define CONF_URT2_LIN_BK                0
        //</h>
    #endif
    //</h>
    //<h> General Timer Mode
    #if 1
        //<e0>(1st Timer) Baud-Rate Generator Timer
        #define CONF_URT2_TM_BRT                    0
            //<o0> Timer Overflow Clock (1~4096)<1-4096>
            #define CONF_URT2_TM_BRTRLR             1
        //</e>
        //<e0>(2nd Timer)Timerout Timer
        #define CONF_URT2_TM_TMO                    0
            //<o0> Timeout Timer Overflow Clock (1~65536)<1-65536>
            #define CONF_URT2_TM_TMORLR             1
        //</e>
    #endif
    //</h>
    //<e0> Interrupt Enable (IEA)
    #define CONF_URT2_IEA                           0
    #if 1
        //<q0> Transmit Data Reg. Empty Interrupt (TX_IE)
        #define CONF_URT2_TXIE                      0
        //<q0> Transfer Complete Interrupt (TC_IE)
        #define CONF_URT2_TCIE                      0
        //<q0> Receive Data Reg. not Empty (RX_IE)
        #define CONF_URT2_RXIE                      0
        //<e0> URT General Event Detect Interrupt (UG_IE)
        #define CONF_URT2_UGFIE                     0
            //<q0> Slave Address Match Interrupt (SADR_IE) 
            #define CONF_URT2_SADRIE                0
            //<q0> Baud-Rate Generator Timer Timeout Interrupt (BRT_IE)
            #define CONF_URT2_BRTIE                 0
            //<q0> Timeout Timer Timeout Interrupt (TMO_IE)
            #define CONF_URT2_TMOIE                 0
            //<q0> Calibration Complete Interrupt (CALC_IE)
            #define CONF_URT2_CALCIE                0
        //</e>
        //<e0> Line Status Event Detect Interrupt (LS_IE)
        #define CONF_URT2_LSIE                      0       
            //<q0> Break Condition Detect Interrupt (BK_IE)
            #define CONF_URT2_BKIE                  0
            //<q0> Idle Line Detect Interrupt (IDL_IE)
            #define CONF_URT2_IDLIE                 0
            //<q0> CTS Change Detect Interrupt (CTS_IE)          
            #define CONF_URT2_CTSIE                 0
        //</e>
        //<e0> Error Event Detect Interrupt (ERR_IE)
        #define CONF_URT2_ERRIE                     0
            //<q0> Parity Error Interrupt (PE_IE)
            #define CONF_URT2_PEIE                  0
            //<q0> Frame Error Interrupt (FE_IE)
            #define CONF_URT2_FEIE                  0
            //<q0> RX Data Buffer Overrun Interrupt (ROVR_IE)
            #define CONF_URT2_ROVRIE                0
            //<q0> Receive Noised Character Error Interrupt (NCE_IE)
            #define CONF_URT2_NCEIE                 0
            //<q0> TX Error Detect Interrupt (TXE_IE)
            #define CONF_URT2_TXEIE                 0
            //<q0> Receive Timeout Interrupt (RXTMO_IE)
            #define CONF_URT2_RXTMOIE               0
            //<q0> Idle State Timeout Interrupt (IDMO_IE)
            #define CONF_URT2_IDMO_IE               0
            //<q0> Break Receive Timeout Interrupt (BKTMO_IE)
            #define CONF_URT2_BKTMOIE               0
            //<q0> Auto Baud Rate Calibration Timeout Interrupt (CALTMO_IE)
            #define CONF_URT2_CALTMOIE              0
        //</e>
    #endif
    //</e>
//</h>
//<h> URT3 Configure
    //<o0> Mode Select <0x00=> Disable
    //                 <0x01=> UART    
    //                 <0x02=> IrDa Mode
    //                 <0x03=> Multi-Processor (Address bit) Mode
    //                 <0x04=> Multi-Processor (Idle Line) Mode
    //                 <0x05=> SPI Master Mode
    //                 <0x07=> SC Mode
    //                 <0x08=> LIN Mode
    //                 <0x09=> General Timer Mode
    #define CONF_URT3_MODE                    0
    //<h> UART Mode Configure
    #if 1
        //<h> Character Format
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT3_UART_DATABIT          0
            //<o0> Data Order <0=> LSB                    
            //                <1=> MSB                    
            #define CONF_URT3_UART_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable        
            //                        <1=> Enable         
            #define CONF_URT3_UART_DATAINV          0
            //<o0> Parity Bit <0=> None                   
            //                <1=> Even                   
            //                <3=> Odd                    
            //                <5=> SPACE                  
            //                <7=> MARK                   
            #define CONF_URT3_UART_PARITY           0
            //<o0> Stop Bit <1=> 1BIT                     
            //              <3=> 2BIT                     
            #define CONF_URT3_UART_STOP             1
        //</h>
        //<h> Buad Rate Control
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT3_UART_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT3_UART_BR_MDS       1 
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT3_UART_BR_CKSEL     0                
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT3_UART_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT3_UART_BR_BR        49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT3_UART_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT3_UART_BR           9600
            //</h>
        //</h>  
        //<h> Hardware Flow Control
            //<o0> CTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT3_HWFLOW_CTS            0
            //<o0> RTS Signal (RS232) <0=> Disable
            //                        <1=> Enable
            //                        <5=> Enable + Signal Inversion
            #define CONF_URT3_HWFLOW_RTS            0
            //<o0> DE Signal (RS485) <0=> Disable
            //                       <1=> DE is L level in TX + Gaud Time = 1/4 Bit
            //                       <5=> DE is L level in TX + Gaud Time = 1/2 Bit
            //                       <9=> DE is L level in TX + Gaud Time = 1 Bit
            //                       <13=>DE is L level in TX + Gaud Time = 2 Bit
            //                       <3=> DE is H level in TX + Gaud Time = 1/4 Bit
            //                       <7=> DE is H level in TX + Gaud Time = 1/2 Bit
            //                       <11=>DE is H level in TX + Gaud Time = 1 Bit
            //                       <15=>DE is H level in TX + Gaud Time = 2 Bit          
            #define CONF_URT3_HWFLOW_DE             0x00
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT3_UART_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_UART_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_UART_RX_INV            0
        //</h>
    #endif
    //</h>
    //<h> IrDa Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT3_IRDA_DATABIT          0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT3_IRDA_DATAORDER        0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT3_IRDA_DATAINV          0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT3_IRDA_PARITY           0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT3_IRDA_STOP             1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT3_IRDA_BR_CALC          0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT3_IRDA_BR_MDS       1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT3_IRDA_BR_CKSEL     0  
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT3_IRDA_BR_PRE       0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT3_IRDA_BR_BR        49
                //<o0> Oversampling (15~31)<15-31>
                #define CONF_URT3_IRDA_BR_OS        24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT3_IRDA_BR           9600
            //</h>
        //</h> 
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT3_IRDA_PINSWAP           0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_IRDA_TX_INV            0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_IRDA_RX_INV            0
        //</h>    
    #endif        
    //</h>
    //<h> Multi-Processor (Address bit) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT3_MULTIADR_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT3_MULTIADR_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT3_MULTIADR_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT3_MULTIADR_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT3_MULTIADR_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT3_MULTIADR_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT3_MULTIADR_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT3_MULTIADR_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT3_MULTIADR_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT3_MULTIADR_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT3_MULTIADR_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT3_MULTIADR_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT3_MULTIADR_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT3_MULTIADR_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT3_MULTIADR_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT3_MULTIADR_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_MULTIADR_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_MULTIADR_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> Multi-Processor (Idle Line) Mode Configure
    #if 1
        //<h> Character Format 
            //<o0> Data Bit <0=> 8Bit 
            //              <1=> 7Bit
            #define CONF_URT3_MULTIIDL_DATABIT      0
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT3_MULTIIDL_DATAORDER    0
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT3_MULTIIDL_DATAINV      0
            //<o0> Parity Bit <0=> None 
            //                <1=> Even
            //                <3=> Odd 
            //                <5=> SPACE            
            //                <7=> MARK 
            #define CONF_URT3_MULTIIDL_PARITY       0
            //<o0> Stop Bit <1=> 1BIT 
            //              <3=> 2BIT
            #define CONF_URT3_MULTIIDL_STOP         1
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT3_MULTIIDL_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT3_MULTIIDL_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT3_MULTIIDL_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT3_MULTIIDL_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT3_MULTIIDL_BR_BR    49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT3_MULTIIDL_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT3_MULTIIDL_BR       9600
            //</h>
        //</h> 
        //<h> Address Control
            //<o0> Idle Line Status is (2~256) Bit Continuous idle <2-256>
            #define CONF_URT3_MULTIIDL_IDL          2
            //<o0> Address (0x00~0xFF) <0x00-0xFF>
            #define CONF_URT3_MULTIIDL_ADR          0x00
            //<o0> Address Mask (0x00~0xFF) <0x00-0xFF>
            //<i> Bit = 0 ( The bit don't care), Bit = 1 ( The bit compare)
            #define CONF_URT3_MULTIIDL_ADRMASK      0xFF
            //<o0> Global Address <0=> Disable
            //                    <1=> Enable
            #define CONF_URT3_MULTIIDL_GLOBAL       0
        //</h>
        //<h> Advanced
           //<o0> TX and RX Pin Swap <0=> Disable
           //                        <1=> Enable
           #define CONF_URT3_MULTIIDL_PINSWAP       0
           //<o0> TX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_MULTIIDL_TX_INV        0
           //<o0> RX Pin Level Inversion <0=> Disable
           //                            <1=> Enable
           #define CONF_URT3_MULTIIDL_RX_INV        0
        //</h>
    #endif
    //</h>
    //<h> SPI Master Mode Configure
    #if 1
        //<h> Clock Mode
            //<o0> Clock Polarity (CPOL) <0=> 0 (Low)
            //                           <1=> 1 (High)
            #define CONF_URT3_SPIMASTER_CPOL         0
            //<o0> Clock Phase (CPHA) <0=> 0 (Leading Edge)
            //                        <1=> 1 (Trailing Edge)
            #define CONF_URT3_SPIMASTER_CPHA         0            
        //</h>
        //<h> Character Format 
            //<o0> Data Order <0=> LSB
            //                <1=> MSB
            #define CONF_URT3_SPIMASTER_DATAORDER    1
            //<o0> Data Bit Inversion <0=> Disable
            //                        <1=> Enable
            #define CONF_URT3_SPIMASTER_DATAINV      0
        //</h>
        //<h> Buad Rate
            //<o0> Baud-Rate calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT3_SPIMASTER_BR_CALC      0
            //<h> Static Calculation
                //<o0> Baud-rate Generator Mode <0=> Separated 
                //                               <1=> Combined
                #define CONF_URT3_SPIMASTER_BR_MDS   1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT3_SPIMASTER_BR_CKSEL 0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT3_SPIMASTER_BR_PRE   0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT3_SPIMASTER_BR_BR    49
                //<o0> Oversampling (3~31)<3-31>
                #define CONF_URT3_SPIMASTER_BR_OS    24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-12000000)Hz<400-12000000>
                #define CONF_URT3_SPIMASTER_BR       9600
            //</h>
        //</h>
        //<h> Advanced       
           //<o0> TX (MOSI) and RX (MISO) Pin Swap <0=> Disable
           //                                      <1=> Enable
           #define CONF_URT3_SPIMASTER_PINSWAP       0
        //</h>  
    #endif        
    //</h>
    //In URT3 of the Device no support the SPI slave mode.
    #define CONF_URT3_SPISLAVE_CPOL        0        
    #define CONF_URT3_SPISLAVE_CPHA        0            
    #define CONF_URT3_SPISLAVE_DATAORDER   1
    #define CONF_URT3_SPISLAVE_DATAINV     0
    #define CONF_URT3_SPISLAVE_BR_CALC     0
    #define CONF_URT3_SPISLAVE_BR_MDS      1
    #define CONF_URT3_SPISLAVE_BR_CKSEL    0  
    #define CONF_URT3_SPISLAVE_BR_PRE      0
    #define CONF_URT3_SPISLAVE_BR_BR       49
    #define CONF_URT3_SPISLAVE_BR_OS       24
    #define CONF_URT3_SPISLAVE_BR          9600
    #define CONF_URT3_SPISLAVE_PINSWAP     0 
    //<h> SC Mode Configure
    #if 1
        //<o0>Default Coding Convention <0x00000000=> Direct <0x00300028=> Inverse
        //<i> Direct Convention  : Data bit inverse, msb first and parity bit is odd.
        //<i> Inverse Convention : Data bit no inverse, lsb first and parity bit is even.
        #define CONF_URT3_SC_CONVENTION             0x00000000 
        //<o0>TX Guard Time (0-254)Bit <0-254>
        #define CONF_URT3_SC_GT                     0
        //<o0>RX Waiting Time (0-65535) Bit<0-65535>
        //<i> 0 is Disable
        #define CONF_URT3_SC_WT                     13
        //<h> TX Error
            //<o0> TX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT3_SC_TXERRORTIME        3 
        //</h>
        //<h> RX Error
            //<o0> RX Error Signal Length <0=> 1Bit
            //                            <1=> 2Bit
            #define CONF_URT3_SC_RXERRORSIG         0
            //<o0> RX Error Retry Time( 0 ~ 7)<0-7>
            //<i> 0 is no retry.
            #define CONF_URT3_SC_RXERRORTIME        3          
        //</h>
    #endif
    //</h>
    //<h> LIN Mode Configure
    #if 1
        //<h> Buad Rate 
            //<o0> Baud-rate Calculation <0=> Static calculation by user 
            //                           <1=> Dynamical calculation in Code
            #define CONF_URT3_LIN_BR_CALC           0
            //<h> Static Calculation
                //<o0> Baud-Rate Generator Mode <0=> Separated 
                //                              <1=> Combined
                #define CONF_URT3_LIN_BR_MDS        1
                //<o0> Baud-Rate Generator clock source <0=> PROC (CK_URTx_PR process clock from CSC)
                //                                      <2=> CK_LS
                //                                      <3=> TM00_TRGO
                //                                      <4=> EXT_CLK (external clock from URTx_ECK signal)
                #define CONF_URT3_LIN_BR_CKSEL      0 
                //<o0> Prescaler Counter (0~15)<0-15>
                #define CONF_URT3_LIN_BR_PRE        0
                //<o0> Baud-Rate Counter (0~255)<0-255>
                #define CONF_URT3_LIN_BR_BR         49
                //<o0> Oversampling (7~31)<7-31>
                #define CONF_URT3_LIN_BR_OS         24
            //</h>
            //<h> Dynamical Calculation
                //<o0> Baud-rate (400-6000000)Hz<400-6000000>
                #define CONF_URT3_LIN_BR            9600
            //</h>
            //<o0> Auto Baud Rate Calibration <0x00=> Disable
            //                                <0x02=> Enable and calibration mode is Start
            //                                <0x06=> Enable and calibratoin mode is Edge
            #define CONF_URT3_LIN_CAL               0x00
        //</h>
        //<h> Advanced
            //<o0> Break output length / detect length <0=> 13bit / 11bit 
            //                                         <1=> 16bit / 13bit
            #define CONF_URT3_LIN_BK                0
        //</h>
    #endif
    //</h>
    //<h> General Timer Mode
    #if 1
        //<e0>(1st Timer) Baud-Rate Generator Timer
        #define CONF_URT3_TM_BRT                    0
            //<o0> Timer Overflow Clock (1~4096)<1-4096>
            #define CONF_URT3_TM_BRTRLR             1
        //</e>
        //<e0>(2nd Timer)Timerout Timer
        #define CONF_URT3_TM_TMO                    0
            //<o0> Timeout Timer Overflow Clock (1~65536)<1-65536>
            #define CONF_URT3_TM_TMORLR             1
        //</e>
    #endif
    //</h>
    //<e0> Interrupt Enable (IEA)
    #define CONF_URT3_IEA                           0
    #if 1
        //<q0> Transmit Data Reg. Empty Interrupt (TX_IE)
        #define CONF_URT3_TXIE                      0
        //<q0> Transfer Complete Interrupt (TC_IE)
        #define CONF_URT3_TCIE                      0
        //<q0> Receive Data Reg. not Empty (RX_IE)
        #define CONF_URT3_RXIE                      0
        //<e0> URT General Event Detect Interrupt (UG_IE)
        #define CONF_URT3_UGFIE                     0
            //<q0> Slave Address Match Interrupt (SADR_IE) 
            #define CONF_URT3_SADRIE                0
            //<q0> Baud-Rate Generator Timer Timeout Interrupt (BRT_IE)
            #define CONF_URT3_BRTIE                 0
            //<q0> Timeout Timer Timeout Interrupt (TMO_IE)
            #define CONF_URT3_TMOIE                 0
            //<q0> Calibration Complete Interrupt (CALC_IE)
            #define CONF_URT3_CALCIE                0
        //</e>
        //<e0> Line Status Event Detect Interrupt (LS_IE)
        #define CONF_URT3_LSIE                      0       
            //<q0> Break Condition Detect Interrupt (BK_IE)
            #define CONF_URT3_BKIE                  0
            //<q0> Idle Line Detect Interrupt (IDL_IE)
            #define CONF_URT3_IDLIE                 0
            //<q0> CTS Change Detect Interrupt (CTS_IE)          
            #define CONF_URT3_CTSIE                 0
        //</e>
        //<e0> Error Event Detect Interrupt (ERR_IE)
        #define CONF_URT3_ERRIE                     0
            //<q0> Parity Error Interrupt (PE_IE)
            #define CONF_URT3_PEIE                  0
            //<q0> Frame Error Interrupt (FE_IE)
            #define CONF_URT3_FEIE                  0
            //<q0> RX Data Buffer Overrun Interrupt (ROVR_IE)
            #define CONF_URT3_ROVRIE                0
            //<q0> Receive Noised Character Error Interrupt (NCE_IE)
            #define CONF_URT3_NCEIE                 0
            //<q0> TX Error Detect Interrupt (TXE_IE)
            #define CONF_URT3_TXEIE                 0
            //<q0> Receive Timeout Interrupt (RXTMO_IE)
            #define CONF_URT3_RXTMOIE               0
            //<q0> Idle State Timeout Interrupt (IDMO_IE)
            #define CONF_URT3_IDMO_IE               0
            //<q0> Break Receive Timeout Interrupt (BKTMO_IE)
            #define CONF_URT3_BKTMOIE               0
            //<q0> Auto Baud Rate Calibration Timeout Interrupt (CALTMO_IE)
            #define CONF_URT3_CALTMOIE              0
        //</e>
    #endif
    //</e>
//</h>
// <<< end of Configuration section >>>
    
/* Define ---------------------------------------------------------------------*/ 
//MODE
#define CONF_URT_MODE_DISABLE    0x00      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_UART       0x01      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_IRDA       0x02      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_MULTI_ADR  0x03      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_MULTI_IDL  0x04      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_SPI_MASTER 0x05      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_SPI_SLAVE  0x06      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_SC         0x07      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_LIN        0x08      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_TM         0x09      /*!<Refer to datasheet to check the URT whether support the mode or not.*/
#define CONF_URT_MODE_NA         0xFA      /*!<No the URT module.*/   
    
//Status
#define CONF_URT_INIT_SUCCESS    0
#define CONF_URT_INIT_FAILURE    1
    
/* Exported variables --------------------------------------------------------*/ 
#if defined(IRQHandler_Middleware_Level_)
    #if defined(URT0_Base)
        #if CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE
            extern SPI_HandleTypeDef        mUSPI0;
        #elif CONF_URT0_MODE != CONF_URT_MODE_DISABLE && CONF_URT0_MODE!= CONF_URT_MODE_TM
            extern URT_HandleTypeDef        mURT0;
        #endif
    #endif
    #if defined(URT1_Base)
        #if CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE
            extern SPI_HandleTypeDef        mUSPI1;
        #elif CONF_URT1_MODE != CONF_URT_MODE_DISABLE && CONF_URT1_MODE != CONF_URT_MODE_TM
            extern URT_HandleTypeDef        mURT1;
        #endif
    #endif
    #if defined(URT2_Base)
        #if CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE
            extern SPI_HandleTypeDef        mUSPI2;
        #elif CONF_URT2_MODE != CONF_URT_MODE_DISABLE && CONF_URT2_MODE != CONF_URT_MODE_TM
            extern URT_HandleTypeDef        mURT2;
        #endif
    #endif
    #if defined(URT3_Base)
        #if CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE
            extern SPI_HandleTypeDef        mUSPI3;
        #elif CONF_URT3_MODE != CONF_URT_MODE_DISABLE && CONF_URT3_MODE != CONF_URT_MODE_TM
            extern URT_HandleTypeDef        mURT3;
        #endif
    #endif
    #if defined(URT4_Base)
        #if CONF_URT4_MODE == CONF_URT_MODE_UART
            extern URT_HandleTypeDef   mURT4;
        #endif
    #endif
    #if defined(URT5_Base)
        #if CONF_URT5_MODE == CONF_URT_MODE_UART
            extern URT_HandleTypeDef   mURT5;
        #endif
    #endif
    #if defined(URT6_Base)
        #if CONF_URT6_MODE == CONF_URT_MODE_UART
            extern URT_HandleTypeDef   mURT6;
        #endif
    #endif
    #if defined(URT7_Base)
        #if CONF_URT7_MODE == CONF_URT_MODE_UART
            extern URT_HandleTypeDef   mURT7;
        #endif
    #endif
#endif       
    
/* Exported functions --------------------------------------------------------*/ 
uint8_t URT_Init(void);

#if defined(URT0_Base)
    #if CONF_URT0_MODE != CONF_URT_MODE_DISABLE
        void URT0_InitCallback(void);
    #endif
#endif
#if defined(URT1_Base)
    #if CONF_URT1_MODE != CONF_URT_MODE_DISABLE
        void URT1_InitCallback(void);
    #endif
#endif
#if defined(URT2_Base)
    #if CONF_URT2_MODE != CONF_URT_MODE_DISABLE
        void URT2_InitCallback(void);
    #endif
#endif
#if defined(URT3_Base)
    #if CONF_URT3_MODE != CONF_URT_MODE_DISABLE
        void URT3_InitCallback(void);
    #endif
#endif
#if defined(URT4_Base)
    #if CONF_URT4_MODE != CONF_URT_MODE_DISABLE
        void URT4_InitCallback(void);
    #endif
#endif
#if defined(URT5_Base)
    #if CONF_URT5_MODE != CONF_URT_MODE_DISABLE
        void URT5_InitCallback(void);
    #endif
#endif
#if defined(URT6_Base)
    #if CONF_URT6_MODE != CONF_URT_MODE_DISABLE
        void URT6_InitCallback(void);
    #endif
#endif
#if defined(URT7_Base)
    #if CONF_URT7_MODE != CONF_URT_MODE_DISABLE
        void URT7_InitCallback(void);
    #endif
#endif

///@}

