


/**
 ******************************************************************************
 *
 * @file        Sample_URT0_RXIdleReload_IT.c
 * @brief       URT RX auto reload shadow buffer into data register flow
 *              when detect RX idle.
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/08/16
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *  
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 

/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_URT_DRV.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define URTX    URT0

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
void Sample_URT0_RXIdleReload_Init(void);
uint32_t Sample_URT0_RXIdleReload_IRQHandle(uint8_t *SMP_RXBuf);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/




/**
 *******************************************************************************
 * @brief	   URT RX IRQ handler.
 * @details   
 * @param[in]  SMP_RXBuf : RX data store destination.
 * @return     Receive byte in the RX interrupt.
 * @exception   
 * @note
 *******************************************************************************
 */
uint32_t Sample_URT0_RXIdleReload_IRQHandle(uint8_t *SMP_RXBuf)
{
    ctype   SMP_RXIDLBufTmp;
    uint8_t SMP_RXIDLBLen;
    uint8_t SMP_RXIDLTmp;
    
    SMP_RXIDLBLen     = URT_GetRXDataRegLevel(URTX);                      /*Read data byte number when data shadodw buffer last transfer to 
                                                                            URTx_RDAT register */
    SMP_RXIDLBufTmp.W = URT_GetRXData(URTX);                              /*Read data register value*/
    URT_ClearRxHoldFlag(URTX);                                            /* When Idle mode select Load (Force to load shadow buffer) and 
                                                                             idle load event occurs RHF (receive hold flag) will be to set, so
                                                                             has to clear the event flag.    
                                                                          */
    
    for(SMP_RXIDLTmp=0; SMP_RXIDLTmp < SMP_RXIDLBLen; SMP_RXIDLTmp++)
    {
        SMP_RXBuf[SMP_RXIDLTmp] = SMP_RXIDLBufTmp.B[SMP_RXIDLTmp];
    }
    return(SMP_RXIDLBLen);
}
/**
 *******************************************************************************
 * @brief	   UART mode inital , configure idle detect and idle RX mode.
 * @details    
 * @return      
 * @exception   
 * @note
 *******************************************************************************
 */
void Sample_URT0_RXIdleReload_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
    
    //==Set CSC init
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 11.0592M
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->Port C/URT1 = Enable
    //Configure Peripheral On Mode Clock->URT1->Select URT1_PR Source = CK_APB(11.0592)
    
    //==Set GPIO init
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOC->Pin8/9
    //GPIO port initial is 0xFFFF
    //Pin8 mode is PPO/Pin9 mode is ODO
    //Pin8/9 pull-up resister Enable
    //Pin8/9 function URT1_TX/RX
    

    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                //Set PSR
    URT_BRG.URT_BaudRateCounterReload = 12;	                //Set RLR
    URT_BaudRateGenerator_Config(URTX, &URT_BRG);           //BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URTX, ENABLE);	              //Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URTX, URT_TXClock_Internal);	//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URTX, URT_RXClock_Internal);	//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URTX, 7);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URTX, 7);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URTX, URT_RXSMP_3TIME);
    URT_TX_Cmd(URTX, ENABLE);	                            //Enable TX
    URT_RX_Cmd(URTX, ENABLE);	                            //Enable RX
    
    
    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URTX, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URTX, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URTX, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    //---Idle detect config.---//
    URT_TimeoutMode_Select(URTX,URT_TMOMDS_URT);
    URT_TimeoutTimerClockSource_Select(URTX,URT_TMOCLK_BitTime);         /*Timeout timer clock source from RX bit time,*/
    URT_IdleDetect_Select(URTX,2);                                       /*Becase timeout timer clock source from RX bit time
                                                                          , the value unit is bit time.
                                                                          RX Idle Status : no detect next byte over 2 bit time*/
    URT_TimeroutTimer_Cmd(URTX,ENABLE);
    
    
    /*Set Data Control*/
    URT_RXShadowBufferThreshold_Select(URTX, URT_RXTH_4BYTE);            
    URT_IdlehandleMode_Select(URTX, URT_IDLEMode_Load);                  /*When detecting RX bus idle and RX data register is empty
                                                                           load RX shadow buffer into RX data register.*/
    URT_TXGuardTime_Select(URTX, 0);
    
    /*Enable URT Interrupt*/
    URT_IT_Config(URTX, URT_IT_RX, ENABLE);
    URT_ITEA_Cmd(URTX, ENABLE);
    NVIC_EnableIRQ(URT0_IRQn);

    /*Enable URT*/
    URT_Cmd(URTX, ENABLE);
    
}








