
/**
 ******************************************************************************
 *
 * @file        Sample_APB_IR_Receive.h
 *
 * @brief       Sample APB IR Config Head File 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer 
 *      The Demo software is provided "AS IS"  without any warranty, either 
 *      expressed or implied, including, but not limited to, the implied warranties 
 *      of merchantability and fitness for a particular purpose.  The author will 
 *      not be liable for any special, incidental, consequential or indirect 
 *      damages due to loss of data or any other reason. 
 *      These statements agree with the world wide and local dictated laws about 
 *      authorship and violence against these laws. 
 ******************************************************************************
 *******************************************************************************
 */


#ifndef _Sample_APB_IR_Receive_H
#define	_Sample_APB_IR_Receive_H

/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***

//<h> IR Receive Protocol Select
//<o> IR Receive Protocol List
//<0=> NEC
//<1=> Panasonic
//<i> IR receive protocol select
//</h>
#define IR_Receive_Protocol_SEL 0

//<h> Lead & Repeat Code Configuration

//<o> Lead Carrier Waveform Minimum Definition <350-900:10>
//<i> The minimum carrier waveform of lead code.
//<i> Default : 450
#define APB_IR_LEAD_CW_MIN      450    

//<o> Lead Carrier Waveform Maximum Definition <900-1350:10>
//<i> The maximum carrier waveform of lead code.
//<i> Default : 1350
#define APB_IR_LEAD_CW_MAX      1350    

//<o> Lead OFF Waveform Minimum Definition <225-450:1>
//<i> The minimum off waveform of lead code.
//<i> Default : 225
#define APB_IR_LEAD_OW_MIN      225       

//<o> Lead OFF Waveform Maximum Definition <450-675:1>
//<i> The maximum off waveform of lead code.
//<i> 675
#define APB_IR_LEAD_OW_MAX      675       

//<o> Repeat Carrier Waveform Minimum Definition <350-900:10>
//<i> The minimum carrier waveform of repeat code
//<i> Default : 350
#define APB_IR_Repeat_CW_MIN    350       

//<o> Repeat Carrier Waveform Maximum Definition <900-1350:10>
//<i> The maximum carrier waveform of repeat code
//<i> Default : 1460
#define APB_IR_REPEAT_CW_MAX    1350       

//<o> Repeat OFF Waveform Minimum Definition <125-250:1>
//<i> The minimum off waveform of repeat code
//<i> Default : 125
#define APB_IR_REPEAT_OW_MIN    125       

//<o> Repeat OFF Waveform Maximum Definition <250-375:1>
//<i> The maximum off waveform of repeat code
//<i> Default : 375
#define APB_IR_REPEAT_OW_MAX    375       

//</h>

//<h> Data Carrier / Off Waveform Minimum & Maximum Definition

//<o> The Minimum Logic High Carrier Wavform Definition <28-56:1>
//<i> The minimum carrier waveform of data logic high
//<i> Default : 28
#define APB_IR_CW_LOGIC_H_MIN  28

//<o> The Maximum Logic High Carrier Wavform Definition <56-84:1>
//<i> The maximum carrier waveform of data logic high
//<i> Default : 84
#define APB_IR_CW_LOGIC_H_MAX 84

//<o> The Minimum Logic High OFF Wavform Definition <84-168:1>
//<i> The minimum off waveform of data logic high
//<i> Default : 84
#define APB_IR_OW_LOGIC_H_MIN  84

//<o> The Maximum Logic High OFF Wavform Definition <168-252:1>
//<i> The maximum off waveform of data logic high
//<i> Default : 252
#define APB_IR_OW_LOGIC_H_MAX 252

//<o> The Minimum Logic Low Carrier Wavform Definition <28-56:1>
//<i> The minimum carrier waveform of data logic low
//<i> Default : 28
#define APB_IR_CW_LOGIC_L_MIN  28

//<o> The Maximum Logic Low Carrier Wavform Definition <56-84:1>
//<i> The Maximum carrier waveform of data logic high
//<i> Default : 84
#define APB_IR_CW_LOGIC_L_MAX  84

//<o> The Minimum Logic Low OFF Wavform Definition <28-56:1>
//<i> The minimum off waveform of data logic low
//<i> Default : 28
#define APB_IR_OW_LOGIC_L_MIN  28

//<o> The Maximum Logic Low OFF Wavform Definition <56-84:1>
//<i> The Maximum off waveform of data logic high
//<i> Default : 84
#define APB_IR_OW_LOGIC_L_MAX  84

//</h>


//*** <<< end of configuration section >>>    ***

/* Private typedef -----------------------------------------------------------*/
/**
 * @struct  Sample_APB_IRReceiveTypeDef
 * @brief   IR receive globe variable struct definition
 */
///@{ 
typedef struct
{
    uint32_t IRDATA;                    /*!< IR receive word data definition */
    uint32_t REBUFF;                    /*!< IR repeat data buffer definition */
    uint8_t datacnt;                    /*!< IR receive data decode count definition */
    uint8_t recnt;                      /*!< IR repeat data bit count definition */
    uint8_t STARTF;                     /*!< Start decode IR receive data flag */
    uint8_t RX_CNT;                     /*!< IR receive data count */
    uint8_t RXEF;                       /*!< IR input IRQ flag definition */
    uint8_t IRRXF;                      /*!< IR data input flag */
    uint16_t RXDATA[2];                 /*!< Receive data pulse width count value buffer */
    uint8_t ircnt;                      /*!< Input data counter */
    uint8_t RXSTAT;                     /*!< Start code received flag */
}Sample_APB_IRReceiveTypeDef;
///@}

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
/**
 * @name External APB IR receive variable struct definition
 * 
 */
///@{ 
extern Sample_APB_IRReceiveTypeDef dIR;
///@} 

#endif

