/**
 ******************************************************************************
 *
 * @file        MG32_CMP_Init.H
 *
 * @brief       This file is to configure CMP baudrate setting.
 *              Device : MG32F02A132/A072
 * @par         Project
 *              MG32 
 * @version     V1.02
 * @date        2023/03/31
 * @author      MG32CoGen 
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par     Disclaimer 
 *    The Demo software is provided "AS IS"  without any warranty, either 
 *    expressed or implied, including, but not limited to, the implied warranties 
 *    of merchantability and fitness for a particular purpose.  The author will 
 *    not be liable for any special, incidental, consequential or indirect 
 *    damages due to loss of data or any other reason. 
 *    These statements agree with the world wide and local dictated laws about 
 *    authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_CMP_INIT_H
 
#define _MG32_CMP_INIT_H

#include "MG32_CMP_DRV.h"
#if defined(IRQHandler_Middleware_Level_)       
    #include "MG32_CMP_MID.h"
#endif

// <<< Use Configuration Wizard in Context Menu >>>

//<e0.0> Module - Mode Active
    #define CONF_CMP_MODE                                   0x00000000
//  <e0.0> CMP0 Config
//      <i> The chip builds in one CMP module which embeds four general purpose analog comparators with flexible
//      <i> input multiplexer, internal voltage references of R-ladder and independent digital synchronized filter for
//      <i> each analog comparator. 
    #define CONF_CMP_CR0_AC0_EN                             0x00000000
//
//      <o0.8..10> CMP0 Analog input positive channel selection <0=> IVREF <1=> CMP0_I0 (PA8) <2=> CMP0_I1 (PA9) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR0_PMUX                           0x00000000
//      <o0.12..14> CMP0 Analog input negative channel selection <0=> IVREF <1=> CMP0_I0 (PA8) <2=> CMP0_I1 (PA9) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR0_NMUX                           0x00000000
//      <o0.3> CMP0 compare response time <0=> Normal <1=> Slow (Low Power)
        #define CONF_CMP_CR0_RES                            0x00000000
//      <o0.16> Inverse analog comparator polarity <0=> Normal (Positive) <1=> Inverse (Negative)
        #define CONF_CMP_CR0_INV                            0x00000000
//      <o0.17> Inverse analog comparator output pin <0=> Disable <1=> Inverse to Pin
        #define CONF_CMP_CR0_PINV                           0x00000000
//      <h> Analog comparator's clock filter
//          <i> If user don't enable clock filter function it means "Bypass".
//          <o0.18..19> Filter Clock Divider <0=> DIV1 <1=> DIV2 <2=> DIV4 <3=>DIV8
                        #define CONF_CMP_CR0_FDIV           0x00000000
//          <o0.20..21> Filter 3 clocks by the filter clock <0=> Bypass <1=> CMP_CK <2=> TM00_TRGO <3=> TM01_TRGO
                        #define CONF_CMP_CR0_FSEL           0x00000000
//      </h>
//  </e>
//  <e0.0> CMP1 Config
//      <i> The chip builds in one CMP module which embeds four general purpose analog comparators with flexible
//      <i> input multiplexer, internal voltage references of R-ladder and independent digital synchronized filter for
//      <i> each analog comparator. 
    #define CONF_CMP_CR1_AC1_EN                             0x00000000
//
//      <o0.8..10> CMP1 Analog input positive channel selection <0=> IVREF2 <1=> CMP1_I0 (PA10) <2=> CMP1_I1 (PA11) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR1_PMUX                           0x00000000
//      <o0.12..14> CMP1 Analog input negative channel selection <0=> IVREF2 <1=> CMP1_I0 (PA10) <2=> CMP1_I1 (PA11) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR1_NMUX                           0x00000000
//      <o0.3> CMP1 compare response time <0=> Normal <1=> Slow (Low Power)
        #define CONF_CMP_CR1_RES                            0x00000000
//      <o0.16> Inverse analog comparator polarity <0=> Normal (Positive) <1=> Inverse (Negative)
        #define CONF_CMP_CR1_INV                            0x00000000
//      <o0.17> Inverse analog comparator output pin <0=> Disable <1=> Inverse to Pin
        #define CONF_CMP_CR1_PINV                           0x00000000
//      <h> Analog comparator's clock filter
//          <i> If user don't enable clock filter function it means "Bypass".
//          <o0.18..19> Filter Clock Divider <0=> DIV1 <1=> DIV2 <2=> DIV4 <3=>DIV8
                        #define CONF_CMP_CR1_FDIV           0x00000000
//          <o0.20..21> Filter 3 clocks by the filter clock <0=> Bypass <1=> CMP_CK <2=> TM00_TRGO <3=> TM01_TRGO
                        #define CONF_CMP_CR1_FSEL           0x00000000
//      </h>
//  </e>
//  <e0.0> CMP2 Config
//      <i> The chip builds in one CMP module which embeds four general purpose analog comparators with flexible
//      <i> input multiplexer, internal voltage references of R-ladder and independent digital synchronized filter for
//      <i> each analog comparator. 
    #define CONF_CMP_CR2_AC2_EN                             0x00000000
//
//      <o0.8..10> CMP2 Analog input positive channel selection <0=> IVREF2 <1=> CMP2_I0 (PA12) <2=> CMP2_I1 (PA13) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR2_PMUX                           0x00000000
//      <o0.12..14> CMP2 Analog input negative channel selection <0=> IVREF2 <1=> CMP2_I0 (PA12) <2=> CMP2_I1 (PA13) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR2_NMUX                           0x00000000
//      <o0.3> CMP2 compare response time <0=> Normal <1=> Slow (Low Power)
        #define CONF_CMP_CR2_RES                            0x00000000
//      <o0.16> Inverse analog comparator polarity <0=> Normal (Positive) <1=> Inverse (Negative)
        #define CONF_CMP_CR2_INV                            0x00000000
//      <o0.17> Inverse analog comparator output pin <0=> Disable <1=> Inverse to Pin
        #define CONF_CMP_CR2_PINV                           0x00000000
//      <h> Analog comparator's clock filter
//          <i> If user don't enable clock filter function it means "Bypass".
//          <o0.18..19> Filter Clock Divider <0=> DIV1 <1=> DIV2 <2=> DIV4 <3=>DIV8
                        #define CONF_CMP_CR2_FDIV           0x00000000
//          <o0.20..21> Filter 3 clocks by the filter clock <0=> Bypass <1=> CMP_CK <2=> TM00_TRGO <3=> TM01_TRGO
                        #define CONF_CMP_CR2_FSEL           0x00000000
//      </h>
//  </e>
//  <e0.0> CMP3 Config
//      <i> The chip builds in one CMP module which embeds four general purpose analog comparators with flexible
//      <i> input multiplexer, internal voltage references of R-ladder and independent digital synchronized filter for
//      <i> each analog comparator. 
    #define CONF_CMP_CR3_AC3_EN                             0x00000000
//
//      <o0.8..10> CMP3 Analog input positive channel selection <0=> IVREF2 <1=> CMP3_I0 (PA14) <2=> CMP3_I1 (PA15) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR3_PMUX                           0x00000000
//      <o0.12..14> CMP3 Analog input negative channel selection <0=> IVREF2 <1=> CMP3_I0 (PA14) <2=> CMP3_I1 (PA15) <3=> CMP_C0 (PB0) <4=> CMP_C1 (PB1) <5=> LDO_Core
        #define CONF_CMP_CR3_NMUX                           0x00000000
//      <o0.3> CMP3 compare response time <0=> Normal <1=> Slow (Low Power)
        #define CONF_CMP_CR3_RES                            0x00000000
//      <o0.16> Inverse analog comparator polarity <0=> Normal (Positive) <1=> Inverse (Negative)
        #define CONF_CMP_CR3_INV                            0x00000000
//      <o0.17> Inverse analog comparator output pin <0=> Disable <1=> Inverse to Pin
        #define CONF_CMP_CR3_PINV                           0x00000000
//      <h> Analog comparator's clock filter
//          <i> If user don't enable clock filter function it means "Bypass".
//          <o0.18..19> Filter Clock Divider <0=> DIV1 <1=> DIV2 <2=> DIV4 <3=>DIV8
                        #define CONF_CMP_CR3_FDIV           0x00000000
//          <o0.20..21> Filter 3 clocks by the filter clock <0=> Bypass <1=> CMP_CK <2=> TM00_TRGO <3=> TM01_TRGO
                        #define CONF_CMP_CR3_FSEL           0x00000000
//      </h>
//  </e>
//    <h> Analog Control
//      <e0.0> IVREF Config
        #define CONF_CMP_ANA_IVREF_EN                       0x00000000
//      <o0.2..7> Analog comparator main internal reference (R-ladder:0~63) 
//                  <0=>  0/63 IVRT   <1=>  1/63 IVRT   <2=>  2/63 IVRT   <3=>  3/63 IVRT   <4=>  4/63 IVRT     
//                  <5=>  5/63 IVRT   <6=>  6/63 IVRT   <7=>  7/63 IVRT   <8=>  8/63 IVRT   <9=>  9/63 IVRT     
//                  <10=> 10/63 IVRT  <11=> 11/63 IVRT  <12=> 12/63 IVRT  <13=> 13/63 IVRT  <14=> 14/63 IVRT      
//                  <15=> 15/63 IVRT  <16=> 16/63 IVRT  <17=> 17/63 IVRT  <18=> 18/63 IVRT  <19=> 19/63 IVRT      
//                  <20=> 20/63 IVRT  <21=> 21/63 IVRT  <22=> 22/63 IVRT  <23=> 23/63 IVRT  <24=> 24/63 IVRT      
//                  <25=> 25/63 IVRT  <26=> 26/63 IVRT  <27=> 27/63 IVRT  <28=> 28/63 IVRT  <29=> 29/63 IVRT      
//                  <30=> 30/63 IVRT  <31=> 31/63 IVRT  <32=> 32/63 IVRT  <33=> 33/63 IVRT  <34=> 34/63 IVRT      
//                  <35=> 35/63 IVRT  <36=> 36/63 IVRT  <37=> 37/63 IVRT  <38=> 38/63 IVRT  <39=> 39/63 IVRT      
//                  <40=> 40/63 IVRT  <41=> 41/63 IVRT  <42=> 42/63 IVRT  <43=> 43/63 IVRT  <44=> 44/63 IVRT      
//                  <45=> 45/63 IVRT  <46=> 46/63 IVRT  <47=> 47/63 IVRT  <48=> 48/63 IVRT  <49=> 49/63 IVRT      
//                  <50=> 50/63 IVRT  <51=> 51/63 IVRT  <52=> 52/63 IVRT  <53=> 53/63 IVRT  <54=> 54/63 IVRT      
//                  <55=> 55/63 IVRT  <56=> 56/63 IVRT  <57=> 57/63 IVRT  <58=> 58/63 IVRT  <59=> 59/63 IVRT      
//                  <60=> 60/63 IVRT  <61=> 61/63 IVRT  <62=> 62/63 IVRT  <63=> 63/63 IVRT      
        #define CONF_CMP_ANA_IVREF_RS                       0x00000000
//          </e>                
//      <e0.8> IVREF2 Config
        #define CONF_CMP_ANA_IVREF_EN2                      0x00000000
//      <o0.10..15> Analog comparator 2nd internal reference (R-ladder:0~63) 
//                  <0=>  0/63 IVRT   <1=>  1/63 IVRT   <2=>  2/63 IVRT   <3=>  3/63 IVRT   <4=>  4/63 IVRT     
//                  <5=>  5/63 IVRT   <6=>  6/63 IVRT   <7=>  7/63 IVRT   <8=>  8/63 IVRT   <9=>  9/63 IVRT     
//                  <10=> 10/63 IVRT  <11=> 11/63 IVRT  <12=> 12/63 IVRT  <13=> 13/63 IVRT  <14=> 14/63 IVRT      
//                  <15=> 15/63 IVRT  <16=> 16/63 IVRT  <17=> 17/63 IVRT  <18=> 18/63 IVRT  <19=> 19/63 IVRT      
//                  <20=> 20/63 IVRT  <21=> 21/63 IVRT  <22=> 22/63 IVRT  <23=> 23/63 IVRT  <24=> 24/63 IVRT      
//                  <25=> 25/63 IVRT  <26=> 26/63 IVRT  <27=> 27/63 IVRT  <28=> 28/63 IVRT  <29=> 29/63 IVRT      
//                  <30=> 30/63 IVRT  <31=> 31/63 IVRT  <32=> 32/63 IVRT  <33=> 33/63 IVRT  <34=> 34/63 IVRT      
//                  <35=> 35/63 IVRT  <36=> 36/63 IVRT  <37=> 37/63 IVRT  <38=> 38/63 IVRT  <39=> 39/63 IVRT      
//                  <40=> 40/63 IVRT  <41=> 41/63 IVRT  <42=> 42/63 IVRT  <43=> 43/63 IVRT  <44=> 44/63 IVRT      
//                  <45=> 45/63 IVRT  <46=> 46/63 IVRT  <47=> 47/63 IVRT  <48=> 48/63 IVRT  <49=> 49/63 IVRT      
//                  <50=> 50/63 IVRT  <51=> 51/63 IVRT  <52=> 52/63 IVRT  <53=> 53/63 IVRT  <54=> 54/63 IVRT      
//                  <55=> 55/63 IVRT  <56=> 56/63 IVRT  <57=> 57/63 IVRT  <58=> 58/63 IVRT  <59=> 59/63 IVRT      
//                  <60=> 60/63 IVRT  <61=> 61/63 IVRT  <62=> 62/63 IVRT  <63=> 63/63 IVRT      
        #define CONF_CMP_ANA_IVREF_RS2                      0x00000000
//          </e>                
//    </h> 
//  </e>

//<e0.0> Analog comparator interrupt all enable (CMP_IEA)
            #define CONF_CMP_INT_IEA                        0x00000000
//    <q0.2> Analog comparator CMP0 rising edge interrupt (AC0_RIE)
            #define CONF_CMP_INT_AC0_RIE                    0x00000000
//    <q0.3> Analog comparator CMP0 falling edge interrupt (AC0_FIE)
            #define CONF_CMP_INT_AC0_FIE                    0x00000000
//    <q0.6> Analog comparator CMP1 rising edge interrupt (AC1_RIE)
            #define CONF_CMP_INT_AC1_RIE                    0x00000000
//    <q0.7> Analog comparator CMP1 falling edge interrupt (AC1_FIE)
            #define CONF_CMP_INT_AC1_FIE                    0x00000000
//    <q0.10> Analog comparator CMP2 rising edge interrupt (AC2_RIE)
            #define CONF_CMP_INT_AC2_RIE                    0x00000000
//    <q0.11> Analog comparator CMP2 falling edge interrupt (AC2_FIE)
            #define CONF_CMP_INT_AC2_FIE                    0x00000000
//    <q0.14> Analog comparator CMP3 rising edge interrupt (AC3_RIE)
            #define CONF_CMP_INT_AC3_RIE                    0x00000000
//    <q0.15> Analog comparator CMP3 falling edge interrupt (AC3_FIE)
            #define CONF_CMP_INT_AC3_FIE                    0x00000000
//</e>
// <<< end of Configuration section >>>

    // ------------------------------------------------------------------------
    // Combined with CMP_INT register bit function
    #if defined(CONF_CMP_INT_AC2_RIE)
    #define CONF_CMP_INT    (CONF_CMP_INT_IEA       |\
                             CONF_CMP_INT_AC0_RIE   |\
                             CONF_CMP_INT_AC0_FIE   |\
                             CONF_CMP_INT_AC1_RIE   |\
                             CONF_CMP_INT_AC1_FIE   |\
                             CONF_CMP_INT_AC2_RIE   |\
                             CONF_CMP_INT_AC2_FIE   |\
                             CONF_CMP_INT_AC3_RIE   |\
                             CONF_CMP_INT_AC3_FIE)
    #else
    #define CONF_CMP_INT    (CONF_CMP_INT_IEA       |\
                             CONF_CMP_INT_AC0_RIE   |\
                             CONF_CMP_INT_AC0_FIE   |\
                             CONF_CMP_INT_AC1_RIE   |\
                             CONF_CMP_INT_AC1_FIE)
    #endif                         
        
    // ------------------------------------------------------------------------
    // Combined with CMP_ANA register bit function
    #if defined(CONF_CMP_ANA_IVREF_SEL)
    #define CONF_CMP_ANA    (CONF_CMP_ANA_IVREF_EN  |\
                             CONF_CMP_ANA_IVREF_RS  |\
                             CONF_CMP_ANA_IVREF_SEL |\
                             CONF_CMP_ANA_IVREF_EN2 |\
                             CONF_CMP_ANA_IVREF_RS2 |\
                             CONF_CMP_ANA_IVREF2_SEL)
    #else                        
    #define CONF_CMP_ANA    (CONF_CMP_ANA_IVREF_EN  |\
                             CONF_CMP_ANA_IVREF_RS  |\
                             CONF_CMP_ANA_IVREF_EN2 |\
                             CONF_CMP_ANA_IVREF_RS2 )
    #endif                         
                             
    // ------------------------------------------------------------------------
    // Combined with CMP_CR0 register bit function
    #if defined(CONF_CMP_CR0_IVROE)
    #define CONF_CMP_CR0    (CONF_CMP_CR0_PMUX      |\
                             CONF_CMP_CR0_NMUX      |\
                             CONF_CMP_CR0_AC0_EN    |\
                             CONF_CMP_CR0_RES       |\
                             CONF_CMP_CR0_HYS       |\
                             CONF_CMP_CR0_INV       |\
                             CONF_CMP_CR0_PINV      |\
                             CONF_CMP_CR0_FDIV      |\
                             CONF_CMP_CR0_FSEL      |\
                             CONF_CMP_CR0_IVROE     ) 
    #elif defined(CONF_CMP_CR0_HYS)
    #define CONF_CMP_CR0    (CONF_CMP_CR0_PMUX      |\
                             CONF_CMP_CR0_NMUX      |\
                             CONF_CMP_CR0_AC0_EN    |\
                             CONF_CMP_CR0_RES       |\
                             CONF_CMP_CR0_HYS       |\
                             CONF_CMP_CR0_INV       |\
                             CONF_CMP_CR0_PINV      |\
                             CONF_CMP_CR0_FDIV      |\
                             CONF_CMP_CR0_FSEL      ) 
    #else                        
    #define CONF_CMP_CR0    (CONF_CMP_CR0_PMUX      |\
                             CONF_CMP_CR0_NMUX      |\
                             CONF_CMP_CR0_AC0_EN    |\
                             CONF_CMP_CR0_RES       |\
                             CONF_CMP_CR0_INV       |\
                             CONF_CMP_CR0_PINV      |\
                             CONF_CMP_CR0_FDIV      |\
                             CONF_CMP_CR0_FSEL      ) 
    #endif                         
                             
    // ------------------------------------------------------------------------
    // Combined with CMP_CR1 register bit function
    #if defined(CONF_CMP_CR1_IVROE)
    #define CONF_CMP_CR1    (CONF_CMP_CR1_PMUX      |\
                             CONF_CMP_CR1_NMUX      |\
                             CONF_CMP_CR1_AC1_EN    |\
                             CONF_CMP_CR1_RES       |\
                             CONF_CMP_CR1_HYS       |\
                             CONF_CMP_CR1_INV       |\
                             CONF_CMP_CR1_PINV      |\
                             CONF_CMP_CR1_FDIV      |\
                             CONF_CMP_CR1_FSEL      |\
                             CONF_CMP_CR1_IVROE     ) 
    #elif defined(CONF_CMP_CR1_HYS)
    #define CONF_CMP_CR1    (CONF_CMP_CR1_PMUX      |\
                             CONF_CMP_CR1_NMUX      |\
                             CONF_CMP_CR1_AC1_EN    |\
                             CONF_CMP_CR1_RES       |\
                             CONF_CMP_CR1_HYS       |\
                             CONF_CMP_CR1_INV       |\
                             CONF_CMP_CR1_PINV      |\
                             CONF_CMP_CR1_FDIV      |\
                             CONF_CMP_CR1_FSEL      ) 
    #else                        
    #define CONF_CMP_CR1    (CONF_CMP_CR1_PMUX      |\
                             CONF_CMP_CR1_NMUX      |\
                             CONF_CMP_CR1_AC1_EN    |\
                             CONF_CMP_CR1_RES       |\
                             CONF_CMP_CR1_INV       |\
                             CONF_CMP_CR1_PINV      |\
                             CONF_CMP_CR1_FDIV      |\
                             CONF_CMP_CR1_FSEL      ) 
    #endif                         

    // ------------------------------------------------------------------------
    // Combined with CMP_CR2 register bit function
    #if defined(CONF_CMP_CR2_PMUX)
    #define CONF_CMP_CR2    (CONF_CMP_CR2_PMUX      |\
                             CONF_CMP_CR2_NMUX      |\
                             CONF_CMP_CR2_AC2_EN    |\
                             CONF_CMP_CR2_RES       |\
                             CONF_CMP_CR2_INV       |\
                             CONF_CMP_CR2_PINV      |\
                             CONF_CMP_CR2_FDIV      |\
                             CONF_CMP_CR2_FSEL      ) 
                             
    // ------------------------------------------------------------------------
    // Combined with CMP_CR3 register bit function
    #define CONF_CMP_CR3    (CONF_CMP_CR3_PMUX      |\
                             CONF_CMP_CR3_NMUX      |\
                             CONF_CMP_CR3_AC3_EN    |\
                             CONF_CMP_CR3_RES       |\
                             CONF_CMP_CR3_INV       |\
                             CONF_CMP_CR3_PINV      |\
                             CONF_CMP_CR3_FDIV      |\
                             CONF_CMP_CR3_FSEL      ) 
    #endif                         

        
    // ------------------------------------------------------------------------
    // Assemble mCMP structure within Middleware level
    // ------------------------------------------------------------------------


    // ------------------------------------------------------------------------
    // COMP Inverting Input Select
    #define mCMP_AC0_InvertingInput_Select          CONF_CMP_CR0_NMUX
    #define mCMP_AC1_InvertingInput_Select          CONF_CMP_CR1_NMUX
    #if defined(CONF_CMP_CR2_NMUX)
        #define mCMP_AC2_InvertingInput_Select      CONF_CMP_CR2_NMUX
        #define mCMP_AC3_InvertingInput_Select      CONF_CMP_CR3_NMUX
    #endif

    // ------------------------------------------------------------------------
    // COMP NonInverting Input Select
    #define mCMP_AC0_NonInvertingInput_Select       CONF_CMP_CR0_PMUX
    #define mCMP_AC1_NonInvertingInput_Select       CONF_CMP_CR1_PMUX
    #if defined(CONF_CMP_CR2_NMUX)
        #define mCMP_AC2_NonInvertingInput_Select   CONF_CMP_CR2_PMUX
        #define mCMP_AC3_NonInvertingInput_Select   CONF_CMP_CR3_PMUX
    #endif

    // ------------------------------------------------------------------------
    // COMP Polarity Input Select
    #define mCMP_AC0_Polarity_Select                CONF_CMP_CR0_INV 
    #define mCMP_AC1_Polarity_Select                CONF_CMP_CR1_INV 
    #if defined(CONF_CMP_CR2_NMUX)
        #define mCMP_AC2_Polarity_Select            CONF_CMP_CR2_INV 
        #define mCMP_AC3_Polarity_Select            CONF_CMP_CR3_INV 
    #endif

    // ------------------------------------------------------------------------
    // COMP Output Polarity Select
    #define mCMP_AC0_OutputPolarity_Select          CONF_CMP_CR0_PINV 
    #define mCMP_AC1_OutputPolarity_Select          CONF_CMP_CR1_PINV 
    #if defined(CONF_CMP_CR2_NMUX)                         
        #define mCMP_AC2_OutputPolarity_Select      CONF_CMP_CR2_PINV 
        #define mCMP_AC3_OutputPolarity_Select      CONF_CMP_CR3_PINV 
    #endif

    // ------------------------------------------------------------------------
    // COMP Hysteresis level Select
    #if defined(CONF_CMP_CR0_HYS)
        #define mCMP_AC0_Hysteresis_Select          CONF_CMP_CR0_HYS 
        #define mCMP_AC1_Hysteresis_Select          CONF_CMP_CR1_HYS 
        #if defined(CONF_CMP_CR2_NMUX)                        
            #define mCMP_AC2_Hysteresis_Select      CONF_CMP_CR2_HYS 
            #define mCMP_AC3_Hysteresis_Select      CONF_CMP_CR3_HYS 
        #endif  
    #else   
        #define mCMP_AC0_Hysteresis_Select          0 
        #define mCMP_AC1_Hysteresis_Select          0 
        #if defined(CONF_CMP_CR2_NMUX)                        
            #define mCMP_AC2_Hysteresis_Select      0 
            #define mCMP_AC3_Hysteresis_Select      0 
        #endif
    #endif

    // ------------------------------------------------------------------------
    // COMP Response time level Select
    #define mCMP_AC0_ResponseTime_Select            CONF_CMP_CR0_RES
    #define mCMP_AC1_ResponseTime_Select            CONF_CMP_CR1_RES
    #if defined(CONF_CMP_CR2_NMUX)                          
        #define mCMP_AC2_ResponseTime_Select        CONF_CMP_CR2_RES
        #define mCMP_AC3_ResponseTime_Select        CONF_CMP_CR3_RES
    #endif

    // ------------------------------------------------------------------------
    // COMP Interrupt Source Select
    #define mCMP_AC0_IT_Select                      (CONF_CMP_INT_AC0_RIE | CONF_CMP_INT_AC0_FIE)
    #define mCMP_AC1_IT_Select                      (CONF_CMP_INT_AC1_RIE | CONF_CMP_INT_AC1_FIE) >> 4
    #if defined(CONF_CMP_CR2_NMUX)                                                     
        #define mCMP_AC2_IT_Select                  (CONF_CMP_INT_AC2_RIE | CONF_CMP_INT_AC2_FIE) >> 8
        #define mCMP_AC3_IT_Select                  (CONF_CMP_INT_AC3_RIE | CONF_CMP_INT_AC3_FIE) >> 12
    #endif

    // ------------------------------------------------------------------------
    // COMP Output Sync Select
    #define mCMP_AC0_OutputSync_Select              CONF_CMP_CR0_FSEL
    #define mCMP_AC1_OutputSync_Select              CONF_CMP_CR1_FSEL
    #if defined(CONF_CMP_CR2_NMUX)                                             
        #define mCMP_AC2_OutputSync_Select          CONF_CMP_CR2_FSEL
        #define mCMP_AC3_OutputSync_Select          CONF_CMP_CR3_FSEL
    #endif

    // ------------------------------------------------------------------------
    // COMP Sync Filter DIV Select
    #define mCMP_AC0_SyncFilterDIV_Select           CONF_CMP_CR0_FDIV
    #define mCMP_AC1_SyncFilterDIV_Select           CONF_CMP_CR1_FDIV
    #if defined(CONF_CMP_CR2_NMUX)                                          
        #define mCMP_AC2_SyncFilterDIV_Select       CONF_CMP_CR2_FDIV
        #define mCMP_AC3_SyncFilterDIV_Select       CONF_CMP_CR3_FDIV
    #endif

    // ------------------------------------------------------------------------
    // COMP IntVREF0_Level Select
    #define mCMP_VREF_Level_Select                  CONF_CMP_ANA_IVREF_RS >> 2
        
    // COMP IntVREF1_Level Select   
    #define mCMP_VREF2_Level_Select                 CONF_CMP_ANA_IVREF_RS2 >> 10


/**
 * @name  Function announce
 *      
 */
///@{ 
void CMP_ACx_Init(void);

///@}
#endif  // _MG32_CMP_INIT_H

