/**
 ******************************************************************************
 *
 * @file        MG32_IEC60730_Manager.h
 *
 * @brief       This is the C code format driver head file.
 *
 * @par         Project
 *              MG32
 * @version     V1.10
 * @date        2021/01/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MG32_IEC60730_INIT_H
#define __MG32_IEC60730_INIT_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
     

/* Exported types ------------------------------------------------------------*/



//*** <<< Use Configuration Wizard in Context Menu >>> ***

// <e0> use IEC60730 after RESET
#define UseIEC60730             1
    
// <q0.0> Display information by UART0 (115200 bps N-8-1 @ 12MHz)
#define DisplayInformation      1
     
//  <q0.0> CPU register test
//      <i> The item will spend 892 bytes and 31us@12MHz
#define IEC60730_CPURegister_Option 1

//  <q0.0> CPU PC test
//      <i> The item will spend 124 bytes and 29us@12MHz
#define IEC60730_CPU_PC_Option      1

//  <q0.0> RAM test (Total Size)
//      <i> The item will spend 272 bytes and 44.5ms@12MHz with RAM 16K size
#define IEC60730_RAM_FullTest_Option    1

//  <q0.0> Clock test
//      <i> The item will spend 548 bytes and 284us@12MHz
#define IEC60730_Clock_Option       1

// <e6> Flash test
//  <h> AP space
//    <i> First time! This item will spend 736 bytes and 51ms@12MHz with AP=96K size (Calculate CRC)
//    <i> Next time! This item will spend ~26ms.
//    <o0> AP size (unit : KByte)
//    <q2> Self calculation CRC checksum on frist run
//    <o3> CRC check size(For fixed address is CRC checksum source)
//    <o4> Runtime CRC check size(64 ~ 32M)<0x40 - 0x2000000>
//    <o5> CRC mode select enable
//        <1=> CRC16 polynomial 0x1021, data input width 32Bits
//        <2=> CRC32 polynomial 0x04c11db7, data input width 32Bits
//  </h>
#define AP_Size                 26 * 1024
#define AP_SelfCalculation      1
#define AP_CheckSize            0x06800
#define AP_RuntimeCheckSize     0x00400
#define AP_CRC_Mode             2
#define IEC60730_Flash_Option   1

//  <e0> IAP space
//    <i> First time! This item will spend 736 bytes and 51ms@12MHz with AP=96K size (Calculate CRC)
//    <i> Next time! This item will spend ~26ms.
//    <o1> Size (unit : KByte)
//    <q3> Enable CRC check
//    <q4> Self calculation CRC checksum on frist run
//    <o5> Check start adddress offset(Must aligment 32Bits address)
//    <o6> CRC check size(For fixed address is CRC checksum source)
//    <o7> Runtime CRC check size(64 ~ 32M)<0x40 - 0x2000000>
//    <o8> CRC mode select enable
//        <1=> CRC16 polynomial 0x1021, data input width 32Bits
//        <2=> CRC32 polynomial 0x04c11db7, data input width 32Bits
//  </e>
#define IAP_Planning            1
#define IAP_Size                4 * 1024
#define IAP_CRCCheckEnable      0
#define IAP_SelfCalculation     0
#define IAP_CheckStartAddress   0x0000
#define IAP_CheckSize           0xFFC
#define IAP_RuntimeCheckSize    0x400
#define IAP_CRC_Mode            2
#if IAP_SelfCalculation
  #define IAP_CRCCheckSumValue  0xFFFFFFFF
#else
  #define IAP_CRCCheckSum       0x00005678
#endif

#define ISP_Size                2 * 1024



#if defined(MG32F02A132)
    #define Flash_Size    0x21000
    #define RAM_START  (uint32_t *)         0x20000000
    #define RAM_END    (uint32_t *)         0x20003FFC
#endif

#if defined(MG32F02A072)
    #define Flash_Size    0x12000
    #define RAM_START  (uint32_t *)         0x20000000
    #define RAM_END    (uint32_t *)         0x20001FFC
#endif

#if defined(MG32F02A032)
    #define Flash_Size    0x8000
    #define RAM_START  (uint32_t *)         0x20000000
    #define RAM_END    (uint32_t *)         0x20000FFC
#endif

#if defined(MA862)
    #define Flash_Size    0x12000
    #define RAM_START  (uint32_t *)         0x20000000
    #define RAM_END    (uint32_t *)         0x20001FFC
#endif

#if defined(MG32F02A128) || defined(MG32F02U128) 
    #define Flash_Size    0x20000
    #define RAM_START  (uint32_t *)         0x20000000
    #define RAM_END    (uint32_t *)         0x20003FFC
#endif

#if defined(MG32F02A064) || defined(MG32F02U064)
    #define Flash_Size    0x10000
    #define RAM_START  (uint32_t *)         0x20000000
    #define RAM_END    (uint32_t *)         0x20001FFC
#endif

#if (AP_Size + IAP_Size + ISP_Size) > Flash_Size
  #error "Flash planning size over"
#endif



//  </e>


//  <e0.0> ADC test
//    <i> The item will spend 816 bytes and 12.26048ms@12MHz
//      <o1> ADC resolution <0=> 12 bit <1=> 10 bit <2=> 8 bit
//      <o2> ADC sample channel selection <0=> PA0 <1=> PA1 <2=> PA2 <3=> PA3 
//                  <8=> PA8 <9=> PA9 <10=> PA10 <11=> PA11
//                  <12=> PA12 <13=> PA13 <14=> PA14 <15=> PA15 <0x13=> VBUF (~1.4V)
//      <O3> The Low threshold of ADC conversion result <0-4095>
//          <i> forumla: ADC result = Vinput/Vref*2^resolution
//      <O4> The High threshold of ADC conversion result <0-4095>
//          <i> forumla: ADC result = Vinput/Vref*2^resolution
//  </e>
#define IEC60730_ADC_Option             1
#define IEC60730_ADC_Resolution         0
#define IEC60730_ADC_ChannelSelection   19
#define IEC60730_ADC_Lthreshold         1000
#define IEC60730_ADC_Hthreshold         1300

//  <q0.0> IWDT test
//    <i> The item will spend 172 bytes and 6.18ms@12MHz
#define IEC60730_IWDT_Option        1

//  <q0.0> GPIO test
//    <i> The item will spend 468 bytes and 127.04us@12MHz
#define IEC60730_GPIO_Option        1

//  <q0.0> Interrupt test
//    <i> The item will spend 512 bytes 
#define IEC60730_Interrupt_Option   1

#if UseIEC60730!=0
#define IEC60730_Function   MG32_IEC60730_MANAGER
#endif

//	</e>

//*** <<< end of configuration section >>>    ***


/* Exported constants -------------------------------------------------------*/


/* Exported macro -----------------------------------------------------------*/


/* Exported functions -------------------------------------------------------*/


#endif 

