#ifndef PWM_H
#define PWM_H

#define	SWAP	0x00

enum PwmMod {ForceLow = 0, ForceHi = 1, ActiveHi = 2, ActiveLow = 3};
// <<< Use Configuration Wizard in Context Menu >>>
// <h> Set MPWMINV
	// <o.0> U INV <0=> Non-Inverse <1=> Inverse
	// <o.1> X INV <0=> Non-Inverse <1=> Inverse
	// <o.2> V INV <0=> Non-Inverse <1=> Inverse
	// <o.3> Y INV <0=> Non-Inverse <1=> Inverse
	// <o.4> W INV <0=> Non-Inverse <1=> Inverse
	// <o.5> Z INV <0=> Non-Inverse <1=> Inverse
// </h>
 #define MPWMINV_REGS 0x00
 
// <h> Set MPWMDT
	// <i> The frequency of MPWMDT is 48MHz
	// <o> Set Deadband Time 
	// <0x30=> Deadband Time 1us
	// <0x48=> Deadband Time 1.5us
	// <0x60=> Deadband Time 2us
	// <0x90=> Deadband Time 3us
	// <0xC0=> Deadband Time 4us
	// <0xF0=> Deadband Time 5us
	// <i> 0x30 : 48MHz * 48 = 1us
// </h>
#define MPWMDT_REGS 0x60 

// 1rps (rad/sec) = 1/60 rpm, w = 2Pi = 1rps
// 0 ~ 24576 q 0 ~ 360 deg
// ]w AngleBase p⤽ : AngleBase = 24512 * (1/PWM_Frequency) * (1/60) * 32767
//#define AngleBase (long) ((float)(24512 * (1/PWM_Frequency) * (1/60)) * 32767)
//#define AngleBase (long) 13386411/PWM_Frequency 

// <o> Set Base Rpm (unit : rpm)
// <i> Set Base Rpm (BaseRpm : 32767/(Pole/2))
#define BASE_RPM (32767/(POLE_PAIRS))
//#define BASE_RPM 32767


#define AngleBase (long) ((float) (BASE_RPM) * POLE/120 * 24576/PWM_Frequency)
//#define AngleBase (long) ((float) BASE_RPM * POLE/2 * 24512/PWM_Frequency/60)
//#define AngleBase (long) 13386411/PWM_Frequency //669

/* <o> Set AngleBaseShift <0-8>
#define AngleBaseShift 0 */

// <<< end of configuration section >>>

extern void PWM_SetBreakForce (void);
extern void PWM_SetBreak (void);
extern void PWM_SetAllOff (void);
extern void PWM_SetActive (void);
extern void PWM_Init (void);
extern void PWM_Duty (unsigned int duty);

#endif