#include "EasyCOM.H"
#include "UART.H"


//----- UART.C -----//
extern void Initial_UART( void );
extern void UART_Event( void );
extern void UART_Send_Data_To_Device( BYTE , BYTE * );
extern void UART_Send_Data_To_PC( void );


void USB_Event( void );


void main( void )
  { Initial();                                   // Do not remove
    Initial_UART();
    while(1)
      { if ( InFlag )                            // Data size of "InLen" is already 
          { // To do..                           // in the "InBuffer[]"
            
            UART_Send_Data_To_Device( InLen , InBuffer );
            
            USB_Read_Data_Complete();            // Do not remove
          }
        
        // To do..
        /* Will send data to PC ?? If yes , enable the following function call */
        // USB_Send_Data_To_PC( OutLen , OutBuffer );
        
        USB_Event();                             // Check USB power event
        
        UART_Event();                            // Check Uart Line/Modem event
        
        UART_Send_Data_To_PC();
      }   
  }


void USB_Event( void )                           // Do not remove
  { if ( UsbEvent.Suspend == SET )               // Power down event from HOST
      { UsbEvent.Suspend = CLR;
        // To do..
        PCON |= 0x02;                            // MCU will into PowerDown mode
        UsbEvent.WakeUp = SET;
      }
    if ( UsbEvent.WakeUp == SET )                // MCU wakeup already
      { UsbEvent.WakeUp = CLR;
      	// To do..
      }
    if ( UsbEvent.Reset == SET )                 // Reset event from HOST
      { UsbEvent.Reset = CLR;
        // To do..
      }
    if ( UsbEvent.EmuOK == SET )                 // USB enumeration OK
      { // To do..
      }
  }