#include "REG_MG84FG516.H"
#include "Define.H"
#include "Extern.H"
#include "UART.H"


BYTE OutLen = 0;
XBYTE OutBuffer[UART_MAX] _at_ (0x200-UART_MAX); // XRAM total 576(0~575) bytes ( 512~575
                                                 // for InBuffer , 448~511 for OutBuffer )
UART Uart;


void UART_Send_Data_To_PC( void )
  { if ( Uart.Data_Cnt == 0 )                    // Do Nothing
      return;

    ES0 = CLR;                                   // Disable " Uart INT " , prevent 
    if (( Uart.Out_Addr + Uart.Data_Cnt  ) > UART_MAX ) // Uart.Data_Cnt Change
      OutLen = UART_MAX - Uart.Out_Addr;         // OutBuffer boundary
    else
      OutLen = Uart.Data_Cnt;
    Uart.Data_Cnt -= OutLen;
    ES0 = SET;                                   // Enable " Uart INT "
    
    USB_Send_Data_To_PC( OutLen , ( OutBuffer+Uart.Out_Addr ));
    Uart.Out_Addr += OutLen;
    
    if ( Uart.Out_Addr == UART_MAX )             // Top of " OutBuffer "
      Uart.Out_Addr = 0;                         // Reset " Out_Addr " from 0
  }


void UART_Send_Data_To_Device( BYTE Size , BYTE *Buffer )
  { BYTE i = 0;
    
    
    while( i < Size )
      { while( Uart.Tx_Busy == SET );            // Wait Tx Complete
      	Uart.Tx_Busy = SET;
      	SBUF = Buffer[i];                        // Send data
      	i++;
      	UART_Send_Data_To_PC();
      }
  }


void Uart_Baudrate( BYTE BR )
  { switch( BR )
      { case BR_1200:   PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 &= ~T1X12;         // Fosc = Fosc/12 ( 12Mhz/12 = 1Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xE6;
                        TH1 = 0xE6;              //   
                        break;
        case BR_2400:   PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 &= ~T1X12;         // Fosc = Fosc/12 ( 12Mhz/12 = 1Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xF3;
                        TH1 = 0xF3;              //  
                        break;
        case BR_4800:   PCON0 |= SMOD1;          // SMOD1 = 1 -> Double BR
                        AUXR2 &= ~T1X12;         // Fosc = Fosc/12 ( 12Mhz/12 = 1Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xF3;
                        TH1 = 0xF3;              //  
                        break;
        case BR_9600:   PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xD9;
                        TH1 = 0xD9;              //
                        break;
        case BR_19200:  PCON0 |= SMOD1;          // SMOD1 = 1 -> Double BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xD9;
                        TH1 = 0xD9;              //
                        break;
        case BR_38400:  PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG |= SMOD2;           // SMOD2 = 1 -> Double BR
                        TL1 = 0xD9;
                        TH1 = 0xD9;              //
                        break;
        case BR_57600:  PCON0 |= SMOD1;          // SMOD1 = 1 -> Double BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xF3;
                        TH1 = 0xF3;              //
                        break;
        case BR_115200: PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG |= SMOD2;           // SMOD2 = 1 -> Double BR
                        TL1 = 0xF3;
                        TH1 = 0xF3;              //
                        break;
        case BR_7200:   PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xCC;
                        TH1 = 0xCC;              //
                        break;
        case BR_14400:  PCON0 &= ~SMOD1;         // SMOD1 = 0 -> Default BR
                        AUXR2 |= T1X12;          // Fosc = Fosc ( 12Mhz )
                        SCFG &= ~SMOD2;          // SMOD2 = 0 -> Default BR
                        TL1 = 0xE6;
                        TH1 = 0xE6;              //
                        break;
      }
  }


void Initial_UART( void )
  { Uart_Baudrate( BR_9600 );
    
    Uart.In_Addr = 0;
    Uart.Out_Addr = 0;
    Uart.Data_Cnt = 0;
    Uart.Tx_Busy = CLR;
    
    IP |= 0x10;	                                 // hi priority: UART
    
    TMOD |= 0x20;                                // Set Timer1 in Mode2 ( 8 bit )
    SCON = 0x50;                                 // Set UART work at MODE1
        
    ES0 = SET;                                   // Enable UART interrupt
    TR1 = SET;                                   // Enable Timer1 for UART
  }