/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "PrtBuf.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［PrtBuf.c］
//=========================================================================================================
//* File Name   : PrtBuf.c
//* Description : PrtBuf  Operation
//=========================================================================================================
/* 
//註解，因為PrtDriver.h有宣告了;AMO;2018.05.25
#define MaxDotPos              384 

#define NumOfCharLine            2
#define PRTBUFHIGHT             12//打印行高12个字节(bytes)
#define PRTLINEHIGHT            24//打印行高24个点
#define ONEDOTSTEPNUM            2// 2步一点行
#define HZ_WIDTH                24 //汉字横向占得点数
#define ASCII_WIDTH             12 //ascii横向占得点数
#define SFONT_WIDTH              9//small FONT横向占得点数
#define BIT_IMAGE_SIZE           5//下载logo的数量
*/

uint8_t cAsciiHightMultiple_Prt = 0;
uint8_t cChineseHightMultiple_Prt = 0;//新增 ;AMO;2018.05.25
uint8_t cAsciiWidthMultiple;//字符倍宽倍数
uint8_t cAsciiHightMultiple;//字符倍高倍数
uint8_t cAsciiRightSpace;//字符右边距
uint32_t  iLineSpaceNumber;//字符行之间点行数
uint8_t cChineseWidthMultiple;//汉字倍宽倍数
uint8_t cChineseHightMultiple;//汉字倍高倍数
uint8_t cChineseRightSpace;//汉字右边距
uint8_t cChineseLeftSpace;//汉字左边距
uint32_t  iCurrentFillColumn;//当前填充位置计数
uint8_t cCurrentFillRow;//填充行
uint8_t cCurrentPrtCharLine;//打印行
uint8_t bTimer2Prt;//打印标志位
uint8_t bTimer2FeedLine;//走行间距标志位
uint8_t bTimer2KeyFeed;//按键进纸标志位
uint8_t bChinese;//汉字模式
uint8_t bHexDump;//16进制模式
uint8_t bSelfTest;//自检模式
uint8_t bCharacterSel;//进入字符模式选择模式
uint8_t bDensitySel;//进入打印浓度设置模式
uint8_t bHaveFilledAscii;//字符行填充ASCII标志
uint8_t bHaveFilledChinese;//字符行填充汉字标志
uint8_t bHaveFilledBarCode;//字符行条码标志
uint8_t bHaveFilledRasterDot;//字符行填充光栅位图标志
uint8_t bHaveFilledImageDot;//字符行填充下载位图标志
uint8_t bFont12x24;//字符字体
uint8_t bPrtAdverse;//反白打印标志位
uint8_t bAsciiUnderLine;//ascii下划线标志位
uint8_t bChineseUnderLine;//chinese下划线标志位
uint8_t bUnderLineEffect;//下划线有效标志位
uint8_t bAlign;//打印对齐模式
uint8_t bBold;//粗体打印
uint32_t  iPrtLeftMargin;//左边距设置
uint32_t  iPrtRightMargin;//左边距加打印区域等于右边距
uint32_t  iRasterDotHight;//光栅位图的高度
uint8_t bUserChar;//用户自定义字符
uint8_t PrtConfigBuf[32];//配置参数缓存区
uint32_t  iImageDotHight;//打印图形的高度 如下载LOGE和下装点图GS *
uint8_t cCodePage;//字符代码页
uint8_t bPart1;//转换表1
uint8_t bPart2;//转换表2
uint8_t bPart3;//转换表3
uint8_t bPart4;//转换表4
uint8_t bFontBig5;//繁体
uint8_t bClearBarCode;

/*
enum enumCharLineStatus{
    Empty,Filling,Printing,FeedLine,WaitForPrint
};
*/
/*
enum ALIGN  
{
    Align_Left,Align_Middle,Align_Right,
};
*/
/*
enum enumInterCharSet{
    USA,France,Germany,UK,DenmarkI,Sweden,Italy,SpainI,Japan,Norway,DenmarkII,
    //0,    1,  2,  3,  4,  5,  6,  7,  8,  9,  10
    SpainII,Latin,Korea,Croatia,China
    //11,     12 ,      13,      14,         15
};
*/

enum enumInterCharSet cInternationalCharSet;

/*//在PrtDriver.h宣告就好,這裡不用宣告了;AMO;2018.05.25
struct structByteLine{
    uint8_t BasePrtLine[MaxDotPos];
    //uint8_t cHaveData;
};
*/

/* //在PrtDriver.h宣告就好,這裡不用宣告了;AMO;2018.05.25
struct structCharLine{
    struct structByteLine ByteLine[PRTBUFHIGHT];
    uint8_t cNextCharLine;
    uint8_t bPrtRaster;
    uint8_t bPrtBarCode;
    uint32_t  iFeedStep;
    uint32_t  iPrtStep;
    uint32_t  iCurrentPrtDot;
    enum enumCharLineStatus Status;
};
*/
struct structCharLine  PrtBuf[NumOfCharLine];

/*
struct StructBarCode{
    uint8_t cHight;
    uint8_t cWidth;
    uint8_t cFont;
    uint8_t cFontPosition;
};
*/
struct StructBarCode BarCode;

#if(GB2312 == 1)
    const uint8_t Decode_Part1[256] = 
    {
        0x8D,0x48,0x49,0x4A,0x4B,0xC7,0x67,0x73,0x74,0x64,0x60,0x61,0x83,0x77,0x00,0x01,
        0x02,0x03,0x04,0x05,0x7D,0x53,0x4C,0x4D,0xFE,0x7A,0x7B,0x7C,0x06,0x07,0x08,0x09,
        0x0A,0x0B,0x0C,0x0D,0x47,0x33,0x2A,0x2B,0x2C,0x5B,0x35,0x36,0x37,0x38,0x66,0x30,
        0x39,0x56,0x2D,0x2E,0x2F,0x3A,0x3B,0x41,0x42,0x43,0x31,0x32,0x50,0x3F,0x40,0x44,
        0x68,0x69,0x6A,0x6B,0x6C,0xFF,0x45,0x46,0x51,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,
        0x1D,0x1E,0x58,0x59,0x3C,0x3D,0x3E,0x57,0x4E,0x4F,0x1F,0x20,0x21,0x22,0x53,0x55,
        0x62,0x63,0x65,0x91,0x5C,0x5D,0x5E,0x6D,0x6E,0x6F,0x0E,0x0F,0x10,0x11,0x12,0x13,
        0x14,0x15,0x52,0x5F,0xAF,0xB0,0xB1,0x5A,0x70,0x71,0x72,0x75,0x76,0x8A,0x8B,0x23,
        0x24,0x25,0x26,0x27,0x28,0x29,0x84,0x85,0x88,0x98,0x99,0x9A,0x9B,0x9C,0x86,0x87,
        0x9D,0x89,0x8E,0x8F,0xA1,0xA2,0xA3,0x9E,0x78,0x79,0x9F,0xA0,0xBD,0xA5,0xA6,0xA7,
        0x88,0x89,0xAA,0xAB,0xAC,0xAD,0xAE,0xA4,0xCE,0x8C,0x92,0x93,0xC4,0xC5,0x82,0xB2,
        0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xCB,0x7E,0x7F,0x80,0x81,0xF6,0xC6,0x94,0x95,
        0x96,0x97,0xC2,0xC3,0xBA,0xBB,0xBC,0xC8,0xCC,0xE2,0xE3,0xE4,0xE5,0xE6,0xD0,0xD1,
        0xCD,0xBE,0xBF,0xC0,0xD6,0xC9,0xCA,0xD7,0xD8,0xD9,0xDA,0xDB,0x90,0xFB,0xFC,0xCF,
        0xDC,0xDD,0xDE,0xDF,0xE0,0xE1,0xEA,0xF7,0xF8,0xF9,0xFA,0xC1,0x34,0xEB,0xEC,0xED,
        0xEE,0xEF,0xD3,0xD4,0xFD,0xD5,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xD2,0xE7,0xE8,0xE9,
    };
    const uint8_t Decode_Part2[256] = 
    {
        0x17,0x18,0xE2,0x0F,0x1B,0xB4,0x25,0x22,0x29,0x2A,0xAB,0x48,0x49,0x4A,0x4B,0x4C,
        0x10,0x1A,0x28,0x02,0x44,0x60,0x09,0x0A,0x0B,0x0C,0x42,0x23,0x34,0x35,0x36,0x37,
        0x38,0x39,0x3D,0x03,0x04,0x05,0x06,0x07,0x21,0x12,0x13,0x14,0x45,0x46,0x47,0x1C,
        0x1D,0x1E,0x1F,0x20,0x26,0x27,0x55,0x7F,0x80,0x81,0x82,0x83,0x56,0x57,0x58,0x84,
        0x85,0x86,0x87,0x88,0x5F,0x67,0x68,0x69,0x6A,0x6B,0x7D,0x3A,0x3B,0x3C,0x43,0x3E,
        0x3F,0x40,0x41,0x4D,0x4E,0x4F,0x65,0x66,0x61,0x62,0x63,0x64,0x2F,0x30,0x31,0x32,
        0x33,0x7C,0x50,0x51,0x52,0x53,0x54,0x75,0x89,0x8A,0x8B,0xB3,0x6F,0x00,0x01,0x98,
        0x5C,0x70,0x71,0x72,0x73,0x74,0x7B,0xBE,0xBF,0xC0,0xC1,0xC2,0x7E,0x5D,0x5E,0xAA,
        0xAB,0x94,0x95,0x96,0xC9,0xB0,0x59,0x5A,0x5B,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
        0xA0,0xA1,0xB1,0xE6,0xE2,0x0D,0xFE,0x97,0xCE,0xC5,0xC6,0xC7,0xC8,0xD9,0xDA,0xDB,
        0x76,0x77,0x78,0x79,0x7A,0xF0,0x8C,0x8D,0x8E,0x8F,0x90,0x91,0x92,0x93,0xBA,0xBB,
        0xB5,0xE7,0xE8,0xDF,0xBC,0xBD,0xD7,0xD8,0x15,0x16,0xEC,0xF6,0xCA,0xCB,0xCC,0xFA,
        0xB6,0xB7,0xB8,0xB9,0x6C,0x6D,0x6E,0xEE,0xED,0xDC,0xDD,0xDE,0xF4,0xCD,0xCE,0xCF,
        0xD0,0x24,0xFF,0xF8,0xF5,0xFB,0xEB,0xAC,0xAD,0xAE,0xAF,0x0E,0xE9,0xEA,0x08,0xD1,
        0xD2,0xD3,0xD4,0xD5,0xD6,0xC3,0x2C,0x2D,0x2E,0xF9,0xE0,0xE1,0xF1,0xF2,0xF3,0xE3,
        0xE4,0xE5,0xFC,0xA2,0xA3,0xA4,0x19,0xFD,0xA5,0xA6,0xA7,0xA8,0xA9,0xEF,0xF7,0xAA,
    };
    const uint8_t Decode_Part3[256] = 
    {
        0xDC,0xFE,0x64,0x1B,0x1C,0x1D,0x1E,0x70,0x51,0xF5,0xF6,0x6A,0xD2,0xD3,0x7C,0xF3,
        0xCC,0xFF,0x20,0x21,0x22,0x23,0x5D,0x2A,0x45,0xEA,0xEB,0x1F,0x7D,0x7E,0x7F,0x80,
        0x2D,0x2B,0x2C,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x28,0x29,0x24,0x25,0x26,
        0x27,0x58,0x59,0x5E,0x5F,0x35,0x52,0x53,0x54,0x55,0x56,0x57,0x62,0x63,0x00,0x01,
        0x02,0x03,0x04,0x05,0x36,0x37,0x38,0x39,0x3A,0x3B,0x95,0x96,0x97,0x98,0x99,0x9A,
        0x81,0x8D,0x8E,0x8F,0x90,0x91,0x92,0x93,0x71,0x72,0x2E,0x2F,0x30,0x31,0x32,0x33,
        0x34,0x42,0x43,0x44,0x5A,0x5B,0x5C,0x46,0x47,0x48,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,
        0x60,0xBC,0xBD,0xBE,0xBF,0xC0,0xC0,0x61,0xC7,0xB3,0xC2,0x66,0x67,0x68,0x69,0x7B,
        0x85,0x86,0x94,0x83,0x84,0x82,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x6B,0x6C,
        0x6D,0x6E,0x9D,0x9E,0x9F,0xA0,0xA1,0x88,0x89,0x8A,0x65,0x06,0x07,0x08,0x09,0x0A,
        0x0B,0x0C,0x0D,0x0E,0x0F,0x10,0x3C,0xAC,0xAD,0xA2,0xA3,0xA4,0x9B,0x9C,0x87,0x6F,
        0xC3,0xC4,0xC5,0xC6,0xCA,0xCB,0x3D,0x3E,0x3F,0x40,0x41,0x8B,0x8C,0xCD,0xCE,0xCF,
        0xD0,0xD1,0xDD,0xA8,0xA9,0xAA,0xAB,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,
        0x1A,0xBA,0xBB,0xAE,0xAF,0xB0,0xB1,0xB2,0xDA,0xDB,0xA5,0xA6,0xA7,0xF2,0xF7,0xF8,
        0xF9,0xFA,0xFB,0xFC,0xFD,0xDE,0xDF,0xE0,0xE1,0xE2,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,
        0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xEC,0xED,0xEE,0xEF,0xF0,0xE3,0xF1,0xF4,0xC8,0xC9,
    };
    const uint8_t Decode_Part4[256] = 
    {
        0xFC,0xAD,0x6A,0x40,0x43,0x3C,0x33,0x21,0xF2,0x23,0xFB,0x1E,0x84,0x1D,0xC6,0xA9,
        0xC9,0xB0,0xD0,0x57,0xC7,0x20,0x00,0xD4,0xEA,0xD9,0xB5,0x1A,0x3E,0x3F,0x14,0xBD,
        0xFD,0x2B,0x2C,0x9E,0x22,0xB7,0xBB,0x3D,0x94,0x26,0xDC,0xC0,0x27,0x9B,0x15,0x71,
        0x2F,0x01,0x45,0x48,0x49,0x4A,0x56,0x8D,0x1F,0x9F,0x34,0x35,0x36,0x37,0x38,0x41,
        0x42,0x58,0x0F,0xE7,0x44,0x46,0x8C,0x6D,0x6C,0x16,0xCA,0x4E,0x4B,0x19,0x2A,0xC1,
        0x3A,0x76,0x04,0xB1,0x18,0x7B,0x25,0x5B,0x6F,0x03,0x59,0x53,0x2D,0x32,0x5C,0x8E,
        0x54,0xE0,0x8A,0x99,0x72,0x92,0x50,0x4D,0x7E,0x88,0x55,0x69,0x51,0x02,0x6E,0x89,
        0x5D,0x3B,0x7D,0x87,0xC3,0x66,0x0E,0x80,0x77,0x81,0x28,0x85,0x70,0x83,0xC2,0x95,
        0xFF,0x8B,0x67,0x17,0xAA,0x5E,0x93,0x9C,0x91,0x90,0x29,0xB9,0xB4,0xB8,0xA3,0x7F,
        0x5F,0xA7,0x30,0x31,0xA0,0xA1,0xE3,0xE4,0x05,0x06,0x07,0x08,0x09,0xD3,0xAC,0x9A,
        0x82,0x74,0xFE,0x47,0x1B,0x1C,0x8F,0xF1,0x6B,0xA2,0x5A,0x10,0xD1,0xCB,0xA6,0xCF,
        0x0A,0x61,0x62,0x63,0x64,0x65,0xBC,0x78,0x79,0xC5,0x11,0xD5,0xE1,0xE5,0x0B,0xDE,
        0xCC,0xB3,0xEE,0xA8,0xED,0xB6,0xC4,0x96,0xD2,0x7C,0xDA,0xD7,0xB2,0x86,0xFA,0xD8,
        0xCD,0xDB,0xF6,0x97,0xEB,0x0D,0xF9,0x7A,0xF5,0xAF,0xDF,0xF3,0x12,0x98,0x2E,0xE8,
        0xE9,0xAE,0xEC,0x39,0x52,0x4C,0xF7,0xF8,0x9D,0xE2,0x60,0xDD,0xF4,0xA4,0xA5,0xBE,
        0xBF,0xE6,0xBA,0xD6,0xF0,0xEF,0x0C,0x24,0xCE,0x13,0x68,0x4F,0xC8,0x73,0x75,0xAB,
    };
#endif
const uint8_t  InterCharSearchTab[]={
    0xff,   0xff,   0xff,   0,      1,      0xff,   0xff,   0xff,
  //0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,   0x27
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x28,   0x29,   0x2a,   0x2b,   0x2c,   0x2d,   0x2e,   0x2f
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x38,   0x39,   0x3a,   0x3b,   0x3c,   0x3d,   0x3e,   0x3f
    2,      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x48,   0x49,   0x4a,   0x4b,   0x4c,   0x4d,   0x4e,   0x4f
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57
    0xff,   0xff,   0xff,   3,      4,      5,      6,      0xff,
  //0x58,   0x59,   0x5a,   0x5b,   0x5c,   0x5d,   0x5e,   0x5f
    7,      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x68,   0x69,   0x6a,   0x6b,   0x6c,   0x6d,   0x6e,   0x6f
    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  //0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77
    0xff,   0xff,   0xff,   8,      9,      10,     11,     0xff,
  //0x78,   0x79,   0x7a,   0x7b,   0x7c,   0x7d,   0x7e,   0x7f
};
//在代码页2中找点阵 (page 0)0->0X9E (Pt)
const uint8_t  InterCharExchangeTab[14][12]={
    {0x23,0x24,0x40,0x5B,0x5C,0x5D,0x5E,0x60,0x7B,0x7C,0x7D,0x7E},  // 0 U.S.A.
    {0x23,0x24,0x85,0xF8,0x87,0xF5,0x5E,0x60,0x82,0x97,0x8A,0xF9},  // 1 France
    {0x23,0x24,0xF5,0x8E,0x99,0x9A,0x5E,0x60,0x84,0x94,0x81,0xE1},  // 2 Germany
    {0x9C,0x24,0x40,0x5B,0x5C,0x5D,0x5E,0x60,0x7B,0x7C,0x7D,0x7E},  // 3 U.K.
    {0x23,0x24,0x40,0x93,0x9C,0x8F,0x5E,0x60,0x91,0x9B,0x86,0x7E},  // 4 Denmark I
    {0x23,0xCF,0x90,0x8E,0x99,0x8F,0x9A,0x82,0x84,0x94,0x86,0x81},  // 5 Sweden
    {0x23,0x24,0x40,0xF8,0x5C,0x82,0x5E,0x97,0x85,0x95,0x8A,0x8D},  // 6 Italy
    {0x00,0x24,0x40,0xAD,0xA5,0xA8,0x5E,0x60,0xF9,0xA4,0x7D,0x7E},  // 7 Spain  I
    {0x23,0x24,0x40,0x5B,0xBE,0x5D,0x5E,0x60,0x7B,0x7C,0x7D,0x7E},  // 8 Janan
    {0x23,0xCF,0x90,0x93,0x9C,0x8F,0x9A,0x82,0x91,0x9B,0x86,0x81},  // 9 Norway
    {0x23,0x24,0x90,0x93,0x9C,0x8F,0x9A,0x82,0x91,0x9B,0x86,0x81},  // A Denmark II
    {0x23,0x24,0x96,0xAD,0xA5,0xA8,0x82,0x60,0xA1,0xA4,0xA2,0xA3},  // B Spain  II
    {0x23,0x24,0x96,0xAD,0xA5,0xA8,0x82,0x81,0xA1,0xA4,0xA2,0xA3},  // C Latin America
    {0x23,0x24,0x40,0x5B,0x01,0x5D,0x5E,0x60,0x7B,0x7C,0x7D,0x7E},  // D Korea
};

/******************************************************************************************************/

/******************************************************************************************************/
uint8_t JudgeExceedByteLine(uint32_t iDotWillAdd);
void StartupPrint(uint8_t cNeedFeedLineSpace);
void InitCharLine(uint8_t Line);
void ClrCharPrtBuf(uint8_t Line);
void BarCodeInit(void);
void SelfTestPrint(void);
void HexPrint(void);
void AsciiHightMultiple(uint8_t *pAsciiPattern, uint8_t *pAsciiHightiPattern, uint8_t AsciiWidth);

void ChineseHightMultiple(uint8_t *pChinesePattern, uint8_t *pChineseHightiPattern, uint8_t ChineseWidth);
void CharPrtMiddle(uint8_t Line,uint8_t cHight, uint32_t iRightPos);
void CharPrtRight(uint8_t Line,uint8_t cHight, uint32_t iRightPos);
void AddUnderLine(uint8_t Line,uint32_t width, uint8_t underline);
void AddBlod(uint8_t Line,uint32_t width,uint8_t hight);
void ChineseCharacterRotate(uint8_t *pAsciiPattern, uint8_t ChineseWidth);
uint8_t AsciiCharacterRotate(uint8_t *pAsciiPattern, uint8_t AsciiWidth);
void PrtInvertOneLine(uint8_t Line);
void PrtBufferVToH(uint8_t Line);
void SendStr(uint8_t *pStr);



//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［PrtBuf.c］
//=========================================================================================================
//* Function name   :      CalculateChineseAddr
//* Descriptions    :      获取指定汉字地址
//* input parameters:      cByte1  first byte  cByte2 second byte
//* Returned value  :      返回指定地址
//=========================================================================================================
uint32_t CalculateChineseAddr(uint8_t cByte1, uint8_t cByte2, uint8_t cByte3, uint8_t cByte4)//yxm add
{
    uint32_t Address = 0;
    if((cByte1 == 0xfe) && (cByte2 >= 0xa1) && (cByte2 <= 0xfe))//user defined char 
    {
        if(SPI_Read_Byte(UserCharAddr_24x24 | ((cByte2 - 0xa1) << 12)))
        {
            Address = UserCharAddr_24x24 | ((cByte2 - 0xa1) << 12) | 1;
        }
    }
    else if(cByte1 >= 0xA1 && cByte1 <= 0xA9)
    {
        bPart1 = 1;
        Address = ((cByte1 - 0xA1) * 94 + (cByte2 - 0xA1)) * 72 + BaseAddr1_24x24;
    }
    else// 汉字 B0~F7区
    {
        bPart3 = 1;
        Address = ((cByte1 - 0xB0) * 94 + (cByte2 - 0xA1)) * 72 + BaseAddr2_24x24;
    }
    return Address;
}


//=========================================================================================================
//* Function name   :     CalculateAsciiAddr    
//* Descriptions    :     获取指定字符地址
//* input parameters:     cByte  Ascii Code
//* Returned value  :     返回指定地址   
//=========================================================================================================
uint32_t CalculateAsciiAddr(uint8_t cByte) //yxm add
{
    uint32_t Address;
    uint8_t cTemp;
    if(cByte > 0x7F)//高128位Ascii码 需要判断代码页
    {
        if(bFont12x24)//12X24代码页
        {
            if((cCodePage < 33) || (cCodePage == 255))
            {
                switch(cCodePage)
                {
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                        bPart4 = 1;
                        Address = (cByte-0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr1_12x24 + cCodePage * (unsigned long)ZKBlockSize_12x24;
                        break;
                    case 16:
                    case 17:
                    case 18:
                    case 19:
                    case 20:
                    case 21:
                    case 22:
                    case 23:
                    case 24:
                    case 25:
                    case 26:
                    case 27:
                    case 28:
                    case 29:
                    case 30:
                    case 31:
                    case 32:
                        bPart4 = 1;
                        Address = (cByte - 0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr1_12x24 + (cCodePage - 5) * (unsigned long)ZKBlockSize_12x24;
                        break;
                    case 255:
                    {
                        uint8_t temp_codepage;
                        bPart4 = 1;
                        temp_codepage = 33;
                        Address = (cByte - 0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr1_12x24 + (temp_codepage - 5) * (unsigned long)ZKBlockSize_12x24;
                        break;
                    }
                    default:
                        bPart4 = 1;
                        Address = (cByte - 0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr1_12x24;
                        break;
                }
            }
            else if((cCodePage) > 49 && (cCodePage < 100))
            {
                bPart3 = 1;
                Address = (cByte - 0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr2_12x24 + (cCodePage - 50) * (unsigned long)ZKBlockSize_12x24;
            }
            else
            {
                bPart4 = 1;
                Address = (cByte-0x80) * (ASCII_WIDTH*3) + ExtendedBaseAddr1_12x24;
            }
        }
        else//9X24代码页
        {
            if((cCodePage < 20) || (cCodePage == 255))
            {
                switch(cCodePage)
                {
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                        bPart2 = 1;
                        Address = (cByte - 0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24 + cCodePage * (unsigned long)ZKBlockSize_9x24;
                        break;
                    case 16:
                        bPart2 = 1;
                        Address = (cByte - 0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24 + (cCodePage - 9) * (unsigned long)ZKBlockSize_9x24;
                        break;
                    case 17:
                        bPart2 = 1;
                        Address = (cByte  -0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24 + (cCodePage - 11) * (unsigned long)ZKBlockSize_9x24;
                        break;
                    case 18:
                    case 19:
                        bPart2 = 1;
                        Address = (cByte - 0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24 + (cCodePage - 10) * (unsigned long)ZKBlockSize_9x24;
                        break;
                    case 255:
                    {
                        uint8_t temp_codepage;
                        bPart2 = 1;
                        temp_codepage = 20;
                        Address = (cByte - 0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24 + (temp_codepage - 10) * (unsigned long)ZKBlockSize_9x24;
                        break;
                    }
                    default:
                        bPart2 = 1;
                        Address = (cByte - 0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24;
                        break;
                }
            }
            else
            {
                bPart2 = 1;
                Address = (cByte - 0x80) * (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24;
            }
        }
    }
    else//低128位ascii码
    {
        cTemp = InterCharSearchTab[cByte - 0x20];
        if(cTemp != 0xff)
        {
            cByte = InterCharExchangeTab[cInternationalCharSet][cTemp];
            if(cByte == 0)
            {
                if(bFont12x24)
                {
                    bPart4 = 1;
                    Address = (0X9E - 0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr1_12x24;
                }
                else
                {
                    bPart2 = 1;
                    Address = (0X9E - 0x80)* (SFONT_WIDTH * 3) + ExtendedBaseAddr_9x24;
                }
            }
            //else if(cByte == 1)
            //{
                //没找到韩国的一个字符类似W的一个字符
            //}
            else if(cByte > 0x7F)
            {
                if(bFont12x24)
                {
                    bPart4 = 1;
                    Address = (cByte - 0x80) * (ASCII_WIDTH * 3) + ExtendedBaseAddr1_12x24 + 2 * (unsigned long)ZKBlockSize_12x24;
                }
                else
                {
                    bPart2 = 1;
                    Address = (cByte - 0x80) * (SFONT_WIDTH*3) + ExtendedBaseAddr_9x24 + 2 * (unsigned long)ZKBlockSize_9x24;
                }
            }
            else
            {
                if(bFont12x24)
                {
                    bPart2 = 1;
                    Address = (cByte - 0x20) * (ASCII_WIDTH * 3) + BaseAddr_12x24;
                }
                else
                {
                    bPart2 = 1;
                    Address = (cByte - 0x20) * (SFONT_WIDTH * 3) + BaseAddr_9x24;
                }
            }
        }
        else
        {
            if(bFont12x24)
            {
                bPart2 = 1;
                Address = (cByte - 0x20) * (ASCII_WIDTH * 3) + BaseAddr_12x24;
            }
            else
            {
                bPart2 = 1;
                Address = (cByte - 0x20) * (SFONT_WIDTH * 3) + BaseAddr_9x24;
            }
        }
    }
    return Address;
}

//=========================================================================================================
//* Function name   :       CalculateAsciiAddr
//* input parameters:       Chinese Addr
//* Descriptions    :       获取指定汉字字模
//=========================================================================================================
void GetChineseZimo(uint32_t Addr)
{
    uint8_t i;
    uint8_t cTempBuf[HZ_WIDTH * 3];
    SPI_FastRead_nBytes(Addr, cTempBuf, HZ_WIDTH*3);
    if(bPart1 == 1) //A0~A9
    {
        bPart1 = 0;
        for(i = 0; i < HZ_WIDTH * 3; i++)
        {
            Zimotemp[i] = Decode_Part1[cTempBuf[i]];
        }
    }
    else if(bPart3 == 1)//B0~B7
    {
        bPart3 = 0;
        for(i = 0; i < HZ_WIDTH * 3; i++)
        {
            Zimotemp[i] = Decode_Part3[cTempBuf[i]];
        }
    }
    else//User defiened   char
    {
        for(i = 0;i < HZ_WIDTH * 3; i ++)
        {
            Zimotemp[i] = cTempBuf[i];
        }
    }
}

//=========================================================================================================
//* Function name   :      GetAsciiZimo
//* input parameters:      ASCII Addr
//* Descriptions    :      获取指定字符字模
//=========================================================================================================
void GetAsciiZimo(uint32_t Addr)
{
    uint8_t i;
    uint8_t cTempBuf[ASCII_WIDTH*3];
    
    if(bUserChar)
    {
        /*if(bFont12x24)
        {
            //(Addr-AsciiBaseAddr) / (ASCII_WIDTH * 3) 字符首地址
            if(UserDefinedBuf[(Addr - BaseAddr_12x24) / (ASCII_WIDTH*3) * (ASCII_WIDTH * 3 + 1)] == 0x01)//还原地址看是否被定义
            {
                for(i = 0; i < (ASCII_WIDTH*3); i++)// 读出(ASCII_WIDTH * 3)个字节
                {
                    Zimotemp[i] = UserDefinedBuf[(Addr - BaseAddr_12x24) / (ASCII_WIDTH * 3) * (ASCII_WIDTH * 3 + 1) + 1 + i];
                }
                return;
            }
        }
        else
        {
            if(UserDefinedBuf[(Addr - BaseAddr_12x24) / (SFONT_WIDTH * 3) * (SFONT_WIDTH * 3 + 1) + MaxDotPos * ASCII_WIDTH] == 0x01)
            {
                for(i = 0; i < SFONT_WIDTH * 3; i++)
                {
                    Zimotemp[i] = UserDefinedBuf[(Addr - BaseAddr_12x24) / (SFONT_WIDTH * 3) * (SFONT_WIDTH * 3 + 1) + MaxDotPos * ASCII_WIDTH + 1 + i];
                }
                return;
            }
        }*/
    }

    if(bFont12x24)
    {
        //ErrLED_on();
        SPI_FastRead_nBytes(Addr, cTempBuf, (ASCII_WIDTH * 3));
        //ErrLED_off();
        if(bPart2 == 1)//ASCII 0x20~0x7F  12X24
        {
            bPart2 = 0;
            for(i = 0; i < ASCII_WIDTH * 3; i++)
            {
                Zimotemp[i] = Decode_Part2[cTempBuf[i]];
            }
        }
        else if(bPart3 == 1)// code page 50~code page 96 12x24
        {
            bPart3 = 0;
            for(i = 0; i < ASCII_WIDTH * 3; i++)
            {
                Zimotemp[i] = Decode_Part3[cTempBuf[i]];
            }
        }
        else if(bPart4 == 1)//code page 0~code page 32, page 255   12x24
        {
            bPart4 = 0;
            for(i = 0; i < ASCII_WIDTH * 3; i++)
            {
                Zimotemp[i] = Decode_Part4[cTempBuf[i]];
            }
        }
        else//others
        {
            for(i = 0; i < ASCII_WIDTH * 3; i++)
            {
                Zimotemp[i] = cTempBuf[i];
            }
        }
    }
    else
    {
        SPI_FastRead_nBytes(Addr, cTempBuf, (SFONT_WIDTH * 3));
        if(bPart2 == 1)//FontB 9x24
        {
            bPart2 = 0;
            for(i = 0; i < SFONT_WIDTH * 3; i++)
            {
                Zimotemp[i] = Decode_Part2[cTempBuf[i]];
            }
        }
        else//other
        {
            for(i = 0; i < SFONT_WIDTH * 3; i++)
            {
                Zimotemp[i] = cTempBuf[i];
            }
        }
    }
}

//=========================================================================================================
//* Function name:     FillPrtBufChinese
//* Descriptions :     填充汉字字模
//=========================================================================================================
void FillPrtBufChinese(void)
{
    uint32_t iTemp;
    uint8_t cSpaceTemp;
    uint8_t cLoop;
    uint8_t cLoop1;
    uint8_t cCount;
    uint8_t cWidth;
    uint8_t *pChinesePattern;
    uint8_t *pChineseHightPattern;
    uint8_t ChineseZimotempHight[HZ_WIDTH * 3 * 4];
    
    bUnderLineEffect = 1;
    cWidth = HZ_WIDTH;
    iTemp = cWidth * cChineseWidthMultiple;//chinese width
    cChineseLeftSpace = cChineseLeftSpace << (cChineseWidthMultiple - 1);//Left spase
    cChineseRightSpace = cChineseRightSpace << (cChineseWidthMultiple - 1);//righ tspase
    iTemp += (cChineseLeftSpace + cChineseRightSpace);//chinese width ++leftspase+rightspace

    if(iTemp > (iPrtRightMargin - iPrtLeftMargin))//打印区域 默认是MaxDotPos - 0
    {
        iTemp = (iPrtRightMargin - iPrtLeftMargin);
    }
    JudgeExceedByteLine(iTemp);
    
    if(bPrtAdverse)//反白打印处理
    {
        for(cLoop = 0; cLoop < HZ_WIDTH * 3; cLoop++)//按位取反
        {
            Zimotemp[cLoop] = ~Zimotemp[cLoop];
        }
        cSpaceTemp = 0xff;//边距填充值
        bUnderLineEffect = 0;//下划线失效
    }
    else
    {
        cSpaceTemp = 0;//边距填充值
    }
    pChinesePattern = &Zimotemp[0];

    if(bHaveFilledChinese)
    {
        ;//do nothing
    }
    else
    {
        bHaveFilledChinese = 1;
    }

    if(cChineseHightMultiple > 1)//有倍高
    {
        uint8_t *p;
        uint32_t Temp1;
        uint32_t Temp2;
        memset(&ChineseZimotempHight, 0, sizeof(ChineseZimotempHight)); 
        ChineseHightMultiple(pChinesePattern,ChineseZimotempHight,cWidth);//倍高处理
        pChineseHightPattern = &ChineseZimotempHight[0];
        p = &PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn]; 
        for(cCount = 0;cCount<cChineseLeftSpace;cCount++)//左边距
        {
    
            for(cLoop1 = 0; cLoop1 < cChineseHightMultiple; cLoop1++)//每次循环填充3个字节行
            {
                Temp1 = 3*(cChineseHightMultiple - cLoop1 - 1)*MaxDotPos;
                *(p + 2 * MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[2+3*(cChineseHightMultiple-cLoop1-1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
                *(p + MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[1+3*(cChineseHightMultiple-cLoop1-1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
                *(p + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[0+3*(cChineseHightMultiple-cLoop1-1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
            }
            p++;
            iCurrentFillColumn ++;
        }

        for(cCount = 0;cCount<cWidth;cCount++)
        {
    
            for(cLoop = 0; cLoop < cChineseWidthMultiple; cLoop++)//填充字模
            {
                for(cLoop1 = 0; cLoop1 < cChineseHightMultiple; cLoop1++)//每次循环填充3个字节行
                {
                    Temp1 = 3 * (cChineseHightMultiple - cLoop1 - 1) * MaxDotPos;
                    Temp2 = cLoop1 * 3 * cWidth;
                    *(p + 2 * MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[2 + 3 * (cChineseHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn]
                        = *(pChineseHightPattern + Temp2);
                    *(p+MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[1 + 3 * (cChineseHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                        = *(pChineseHightPattern + Temp2 + cWidth);
                    *(p + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[0 + 3 * (cChineseHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                        = *(pChineseHightPattern + Temp2 + 2 * cWidth);
                }
                p++;
                iCurrentFillColumn++;
            }
            pChineseHightPattern++;
        }

        for(cCount = 0; cCount < cChineseRightSpace; cCount++)//右边距
        {
    
            for(cLoop1 = 0; cLoop1 < cChineseHightMultiple; cLoop1++)//每次循环填充3个字节行
            {
                Temp1 = 3 * (cChineseHightMultiple - cLoop1 - 1) * MaxDotPos;
                Temp2 = (int)pChineseHightPattern + cLoop1 * 3 * cWidth;
                *(p + 2 * MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[2 + 3 * (cChineseHightMultiple-cLoop1 - 1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
                *(p + MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[1 + 3 * (cChineseHightMultiple-cLoop1 - 1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
                *(p + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[0 + 3 * (cChineseHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
            }
            p++;
            iCurrentFillColumn++;
        }
    }
    else
    {
        uint8_t *p1;
        uint8_t *p2;
        uint8_t *p3;
        p1 = &PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn];
        p2 = &PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn];
        p3 = &PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn];
        for(cCount = 0; cCount < cChineseLeftSpace; cCount++)//左边距
        {
            //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn] 
            *p3++ = cSpaceTemp;
            //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn] 
            *p2++ = cSpaceTemp;
            //PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn] 
            *p1++ = cSpaceTemp;
            //p ++;
            iCurrentFillColumn++;
        }
        
        for(cCount = 0; cCount < cWidth; cCount++)
        {
            //SerialSendByte(0X11);//TEST
            for(cLoop = 0; cLoop < cChineseWidthMultiple; cLoop++)//填充字模
            {
                //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn] 
                *p3++ = *(pChinesePattern);
                //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn] 
                *p2++ = *(pChinesePattern + cWidth);
                //PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn] 
                *p1++ = *(pChinesePattern + 2 * cWidth);
                iCurrentFillColumn++;
            }
            pChinesePattern++;
            //SerialSendByte(0X13);//TEST
        }

        for(cCount = 0; cCount < cChineseRightSpace; cCount++)//右边距
        {
            //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn]
            *p3++ = cSpaceTemp;
            //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn]
            *p2++ = cSpaceTemp;
            ///PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn]
            *p1++ = cSpaceTemp;
            iCurrentFillColumn++;
        }
    }
    AddBlod(cCurrentFillRow, iTemp, cChineseHightMultiple);//粗体打印
    AddUnderLine(cCurrentFillRow, iTemp, bChineseUnderLine);//下划线打印设置
}

//=========================================================================================================
//* Function name:     ChineseHightMultiple
//* Descriptions :     汉字多倍高处理最多4倍
//=========================================================================================================
void ChineseHightMultiple(uint8_t *pChinesePattern, uint8_t *pChineseHightPattern, uint8_t ChineseWidth)
{
    uint32_t iTemp[HZ_WIDTH];
    uint8_t cLoop;
    uint8_t cLoop1;
    uint8_t cLoop2;
    uint8_t cLoop3;
    uint8_t cTemp[PRTLINEHIGHT * 4];

    for(cLoop = 0; cLoop < ChineseWidth; cLoop++)//合并成24个int型数组
    {
        iTemp[cLoop] = (uint32_t)(*pChinesePattern << 16) | (uint32_t)( *(pChinesePattern + ChineseWidth) << 8) | (uint32_t) * (pChinesePattern + 2 * ChineseWidth);
        pChinesePattern ++;
    }

    for(cLoop = 0; cLoop < ChineseWidth; cLoop++)//处理宽度个int数组
    {
        cLoop3 = 0;
        for(cLoop2 = 0; cLoop2 < PRTLINEHIGHT; cLoop2++)//取出24*cChineseHightMultiple个cTemp的数组
        {
            for(cLoop1 = 0; cLoop1 < cChineseHightMultiple; cLoop1++)//相同的cChineseHightMultiple 个
            {
                cTemp[cLoop3++] = (iTemp[cLoop] >> (23 - cLoop2))&0x01;
            }
        }
        cLoop3 = 0;
        for(cLoop2 = 0; cLoop2 < cChineseHightMultiple * 3; cLoop2++)//重新组成cChineseHightMultiple*3个字节
        {
            for(cLoop1 = 0; cLoop1 < 8; cLoop1++)//8个cTemp组成一个字节
            {
                *(pChineseHightPattern + cLoop + cLoop2 * ChineseWidth) |= (cTemp[cLoop3++] << (7 - cLoop1));
            }
        }
    }
}


//=========================================================================================================
//* Function name:     FillPrtBufAscii
//* Descriptions :     填充字符字模
//=========================================================================================================
void FillPrtBufAscii(void)
{
    uint32_t  iTemp;//ascii width +rightspace
    uint8_t cSpaceTemp;
    uint8_t cLoop;
    uint8_t cLoop1;
    uint8_t cCount;
    uint8_t cWidth;//字符宽度
    uint8_t *pAsciiPattern;
    uint8_t *pAsciiHightPattern;
    uint8_t AsciiZimotempHight[ASCII_WIDTH * 3 * 4];
    bUnderLineEffect = 1;
    
    if(bFont12x24)
    {
        cWidth = ASCII_WIDTH;
        iTemp = cWidth * cAsciiWidthMultiple;//ascii width
    }
    else
    {
        cWidth = SFONT_WIDTH;
        //添加小字体顺时针旋转90度处理函数
        iTemp = cWidth * cAsciiWidthMultiple;//ascii width
    }
    cAsciiRightSpace = cAsciiRightSpace << (cAsciiWidthMultiple - 1);//rightspace
    iTemp += cAsciiRightSpace ;//ascii width +rightspace

    if(iTemp > (iPrtRightMargin - iPrtLeftMargin))//打印区域 默认是MaxDotPos - 0
    {
        iTemp = (iPrtRightMargin - iPrtLeftMargin);
    }
    
    JudgeExceedByteLine(iTemp);
    
    if(bPrtAdverse)//反白打印处理
    {
        for(cLoop = 0; cLoop < cWidth * 3; cLoop ++)//按位取反
        {
            Zimotemp[cLoop] = ~Zimotemp[cLoop];
        }
        cSpaceTemp = 0xff;
        bUnderLineEffect = 0;//UnderLine not Effect
        //RightSpace 处理
    }
    else
    {
    
        cSpaceTemp = 0;
    }
    pAsciiPattern = &Zimotemp[0];

    if(bHaveFilledAscii)
    {
        ;//do nothing
    }
    else
    {
        bHaveFilledAscii = 1;
    }

    if(cAsciiHightMultiple > 1)//有倍高
    {
        uint8_t *p;
        uint32_t Temp1;
        uint32_t Temp2;
        memset(&AsciiZimotempHight, 0, sizeof(AsciiZimotempHight)); 
        AsciiHightMultiple(pAsciiPattern, AsciiZimotempHight, cWidth);//倍高处理，保存到AsciiZimotempHight里面
        pAsciiHightPattern = &AsciiZimotempHight[0];
        p = &PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn];
        for(cCount = 0;cCount < cWidth; cCount++)
        {
            for(cLoop = 0; cLoop < cAsciiWidthMultiple; cLoop ++)//填充字模
            {
                for(cLoop1 = 0; cLoop1 < cAsciiHightMultiple; cLoop1++)//每次循环填充3个字节行
                {
                    Temp1 = 3*(cAsciiHightMultiple - cLoop1 - 1) * MaxDotPos;
                    Temp2 = cLoop1 * 3 * cWidth;
                    *(p + 2 * MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[2 + 3 * (cAsciiHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                        = *(pAsciiHightPattern + Temp2);
                    *(p+MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[1 + 3 * (cAsciiHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                        = *(pAsciiHightPattern + Temp2 + cWidth);
                    *(p+Temp1)//PrtBuf[cCurrentFillRow].ByteLine[0 + 3 * (cAsciiHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                        = *(pAsciiHightPattern + Temp2 + 2 * cWidth);
                }
                p++;
                iCurrentFillColumn++;
            }
            pAsciiHightPattern++;
    
        }
        for(cCount = 0; cCount < cAsciiRightSpace; cCount++)//右边距
        {
            for(cLoop1 = 0; cLoop1 < cAsciiHightMultiple; cLoop1++)//每次循环填充3个字节行
            {
                Temp1 = 3 * (cAsciiHightMultiple - cLoop1 - 1) * MaxDotPos;
                *(p + 2 * MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[2 + 3 * (cAsciiHightMultiple-cLoop1 - 1)].BasePrtLine[iCurrentFillColumn]
                    = cSpaceTemp;
                *(p + MaxDotPos + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[1 + 3 * (cAsciiHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                    = cSpaceTemp;
                *(p + Temp1)//PrtBuf[cCurrentFillRow].ByteLine[0 + 3 * (cAsciiHightMultiple - cLoop1 - 1)].BasePrtLine[iCurrentFillColumn] 
                    = cSpaceTemp;
            }
            p++;
            iCurrentFillColumn ++;
        }
    }
    else
    {
        uint8_t *p1;
        uint8_t *p2;
        uint8_t *p3;
        p1 = &PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn];
        p2 = &PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn];
        p3 = &PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn];
        for(cCount = 0; cCount < cWidth; cCount++)//填充字模
        {
            for(cLoop = 0; cLoop < cAsciiWidthMultiple; cLoop ++)
            {
                //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn] 
                *p3++ = *(pAsciiPattern);
                //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn] 
                *p2++ = *(pAsciiPattern + cWidth);
                //PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn] 
                *p1++ = *(pAsciiPattern + 2 * cWidth);
                
                iCurrentFillColumn ++;
            }
            pAsciiPattern++;
        }
        for(cCount = 0; cCount < cAsciiRightSpace; cCount++)//右边距
        {
            //PrtBuf[cCurrentFillRow].ByteLine[2].BasePrtLine[iCurrentFillColumn]
            *p3++ = cSpaceTemp;
            //PrtBuf[cCurrentFillRow].ByteLine[1].BasePrtLine[iCurrentFillColumn]
            *p2++ = cSpaceTemp;
            //PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn]
            *p1++ = cSpaceTemp;
            
            iCurrentFillColumn ++;
        }
    }
    AddBlod(cCurrentFillRow, iTemp, cAsciiHightMultiple);//粗体打印设置
    AddUnderLine(cCurrentFillRow, iTemp, bAsciiUnderLine);//下划线打印设置
}

//=========================================================================================================
//* Function name:    AsciiHightMultiple
//* Descriptions :    字符多倍高处理    最多4倍
//=========================================================================================================
void AsciiHightMultiple(uint8_t *pAsciiPattern, uint8_t *pAsciiHightPattern, uint8_t AsciiWidth)
{
    uint8_t cLoop;
    uint8_t cLoop1;
    uint8_t cLoop2;
    uint8_t cLoop3;
    uint32_t  iTemp[ASCII_WIDTH];
    uint8_t cTemp[PRTLINEHIGHT*4];

    for(cLoop = 0; cLoop < AsciiWidth; cLoop++)//合并成AsciiWidth 个int型数组
    {
        iTemp[cLoop] = (uint32_t)(*pAsciiPattern << 16) | (uint32_t)(*(pAsciiPattern + AsciiWidth) << 8) | (uint32_t) * (pAsciiPattern + 2 * AsciiWidth);
        pAsciiPattern ++;
    }

    for(cLoop = 0; cLoop < AsciiWidth; cLoop++)//处理宽度个int数组
    {
        cLoop3 = 0;
        for(cLoop2 = 0; cLoop2 < PRTLINEHIGHT; cLoop2++)//取出24*cAsciiHightMultiple个cTemp的数组
        {
            for(cLoop1 = 0; cLoop1 < cAsciiHightMultiple; cLoop1++)//相同的cAsciiHightMultiple 个
            {
                cTemp[cLoop3++] = (iTemp[cLoop] >> (23-cLoop2))&0x01;
            }
        }
        cLoop3 = 0;
        for(cLoop2 = 0;cLoop2 < cAsciiHightMultiple * 3; cLoop2++)//重新组成cAsciiHightMultiple*3个字节
        {
            for(cLoop1 = 0; cLoop1 < 8; cLoop1++)//8个cTemp组成一个字节
            {
                *(pAsciiHightPattern + cLoop + cLoop2 * AsciiWidth) |= (cTemp[cLoop3++] << (7 - cLoop1));
            }
        }
    }
}

//=========================================================================================================
//* Function name:     JudgeExceedByteLine
//* Descriptions :     Judg  打印buffer是否填满
//=========================================================================================================
uint8_t JudgeExceedByteLine(uint32_t iDotWillAdd)
{
    if(iDotWillAdd <= (iPrtRightMargin - iCurrentFillColumn))
    {
        // the byte line is not full
        return 0;
    }
    else
    {
        // the line is full
        StartupPrint(1);
        return 1;
    }
}

//=========================================================================================================
//* Function name:     StartupPrint
//* Descriptions :     准备打印函数
//=========================================================================================================
void StartupPrint(uint8_t cNeedFeedLineSpace)
{
    uint8_t cNextLine;
    uint8_t cTempStatus;
    uint8_t cTempStep;
    uint8_t bNeedFeedLineSpace;
    uint32_t  iStepNum;

    //scan err and test
    TestHeadTemperature(); //測試溫度有無過熱;AMO;2018.05.25
    //TestBatteryQuantity();
    DisplayStatus();       //目前的狀態查詢;AMO;2018.05.25
    //SerialSendByte(0x11);

    if(cNeedFeedLineSpace)//是否需要走行间距
    {
        bNeedFeedLineSpace = 1;
    }
    else
    {
        bNeedFeedLineSpace = 0;
    }
    
    if(iCurrentFillColumn == iPrtLeftMargin)/*||((iCurrentFillColumn == iLeftMargin)&&(!iLeftMargin)))*///have nothing prt data  //iPrtLeftMargin==左边距设置;AMO;2018.05.25
    {
        if(bNeedFeedLineSpace)
        {
            cTempStatus = PrtBuf[cCurrentPrtCharLine].Status;//打印buffer状态
            switch(cTempStatus)
            {
                case Empty:
                case Filling:
                //case Printing:
                    WaitMotorStop();
                    iStepNum = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM;
                    //bTimer2Prt = 0;
                    //bTimer2FeedLine = 1;
                    FeedPaper(iStepNum);//走一字符行
                    break;
                case Printing://有问题 待解决
                    while(PrtBuf[cCurrentPrtCharLine].Status != FeedLine);
                    //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
                    CloseAllInt();                              // Recover 2022/08/23 PoJen
                    cTempStatus = PrtBuf[cCurrentPrtCharLine].Status;
                    if(cTempStatus == FeedLine)
                    {
                        // state have not changed
                        if(iLFStepNum < LashStop_Nums + 1)//(const hlod stop)
                        {
                            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                            OpenAllInt();                               // Recover 2022/08/23 PoJen
                            WaitMotorStop();
                            iStepNum = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM;
                            FeedPaper(iStepNum);
                        }
                        else
                        {
                            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                            OpenAllInt();                               // Recover 2022/08/23 PoJen
                            // in the period of acceleration of constant speed
                            CountinueLineFeed((iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM);
                        }
                    }
                    else
                    {
                        // state have changed
                        //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                        OpenAllInt();                               // Recover 2022/08/23 PoJen
                        WaitMotorStop();
                        iStepNum = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM;
                        FeedPaper(iStepNum);
                    }
                    break;
                case FeedLine:
                    //SYS_ITEA_Cmd(DISABLE);                            // Delete 2022/08/23 PoJen
                    CloseAllInt();                                      // Recover 2022/08/23 PoJen
                    cTempStatus = PrtBuf[cCurrentPrtCharLine].Status;
                    if(cTempStatus == FeedLine)
                    {
                        // state have not changed
                        if(iLFStepNum < LashStop_Nums + 1)//(const hlod stop)
                        {
                            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                            OpenAllInt();                               // Recover 2022/08/23 PoJen
                            WaitMotorStop();
                            iStepNum = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM;
                            FeedPaper(iStepNum);
                        }
                        else
                        {
                            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                            OpenAllInt();                               // Recover 2022/08/23 PoJen
                            // in the period of acceleration of constant speed
                            CountinueLineFeed((iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM);
                        }
                    }
                    else
                    {
                        // state have changed
                        //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                        OpenAllInt();                               // Recover 2022/08/23 PoJen
                        WaitMotorStop();
                        iStepNum = (iLineSpaceNumber + PRTLINEHIGHT) * ONEDOTSTEPNUM;
                        FeedPaper(iStepNum);
                    }
                    break;
                case WaitForPrint:
                    break;
                default:
                    break;
            }
        }
        else
        {
            //do nothing
        }
    }
    else
    {
        // have print data
        cNextLine = cCurrentFillRow + 1;
        if(cNextLine == NumOfCharLine)
        {
            cNextLine = 0;
        }
        else
        {
            ;
        }
        
        // fill the line attribute
        PrtBuf[cCurrentFillRow].cNextCharLine = cNextLine;
        if(bNeedFeedLineSpace)
        {
            PrtBuf[cCurrentFillRow].iFeedStep = iLineSpaceNumber * ONEDOTSTEPNUM;//feed line
        }
        else
        {
            PrtBuf[cCurrentFillRow].iFeedStep = 0;  //feed line = 0
        }
        
        if((cAsciiHightMultiple >= cChineseHightMultiple) && bHaveFilledAscii)//计算打印走纸步数Prtfeed
        {
        // PrtBuf[cCurrentFillRow].iPrtStep = cAsciiHightMultiple * PRTLINEHIGHT * ONEDOTSTEPNUM;
        
        PrtBuf[cCurrentFillRow].iPrtStep = cAsciiHightMultiple_Prt * PRTLINEHIGHT * ONEDOTSTEPNUM;

        PrtBuf[cCurrentFillRow].iCurrentPrtDot = cAsciiHightMultiple_Prt * PRTLINEHIGHT;

        // PrtBuf[cCurrentFillRow].iCurrentPrtDot = cAsciiHightMultiple * PRTLINEHIGHT;
        }
        else if((cChineseHightMultiple >= cAsciiHightMultiple) && bHaveFilledChinese)
        {
            PrtBuf[cCurrentFillRow].iPrtStep = cChineseHightMultiple_Prt * PRTLINEHIGHT * ONEDOTSTEPNUM;//修改 ;AMO;2018.05.25
            PrtBuf[cCurrentFillRow].iCurrentPrtDot = cChineseHightMultiple_Prt * PRTLINEHIGHT;
        }
        else if(bHaveFilledImageDot)//打印图形 NV  GS *图
        {
            PrtBuf[cCurrentFillRow].iPrtStep = iImageDotHight * ONEDOTSTEPNUM;
            PrtBuf[cCurrentFillRow].iCurrentPrtDot = iImageDotHight;
            // PrtBuf[cCurrentFillRow].iCurrentPrtDot = 0x60;
            Test_motor_step = 0;
        }
        else if(bHaveFilledRasterDot) // 打印光栅图
        {
            PrtBuf[cCurrentFillRow].iPrtStep = iRasterDotHight * ONEDOTSTEPNUM;
            PrtBuf[cCurrentFillRow].iCurrentPrtDot = iRasterDotHight;
            PrtBuf[cCurrentFillRow].bPrtRaster = 1;//中断中取数据不同寻常
        }
        else if(bHaveFilledBarCode)//打印条码
        {
            PrtBuf[cCurrentFillRow].iPrtStep = BarCode.cHight * ONEDOTSTEPNUM;
            PrtBuf[cCurrentFillRow].iCurrentPrtDot = BarCode.cHight;
            PrtBuf[cCurrentFillRow].bPrtBarCode = 1;//中断中取数据不同寻常
        }
        else//打印ESC *  图
        {
            PrtBuf[cCurrentFillRow].iPrtStep = PRTLINEHIGHT * ONEDOTSTEPNUM;
            PrtBuf[cCurrentFillRow].iCurrentPrtDot = PRTLINEHIGHT;
        }
        switch(bAlign)//对齐方式
        {
            case Align_Left:
                break;
            case Align_Middle:
                CharPrtMiddle(cCurrentFillRow,PrtBuf[cCurrentFillRow].iCurrentPrtDot,iCurrentFillColumn);
                break;
            case Align_Right:
                CharPrtRight(cCurrentFillRow,PrtBuf[cCurrentFillRow].iCurrentPrtDot,iCurrentFillColumn);
                break;
            default:
                break;
        }
        PrtBufferVToH(cCurrentFillRow);//打印缓冲字模由纵向变成横向
        // start up print
        //SYS_ITEA_Cmd(DISABLE);                        // Delete 2022/08/23 PoJen
        CloseAllInt();                                  // Recover 2022/08/23 PoJen
        if(PrtBuf[cCurrentPrtCharLine].Status == Empty)
        {
            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
            OpenAllInt();                               // Recover 2022/08/23 PoJen
            WaitMotorStop();
            cCurrentPrtCharLine = cCurrentFillRow;
            iLFStepNum = PrtBuf[cCurrentPrtCharLine].iPrtStep + PrtBuf[cCurrentPrtCharLine].iFeedStep + LashStop_Nums;
            bTimer2Prt = 1;
            StartLFMotor();
        }
        else
        {
            // printing is continued don't need restart
            PrtBuf[cCurrentFillRow].Status = WaitForPrint;
            cTempStep = cCurrentPrtCharLine;
            //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
            OpenAllInt();                               // Recover 2022/08/23 PoJen
            do
            {
                //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
                CloseAllInt();                              // Recover 2022/08/23 PoJen
                cTempStatus = PrtBuf[cTempStep].Status;
                //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
                OpenAllInt();                               // Recover 2022/08/23 PoJen
            }while(cTempStatus != Empty);
        }
        cCurrentFillRow = cNextLine;
        bHaveFilledAscii = 0;
        bHaveFilledChinese = 0;
        bHaveFilledRasterDot = 0;
        bHaveFilledImageDot = 0;
        InitCharLine(cCurrentFillRow);//准备重新填充字模
        if(bHaveFilledBarCode)
        {
            //BarCodeInit(); //AMO註解，因為使用了就不能紀錄設定值；已在void PrinterInit(void)內使用BarCodeInit(),來一開機初始化裝置;AMO;2018.05.25
            bClearBarCode = 1;//下次清打印条码的buf
            bHaveFilledBarCode = 0;
        }
        else
        {
            ;
        }
    }

    cAsciiHightMultiple_Prt = cAsciiHightMultiple;
    cChineseHightMultiple_Prt = cChineseHightMultiple;//新增 ;AMO;2018.05.25
}

//=========================================================================================================
//* Function name:     InitCharLine    
//* Descriptions :     清空打印BUFFER状态，准备重新填充字模
//=========================================================================================================
void InitCharLine(uint8_t Line)
{
    uint32_t  iLoop;
    uint8_t *p;
    uint8_t cLoopByteLine;
    uint8_t cPrtByteLine;

    if(bClearBarCode)//清空打印条码的buf
    {
        PrtBuf[Line].iPrtStep = (PRTLINEHIGHT * ONEDOTSTEPNUM);
        bClearBarCode = 0;
    }
    if(PrtBuf[Line].iPrtStep % (8 * ONEDOTSTEPNUM))
    {
        cPrtByteLine = PrtBuf[Line].iPrtStep / (8 * ONEDOTSTEPNUM) + 1;//用到的字节行
    }
    else
    {
        cPrtByteLine = PrtBuf[Line].iPrtStep / ( 8 * ONEDOTSTEPNUM);//用到的字节行
    }
    for(cLoopByteLine = 0; cLoopByteLine < cPrtByteLine; cLoopByteLine++)//用到的字节行数据都清零
    {
        p = &PrtBuf[Line].ByteLine[cLoopByteLine].BasePrtLine[0];
        for(iLoop = 0; iLoop < MaxDotPos; iLoop++)
        {
            *p++ = 0;
        }
    }
    PrtBuf[Line].Status = Empty;
    PrtBuf[Line].iFeedStep = 0;
    PrtBuf[Line].iPrtStep = 0;
    PrtBuf[Line].iCurrentPrtDot = 0;
    PrtBuf[Line].bPrtRaster = 0;
    PrtBuf[Line].bPrtBarCode = 0;
    iCurrentFillColumn = iPrtLeftMargin;
}

//=========================================================================================================
//* Function name:     ClrCharPrtBuf    
//* Descriptions :     开机初始化BUFFER状态
//=========================================================================================================
void ClrCharPrtBuf(uint8_t Line)//Check-Ok;AMO;2018.05.25
{
    uint32_t iLoop;
    uint8_t *p;
    uint8_t cLoopByteLine;
    
    for(cLoopByteLine = 0; cLoopByteLine < PRTBUFHIGHT; cLoopByteLine++)//所有字节行全部清零;PRTBUFHIGHT=12;;AMO;2018.05.25
    {
        p = &PrtBuf[Line].ByteLine[cLoopByteLine].BasePrtLine[0];   //表示取得一排高度為12的字的每一橫排的第一(0)個pixel點數的值的位址;AMO;2018.05.25
        for(iLoop = 0; iLoop < MaxDotPos; iLoop++)  //每個pixel點數的值，用1個byte來表示，一排最大點數MaxDotPos = 384; AMO;2018.05.25
        {
            *p++ = 0;
        }
    }
    PrtBuf[Line].bPrtRaster = 0;
    PrtBuf[Line].bPrtBarCode = 0;
    PrtBuf[Line].iFeedStep = 0;
    PrtBuf[Line].iPrtStep  = 0;        //★這個原本是PrtBuf[Line].iFeedStep = 0;，但改成PrtBuf[Line].iPrtStep = 0;才對;AMO;2018.05.25
    PrtBuf[Line].iCurrentPrtDot = 0;
    PrtBuf[Line].Status = Empty;
    iCurrentFillColumn = 0;
}

//=========================================================================================================
//* Function name:     BarCodeInit   
//* Descriptions :     条码设置初始化
//=========================================================================================================
void BarCodeInit(void)//Check-Ok;AMO;2018.05.25
{
    BarCode.cFont = 0;
    BarCode.cFontPosition = 0;
    BarCode.cHight = 162;
    BarCode.cWidth = 3;
}

//=========================================================================================================
//* Function name:     PrintStr    
//* Descriptions :     打印ASCii字符串
//=========================================================================================================
void PrintStr(uint8_t *pPrintData, uint8_t fPrint)
{
    uint32_t iAddrtemp;

    while(*pPrintData != 0x00)
    {
        if(*pPrintData > 0x80)
        {
            // cData>0x80
            uint8_t cByteN1, cByteN2;
            cByteN1 = *pPrintData++;
            if(bChinese)
            {
                // chinese
                cByteN2 = *pPrintData++;;
                // cByteN2> = 0x40 two bytes chinese
                iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
                GetChineseZimo(iAddrtemp);
                FillPrtBufChinese();
            }
            else
            {
                // not chinese --- Ascii character
                iAddrtemp = CalculateAsciiAddr(*pPrintData++);
                GetAsciiZimo(iAddrtemp);
                FillPrtBufAscii();
            }
        }
        else
        {
            // 0x20 <= cData <= 0x80
            iAddrtemp = CalculateAsciiAddr(*pPrintData++);
            GetAsciiZimo(iAddrtemp);
            FillPrtBufAscii();
        }
    }

    if(fPrint)
    {
        StartupPrint(1);//打印
    }
    else
    {
        ;
    }
}

//=========================================================================================================
//* Function name:     SelfTestPrint    
//* Descriptions :     自检页打印数据
//=========================================================================================================
void SelfTestPrint(void)//;AMO;2019.04.15
{
    uint8_t cByteN1,cByteN2;
    uint8_t cLoop;
    uint8_t tt;
    uint32_t iAddrtemp;

    static const char strSelModel[] = {"***Self-Test***"};
    static const char strModel58[] = {"POS-58 Thermal Printer"};
    static const char strVersion[] = {"Version :        "};//s:Interface  t:Test
    static const char strData[] = {"Revised date:    25-Apr-2019 "};
    static const char strCommand[] = {"Command standard:EPSON(ESC/POS)"};
    static const char strPrtMethod[] = {"Print method:    Line Thermal"};
    static const char strPrtWidth[] = {"Print width:     "};
    static const char strPrtSpeed[] = {"Print speed:     90mm/s"};
    static const char strPrtChi[] = {"Chinese  mode:   "};
    static const char strPrtdensity[] ={"Print density:   "};
    static const char strInterface[] = {"InterfaceType:   UART"};
    static const char strCodeBar[] = {"CODE BAR:"};
    static const char strCodeBarPrt[] ={"012345678901"};

    static const  char strSelftestOK[] = {"***Completed***"};
    static const char BARCODE[3][32] = {
                                        "  1.UPC-A          2.UPC-E     ",
                                        "  3.CODE39         4.ITF       ",
                                        "  5.CODE93         6.CODE128",
                                       };
    /**************************************************************/
    //["***Self-Test***"]
    bAlign = Align_Middle;   //居中
    cAsciiHightMultiple = 1; //
    cAsciiWidthMultiple = 2; //两倍宽
    PrintStr((uint8_t*)strSelModel, 1);

    //[列印二行空白頁]
    cAsciiHightMultiple = 1;
    cAsciiWidthMultiple = 1;
    StartupPrint(1);

    //["POS-58 Thermal Printer"]
    bAlign = Align_Middle;//居中
    cAsciiHightMultiple = 2;//两倍高
    cAsciiHightMultiple_Prt = 2;//两倍高;AMO;2019.04.15
    cAsciiWidthMultiple = 1;
    PrintStr((uint8_t*)strModel58, 1);
    
    //["Version :    MG32F02A-V.01"]
    bAlign = Align_Left;//居左 正常模式
    cAsciiHightMultiple = 1;
    cAsciiWidthMultiple = 1;
    PrintStr((uint8_t*)strVersion, 0);

    if(bChinese)
    {
        PrintStr((uint8_t*)"MG32F02A-V.01", 1); //中文模式;AMO;2019.04.15
    }
    else
    {
        PrintStr((uint8_t*)"MG32F02A-V.01", 1); //英文模式;AMO;2019.04.15
    }
    
    //["Revised date:    25-Apr-2019 "]
    PrintStr((uint8_t*)strData, 1);
    //["Command standard:EPSON(ESC/POS)"]
    PrintStr((uint8_t*)strCommand, 1);
    //["Print method:    Line Thermal"]
    PrintStr((uint8_t*)strPrtMethod, 1);
    //["Print width:     384dots/line"]
    PrintStr((uint8_t*)strPrtWidth, 0);
    PrintStr((uint8_t*)"384dots/line", 1);
    //["Print speed:     90mm/s"]
    PrintStr((uint8_t*)strPrtSpeed, 1);
    //["Chinese  mode:   YES"]
    PrintStr((uint8_t*) strPrtChi, 0);

    if(bChinese)
    {
        PrintStr((uint8_t*)"YES", 1);
    }
    else
    {
        PrintStr((uint8_t*)"NO", 1);
    }
    /**************************************************************/
    //["Print density:   Level4"]
    PrintStr((uint8_t*)strPrtdensity,0);//打印当前浓度级别

    switch(iDensitySetTime)
    {
        case DensitySetTimeLevel1:
            PrintStr((uint8_t*)"Level1", 1);
            break;
        case DensitySetTimeLevel2:
            PrintStr((uint8_t*)"Level2", 1);
            break;
        case DensitySetTimeLevel3:
            PrintStr((uint8_t*)"Level3", 1);
            break;
        case DensitySetTimeLevel4:
            PrintStr((uint8_t*)"Level4", 1);
            break;
        case DensitySetTimeLevel5:
            PrintStr((uint8_t*)"Level5", 1);
            break;
        default:
            break;
    }
    /**************************************************************/
    //["InterfaceType:   UART"]
    PrintStr((uint8_t*)strInterface, 1);//打印接口类型
    //["&Serial 115200, None, 8, 1""]

    switch(iBaudRate)
    {
        case BAUDRATE9600:
            PrintStr((uint8_t*)"      &Serial  9600,None,8,1", 1);
            break;
        case BAUDRATE19200:
            PrintStr((uint8_t*)"      &Serial 19200,None,8,1", 1);
            break;
        case BAUDRATE38400:
            PrintStr((uint8_t*)"      &Serial 38400,None,8,1", 1);
            break;
        case BAUDRATE57600:
            PrintStr((uint8_t*)"      &Serial 57600,None,8,1", 1);
            break;
        case BAUDRATE115200:
            PrintStr((uint8_t*)"      &Serial 115200,None,8,1", 1);
            break;
        case 4800:
            PrintStr((uint8_t*)"      &Serial 4800,None,8,1", 1);
            break;
        case 2400:
            PrintStr((uint8_t*)"      &Serial 2400,None,8,1", 1);
            break;
        case 1200:
            PrintStr((uint8_t*)"      &Serial 1200,None,8,1", 1);
            break;
        default:
            break;
    }
  //["CODE BAR:"]
    PrintStr((uint8_t*)strCodeBar, 1);//打印条码类别

    for(cLoop = 0; cLoop < 3; cLoop++)//打印DIP功能
    {
        PrintStr((uint8_t*)BARCODE[cLoop], 1);
    }

    /**************************************************************/
    bFont12x24 = 1;
    for(cLoop = 0x30; cLoop <= 0x39; cLoop++)//打印打字体ASCII码
    {
        iAddrtemp = CalculateAsciiAddr(cLoop);//yxm add
        GetAsciiZimo(iAddrtemp);
        FillPrtBufAscii();
    }
    StartupPrint(1);

    for(cLoop = 0x61; cLoop <= 0x7A; cLoop++)//打印打字体ASCII码
    {
        iAddrtemp = CalculateAsciiAddr(cLoop);//yxm add
        GetAsciiZimo(iAddrtemp);
        FillPrtBufAscii();
    }
    StartupPrint(1);

    for(cLoop = 0x41; cLoop <= 0x5A; cLoop ++)//打印打字体ASCII码
    {
        iAddrtemp = CalculateAsciiAddr(cLoop);//yxm add
        GetAsciiZimo(iAddrtemp);
        FillPrtBufAscii();
    }
    StartupPrint(1);

    /**************************************************************/
    bAlign = Align_Left;//居左 正常模式	
    cAsciiHightMultiple = 2;//两倍高
    cAsciiHightMultiple_Prt = 2;//两倍高;AMO;2019.04.15
    cAsciiWidthMultiple = 2;//两倍宽
    bFont12x24 = 1;
    
    for(cLoop = 0x30; cLoop <= 0x39; cLoop ++)//打印打字体ASCII码
    {
        iAddrtemp = CalculateAsciiAddr(cLoop);//yxm add
        GetAsciiZimo(iAddrtemp);
        FillPrtBufAscii();
    }
    StartupPrint(1);

    for(cLoop = 0x61; cLoop <= 0x7A; cLoop ++)//打印打字体ASCII码
    {
        iAddrtemp = CalculateAsciiAddr(cLoop);//yxm add
        GetAsciiZimo(iAddrtemp);
        FillPrtBufAscii();
    }
    StartupPrint(1);

    for(cLoop = 0x41; cLoop <= 0x5A; cLoop ++)//打印打字体ASCII码
    {
        iAddrtemp = CalculateAsciiAddr(cLoop);//yxm add
        GetAsciiZimo(iAddrtemp);
        FillPrtBufAscii();
    }
    StartupPrint(1);
    
    /**************************************************************/
    bAlign = Align_Middle;//居中
    cChineseHightMultiple = 1; //;AMO;2018.05.25
    cChineseHightMultiple_Prt = 1; //;AMO;2018.05.25
    cChineseWidthMultiple = 1;//两倍宽

    if(bChinese)
    {
        //笙:GB2312编码：F3CF
        cByteN1 = 0xF3;
        cByteN2 = 0xCF;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //泉:GB2312编码：C8AA
        cByteN1 = 0xC8;
        cByteN2 = 0xAA;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //科:GB2312编码：BFC6
        cByteN1 = 0xBF;
        cByteN2 = 0xC6;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //技:GB2312编码：BCBC
        cByteN1 = 0xBC;
        cByteN2 = 0xBC;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //股:GB2312编码：B9C9
        cByteN1 = 0xB9;
        cByteN2 = 0xC9;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //份:GB2312编码：B7DD
        cByteN1 = 0xB7;
        cByteN2 = 0xDD;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //有:GB2312编码：D3D0
        cByteN1 = 0xD3;
        cByteN2 = 0xD0;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //限:GB2312编码：CFDE
        cByteN1 = 0xCF;
        cByteN2 = 0xDE;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //公:GB2312编码：B9AB
        cByteN1 = 0xB9;
        cByteN2 = 0xAB;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //司:GB2312编码：CBBE
        cByteN1 = 0xCB;
        cByteN2 = 0xBE;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        StartupPrint(1);
    }

    bAlign = Align_Middle;//居中
    cChineseHightMultiple = 2; //;AMO;2018.05.25
    cChineseHightMultiple_Prt = 2; //;AMO;2018.05.25
    cChineseWidthMultiple = 2;//两倍宽

    if(bChinese)
    {
        //笙:GB2312编码：F3CF
        cByteN1 = 0xF3;
        cByteN2 = 0xCF;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //泉:GB2312编码：C8AA
        cByteN1 = 0xC8;
        cByteN2 = 0xAA;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //科:GB2312编码：BFC6
        cByteN1 = 0xBF;
        cByteN2 = 0xC6;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //技:GB2312编码：BCBC
        cByteN1 = 0xBC;
        cByteN2 = 0xBC;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //股:GB2312编码：B9C9
        cByteN1 = 0xB9;
        cByteN2 = 0xC9;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //份:GB2312编码：B7DD
        cByteN1 = 0xB7;
        cByteN2 = 0xDD;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //有:GB2312编码：D3D0
        cByteN1 = 0xD3;
        cByteN2 = 0xD0;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();
        
        //限:GB2312编码：CFDE
        cByteN1 = 0xCF;
        cByteN2 = 0xDE;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //公:GB2312编码：B9AB
        cByteN1 = 0xB9;
        cByteN2 = 0xAB;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        //司:GB2312编码：CBBE
        cByteN1 = 0xCB;
        cByteN2 = 0xBE;
        iAddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
        GetChineseZimo(iAddrtemp);
        FillPrtBufChinese();

        StartupPrint(1);
    }
    //[重置設定]
    bAlign = Align_Left;//居左 正常模式	
    cAsciiHightMultiple = 1;//两倍高
    cAsciiHightMultiple_Prt = 1;//两倍高;AMO;2019.04.15
    cAsciiWidthMultiple = 1;
    bFont12x24 = 1;
    
    bAlign = Align_Left;//居左 正常模式	
    cChineseHightMultiple = 1; //;AMO;2018.05.25
    cChineseHightMultiple_Prt = 1; //;AMO;2018.05.25
    cChineseWidthMultiple = 1;
    
    /**************************************************************/
    //[打印一维码]
    //SYS_ITEA_Cmd(DISABLE);                    // Delete 2022/08/23 PoJen
    CloseAllInt();                              // Recover 2022/08/23 PoJen
    InitRcvBuf();
    FillRcvBuf(0x41);//參數m0x41=code UPC-A
    
    FillRcvBuf(0x0B);//參數n;0x0B=11個
    cLoop = 11;
    for(tt = 0; tt < cLoop; tt++)//參數d1~d11
    {
        FillRcvBuf(strCodeBarPrt[tt]);
    }
    //FillRcvBuf(0x00);//end 
    BarCode.cFontPosition = 2;
    //SYS_ITEA_Cmd(ENABLE);                     // Delete 2022/08/23 PoJen
    OpenAllInt();                               // Recover 2022/08/23 PoJen
    bAlign = Align_Middle;//居中模式
    GS_k();
    BarCode.cFontPosition = 0;
    bAlign = Align_Left;//居左 正常模式

    /**************************************************************/
    StartupPrint(1);
    StartupPrint(1);
    bAlign = Align_Middle;//居中
    cAsciiHightMultiple = 1;
    cAsciiWidthMultiple = 2;//倍宽
    PrintStr((uint8_t*)strSelftestOK, 1);
    cAsciiHightMultiple = 1;
    cAsciiWidthMultiple = 1;
    bAlign = Align_Left;
    /**************************************************************/

    StartupPrint(1);
    StartupPrint(1);

    bSelfTest = 0;     //进入自检打印模式，不判斷按鍵，不接收資料，直到自檢模式結束  //;AMO;2019.04.15
    bPauseKeyState = 1;  //进入自检打印模式，不判斷按鍵，不接收資料，直到自檢模式結束    //;AMO;2019.04.15
}

//=========================================================================================================
//* Function name:     HexPrint    
//* Descriptions :     进入16进制模式打印
//=========================================================================================================
uint8_t HalfHex2Ascii(uint8_t cHalfHex)
{
    if(cHalfHex < 10)
    {
        cHalfHex += 0x30;
    }
    else
    {
        cHalfHex = cHalfHex - 10 + 'A';
    }
    return cHalfHex;
}

uint8_t Hex2Ascii(uint8_t *pHex)
{
    uint8_t cResult;
    cResult = HalfHex2Ascii((*pHex & 0xf0) >> 4);
    *pHex = HalfHex2Ascii(*pHex & 0x0f);
    return cResult;
}

void HexPrint(void)
{
    uint8_t cByte;
    uint8_t cLoop;
    uint8_t cBufTemp[4] = {0x20, 0x20, 0x20, 0x20};
    uint32_t  iZimoAddr;
    uint8_t cHexDumpCounter = 0;
    const uint8_t  strFirstLine[] = {"The Printer is  under hex  mode now..."};
    const uint8_t  strEndLine[] = {"        ***completed***"};
    WaitMotorStop();
    InitRcvBuf();
    ESC_ATInit();
    StartupPrint(1);
    PrintStr((uint8_t *)strFirstLine, 1);
    StartupPrint(1);

    while(cHexDumpCounter < 2)
    {
        //IWDG_Reload;  //沒使用，註解;AMO;2018.06.20
        if(cHexDumpCounter > 2)
        {
            break;
        }
        else
        {
            ;
        }

        if(bitRcvBufHaveData)//接收BUFFER 有数据
        {
            // have data
            cByte = GetDataFromRcvBuf();
            cBufTemp[1] = Hex2Ascii(&cByte); //高低4位都得到对应的ASCII码字符
            cBufTemp[2] = cByte;
            for(cLoop = 0; cLoop < 4; cLoop++)//每个数据转换成4个字节 两个是空格
            {
                iZimoAddr = CalculateAsciiAddr(cBufTemp[cLoop]);
                GetAsciiZimo(iZimoAddr);
                FillPrtBufAscii();
            }
        }
        else
        {
            // no data scan key
            
            if(LFKeyDown())//连续按键跳出HEX模式
            {
                // Delay(200);//ms// Delete 2022/08/22 PoJen
                DelayMs(200);//按键去抖 // Recover 2022/08/23 PoJen
                while(LFKeyDown());
                cHexDumpCounter++;
                WaitMotorStop();
                //ScanLFKey();
            }
            else
            {
                ;
            }
        }
    }

    StartupPrint(1);
    PrintStr((uint8_t *)strEndLine, 1);
    StartupPrint(1);
    ESC_ATInit();
}

//=========================================================================================================
//* Function name:     CharPrtMiddle    
//* Descriptions :     居中打印处理函数
//=========================================================================================================
void CharPrtMiddle(uint8_t Line, uint8_t cHight, uint32_t iRightPos)
{
    uint32_t iLoop;
    uint8_t *p;
    uint8_t cLoopByteLine;
    uint8_t TempBuf[MaxDotPos];

    if(bHaveFilledRasterDot)//||bHaveFilledImageDot)//光栅和位图暂时不做居中处理
    {
        return;
    }

    if(bHaveFilledBarCode)//解决条码居中变化计算超出buf
    {
        cHight = PRTLINEHIGHT;
    }

    for(cLoopByteLine = 0; cLoopByteLine < ((cHight - 1) / 8 + 1); cLoopByteLine++)//所有字节行
    {
        p = &PrtBuf[Line].ByteLine[cLoopByteLine].BasePrtLine[iPrtLeftMargin];
        for(iLoop = iPrtLeftMargin; iLoop < iPrtRightMargin; iLoop++)
        {
            TempBuf[iLoop] = *p;
        
            *p++ = 0;//字节行清零
            
        }
        p = &PrtBuf[Line].ByteLine[cLoopByteLine].BasePrtLine[(iPrtRightMargin-iRightPos) / 2 + iPrtLeftMargin];
        for(iLoop = iPrtLeftMargin; iLoop < iRightPos; iLoop++)//重新排列成新的字节行居中
        {
            *p++ = TempBuf[iLoop];
        }
    }
}

//=========================================================================================================
//* Function name:     CharPrtRight    
//* Descriptions :     居右打印处理函数
//=========================================================================================================
void CharPrtRight(uint8_t Line, uint8_t cHight, uint32_t iRightPos)
{
    uint32_t iLoop;
    uint8_t *p;
    uint8_t cLoopByteLine;
    uint8_t TempBuf[MaxDotPos];

    if(bHaveFilledRasterDot)
    {
        return;
    }

    if(bHaveFilledBarCode)//解决条码居中变化计算超出buf
    {
        cHight = PRTLINEHIGHT;
    }

    for(cLoopByteLine = 0; cLoopByteLine < ((cHight - 1) / 8 + 1); cLoopByteLine++)//所有字节行
    {
        p = &PrtBuf[Line].ByteLine[cLoopByteLine].BasePrtLine[iPrtLeftMargin];
        for(iLoop = iPrtLeftMargin; iLoop < iPrtRightMargin; iLoop++)
        {
            TempBuf[iLoop] = *p;
            *p++ = 0;
        }
        p = &PrtBuf[Line].ByteLine[cLoopByteLine].BasePrtLine[(iPrtRightMargin - iRightPos)];
        for(iLoop = iPrtLeftMargin; iLoop < iRightPos; iLoop++)//重新排列成新的字节行居右
        {
            *p++ = TempBuf[iLoop];
        }
    }
}

//=========================================================================================================
//* Function name:     AddUnderLine    
//* Descriptions :     下划线处理
//=========================================================================================================
void AddUnderLine(uint8_t Line, uint32_t width, uint8_t underline)
{
    uint32_t iLoop;
    uint8_t *p;

    if(bUnderLineEffect)//下划线有效
    {
        p = &PrtBuf[Line].ByteLine[0].BasePrtLine[iCurrentFillColumn];
        if(underline == 1)//下划线一点行
        {
            for(iLoop = width; iLoop > 0; iLoop--)
            {
                *(p - iLoop) |= 0x01;
            }
        }
        else if(underline == 2)//下划线两点行
        {
            for(iLoop = width; iLoop > 0; iLoop--)
            {
                *(p-iLoop) |= 0x03;
            }
        }
        else
        {
            ;
        }
    }
}

//=========================================================================================================
//* Function name:     AddBlod
//* Descriptions :     粗体模式处理
//=========================================================================================================
void AddBlod(uint8_t Line, uint32_t width, uint8_t hight)
{
    uint32_t iLoop;
    uint8_t cLoop;
    uint8_t cTemp;
    uint8_t *p;

    if(bBold)//粗体模式
    {
        for(cLoop = 0;cLoop < hight*3; cLoop ++)//hight*3个字节行
        {
            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[iCurrentFillColumn - width];
            for(iLoop = 0; iLoop < width; iLoop++)//纵向粗体设置
            {
                //cTemp = (PrtBuf[Line].ByteLine[cLoop].BasePrtLine[iCurrentFillColumn - width + iLoop] >> 1);
                //PrtBuf[Line].ByteLine[cLoop].BasePrtLine[iCurrentFillColumn - width + iLoop] |= cTemp;
                cTemp = *(p + iLoop) >> 1;
                *(p + iLoop) |= cTemp;
            }
            for(iLoop = 1; iLoop < width; iLoop = iLoop + 2)//横向粗体设置 处理width - 1个字节
            {
                //cTemp = PrtBuf[Line].ByteLine[cLoop].BasePrtLine[iCurrentFillColumn - width + iLoop - 1];//前一个字节
                //PrtBuf[Line].ByteLine[cLoop].BasePrtLine[iCurrentFillColumn - width + iLoop] |= cTemp;//后一个字节与前一个字节或
                cTemp = *(p + iLoop - 1);
                *(p+iLoop) |= cTemp;
            }
        }
    }
    else
    {
        ;
    }
}

//=========================================================================================================
//* Function name:     PrtBufferVToH
//* Descriptions :     打印缓冲区字模排放方式变换由纵向变成横向排列
//=========================================================================================================
void PrtBufferVToH(uint8_t Line)
{
    uint8_t TempBuf[MaxDotPos];
    uint8_t cPrtByteLine;
    uint8_t cLoop;
    uint8_t *p;
    uint32_t  iLoop;
    
    if(!bHaveFilledRasterDot)//光栅图形不用变换
    {
        cPrtByteLine = PrtBuf[Line].iPrtStep / (8 * ONEDOTSTEPNUM);//用到的字节
        if(bHaveFilledBarCode)
        {
            cPrtByteLine = 1;
        }
        //bERLED_ON;
        for(cLoop = 0; cLoop < cPrtByteLine; cLoop++)
        {
            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for(iLoop = 0; iLoop < MaxDotPos / 8; iLoop++)//生成第1一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x80) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 1; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 2; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 3; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 4; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 5; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 6; p++;
                TempBuf[iLoop] |= (*p & 0x80) >> 7; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos / 4; iLoop++)//生成第2一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x40) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 1; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 2; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 3; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 4; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 5; p++;
                TempBuf[iLoop] |= (*p & 0x40) >> 6; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos * 3 / 8; iLoop++)//生成第3一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x20) << 2; p++;
                TempBuf[iLoop] |= (*p & 0x20) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x20) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x20) >> 1; p++;
                TempBuf[iLoop] |= (*p & 0x20) >> 2; p++;
                TempBuf[iLoop] |= (*p & 0x20) >> 3; p++;
                TempBuf[iLoop] |= (*p & 0x20) >> 4; p++;
                TempBuf[iLoop] |= (*p & 0x20) >> 5; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos / 2; iLoop++)//生成第4一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x10) << 3; p++;
                TempBuf[iLoop] |= (*p & 0x10) << 2; p++;
                TempBuf[iLoop] |= (*p & 0x10) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x10) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x10) >> 1; p++;
                TempBuf[iLoop] |= (*p & 0x10) >> 2; p++;
                TempBuf[iLoop] |= (*p & 0x10) >> 3; p++;
                TempBuf[iLoop] |= (*p & 0x10) >> 4; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos * 5 / 8; iLoop++)//生成第5一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x08) << 4; p++;
                TempBuf[iLoop] |= (*p & 0x08) << 3; p++;
                TempBuf[iLoop] |= (*p & 0x08) << 2; p++;
                TempBuf[iLoop] |= (*p & 0x08) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x08) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x08) >> 1; p++;
                TempBuf[iLoop] |= (*p & 0x08) >> 2; p++;
                TempBuf[iLoop] |= (*p & 0x08) >> 3; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos * 3 / 4; iLoop++)//生成第6一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x04) << 5; p++;
                TempBuf[iLoop] |= (*p & 0x04) << 4; p++;
                TempBuf[iLoop] |= (*p & 0x04) << 3; p++;
                TempBuf[iLoop] |= (*p & 0x04) << 2; p++;
                TempBuf[iLoop] |= (*p & 0x04) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x04) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x04) >> 1; p++;
                TempBuf[iLoop] |= (*p & 0x04) >> 2; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos * 7 / 8; iLoop++)//生成第7一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x02) << 6; p++;
                TempBuf[iLoop] |= (*p & 0x02) << 5; p++;
                TempBuf[iLoop] |= (*p & 0x02) << 4; p++;
                TempBuf[iLoop] |= (*p & 0x02) << 3; p++;
                TempBuf[iLoop] |= (*p & 0x02) << 2; p++;
                TempBuf[iLoop] |= (*p & 0x02) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x02) >> 0; p++;
                TempBuf[iLoop] |= (*p & 0x02) >> 1; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for( ; iLoop < MaxDotPos; iLoop++)//生成第8一点行的字节
            {
                TempBuf[iLoop]  = (*p & 0x01) << 7; p++;
                TempBuf[iLoop] |= (*p & 0x01) << 6; p++;
                TempBuf[iLoop] |= (*p & 0x01) << 5; p++;
                TempBuf[iLoop] |= (*p & 0x01) << 4; p++;
                TempBuf[iLoop] |= (*p & 0x01) << 3; p++;
                TempBuf[iLoop] |= (*p & 0x01) << 2; p++;
                TempBuf[iLoop] |= (*p & 0x01) << 1; p++;
                TempBuf[iLoop] |= (*p & 0x01) >> 0; p++;
            }

            p = &PrtBuf[Line].ByteLine[cLoop].BasePrtLine[0];
            for(iLoop = 0; iLoop < MaxDotPos; iLoop++)//生成的数据重新放大打印BUFFER中
            {
                *p = TempBuf[iLoop];
                p++;
            }
        }
        //ErrLED_off();
    }
}

//=========================================================================================================
//* Function name:     SendStr    
//* Descriptions :     蓝牙串口发送字符串
//=========================================================================================================
void SendStr(uint8_t *pStr)
{
    while(*pStr != 0x00)
    {
        SerialSendByte(*pStr++);
    }
}

//=========================================================================================================
//* Function name:     CharacterModeSelect    
//* Descriptions :     开机汉字模式和字符模式切换
//=========================================================================================================
void CharacterModeSelect(void)
{
    uint8_t cTemp;
    unsigned iLoop;

    for(iLoop = 0; iLoop < 32; iLoop++)//读256个字节用户参数到缓冲中
    {
        PrtConfigBuf[iLoop] = SPI_Read_Byte(UserParameterBaseAddr + iLoop);
    }
    cTemp = SPI_Read_Byte(UserParameterBaseAddr + CharacterModeAddr);

    if(cTemp&0x01)
    {
        cTemp = 0x00;
        bChinese = 0;
        PrintStr("you select ASCII Mode", 1);
    }
    else
    {
        cTemp = 0x01;
        bChinese = 1;
        PrintStr("you select Chinese Mode", 1);
    }

    PrtConfigBuf[CharacterModeAddr] = cTemp;//更改用户设置参数
    SPI_Erase_Sector(UserParameterBaseAddr);//擦除扇区

    for(iLoop = 0; iLoop < 32; iLoop++)//重新写入
    {
        SPI_Write_Byte(UserParameterBaseAddr + iLoop, PrtConfigBuf[iLoop]);
    }
}


//=========================================================================================================
//* Function name:     ExecuteData    
//* Descriptions :     打印数据处理函数
//=========================================================================================================
void ExecuteData(uint8_t data)
{
    uint32_t Laddrtemp;

    if(data > 0x80)
    {
        // cData>0x80
        uint8_t cByteN1, cByteN2;
        cByteN1 = data;
        if(bChinese)
        {
            // chinese
            cByteN2 = GetDataFromRcvBuf();
            Laddrtemp = CalculateChineseAddr(cByteN1, cByteN2, 0, 0); //yxm add
            GetChineseZimo(Laddrtemp);
            FillPrtBufChinese();
        }
        else
        {
            // not chinese  --- Ascii character
            //高128位ascii
            Laddrtemp = CalculateAsciiAddr(data);
            GetAsciiZimo(Laddrtemp);
            FillPrtBufAscii();
        }
    }
    else
    {
        // 0x20<=cData<=0x80 //0x20~0x80:ASCII CODE
        Laddrtemp = CalculateAsciiAddr(data);
        GetAsciiZimo(Laddrtemp);
        FillPrtBufAscii();
    }
}

