/**
 * @file    PrtBuf.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the PrtBuf firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PRTBUF_H
#define __PRTBUF_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"
#include "Interface.h"
#include "RcvBuf.h"
#include "PrtHead.h"
#include "CmdSet.h"



/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［PrtBuf.h］

//#include "PrtConfig.h" //AMO註解;AMO;2018.05.25
#if(PRT_WIDTH_80mm == 1)
	#define	MaxDotPos           576
#else
    #define	MaxDotPos           384 //目前設定為384行;AMO;2018.05.25
#endif

#define NumOfCharLine          2
#define PRTBUFHIGHT           12  //打印行高12个字节
#define PRTLINEHIGHT          24  //打印行高24个点
#define ONEDOTSTEPNUM          2  //2步一点行
#define HZ_WIDTH              24  //汉字横向占得点数
#define ASCII_WIDTH           12  //ascii横向占得点数
#define SFONT_WIDTH            9  //small FONT横向占得点数
#define BIT_IMAGE_SIZE         5  //下载logo的数量

extern uint8_t cAsciiHightMultiple_Prt;
extern uint8_t cChineseHightMultiple_Prt;//新增 ;AMO;2018.05.25
extern uint8_t cAsciiRightSpace;
extern uint8_t cChineseLeftSpace;
extern uint8_t cChineseRightSpace;
extern uint8_t cAsciiWidthMultiple;
extern uint8_t cAsciiHightMultiple;
extern uint8_t cChineseWidthMultiple;
extern uint8_t cChineseHightMultiple;
extern uint32_t  iCurrentFillColumn;
extern uint32_t  iLineSpaceNumber;
extern uint8_t bFont12x24;
extern uint8_t cCurrentPrtCharLine;
extern uint8_t cCurrentFillRow;
extern uint8_t bTimer2Prt ;
extern uint8_t bTimer2FeedLine;
extern uint8_t bTimer2KeyFeed;
extern uint8_t bChinese;
extern uint8_t bHexDump;
extern uint8_t bSelfTest;
extern uint8_t bCharacterSel;
extern uint8_t bDensitySel;
extern uint8_t bHaveFilledAscii;
extern uint8_t bHaveFilledChinese;
extern uint8_t bHaveFilledBarCode;
extern uint8_t bHaveFilledRasterDot;
extern uint8_t bHaveFilledImageDot;
extern uint8_t bPrtAdverse;
extern uint8_t bAsciiUnderLine;
extern uint8_t bChineseUnderLine;
extern uint8_t bAlign;
extern uint8_t bBold;
extern uint32_t  iPrtLeftMargin;
extern uint32_t  iPrtRightMargin;
extern uint32_t  iRasterDotHight;
extern uint32_t  iImageDotHight;
extern uint8_t bUserChar;
extern uint8_t PrtConfigBuf[32];
extern uint8_t cCodePage;
extern uint8_t bPart1;//转换表1
extern uint8_t bPart2;//转换表2
extern uint8_t bPart3;//转换表3
extern uint8_t bPart4;//转换表4
extern uint8_t bFontBig5;
extern uint8_t bClearBarCode;

extern uint8_t HT_TAB[16];


enum enumCharLineStatus{
    Empty, Filling, Printing, FeedLine, WaitForPrint
};


enum ALIGN  
{
    Align_Left,Align_Middle,Align_Right,
};


enum enumInterCharSet{
    USA,    France, Germany,UK,DenmarkI,Sweden,Italy,SpainI,Japan,Norway,DenmarkII,
    //0,    1,      2,      3, 4,       5,     6,    7,     8,    9,     10
    SpainII,Latin,Korea,Croatia,China
    //11,   12 ,  13,   14,     15
};

extern enum enumInterCharSet cInternationalCharSet;

struct structByteLine{
    uint8_t BasePrtLine[MaxDotPos];
    //uint8_t cHaveData;
};


struct structCharLine{
    struct structByteLine ByteLine[PRTBUFHIGHT];  //PRTBUFHIGHT=12;AMO;2018.05.25
    uint8_t cNextCharLine;
    uint8_t bPrtRaster;
    uint8_t bPrtBarCode;
    uint32_t  iFeedStep;
    uint32_t  iPrtStep;
    uint32_t  iCurrentPrtDot;
    enum enumCharLineStatus Status;
};

extern struct structCharLine  PrtBuf[NumOfCharLine];

struct StructBarCode{
    uint8_t cHight;
    uint8_t cWidth;
    uint8_t cFont;
    uint8_t cFontPosition;
};

extern struct StructBarCode BarCode;


extern uint32_t CalculateChineseAddr(uint8_t cByte1, uint8_t cByte2, uint8_t cByte3, uint8_t cByte4);
extern uint32_t CalculateAsciiAddr(uint8_t cByte);
extern void GetChineseZimo(uint32_t Addr);
extern void GetAsciiZimo(uint32_t Addr);
extern void FillPrtBufChinese(void);
extern void FillPrtBufAscii(void);
extern void StartupPrint(uint8_t cNeedFeedLineSpace);
extern void ExecuteData(uint8_t data);
extern void ClrCharPrtBuf(uint8_t Line);
extern void BarCodeInit(void);
extern void SelfTestPrint(void);
extern void HexPrint(void);
extern uint8_t JudgeExceedByteLine(uint32_t iDotWillAdd);
extern void PrintStr(uint8_t *pPrintData, uint8_t fPrint);
extern void SendStr(uint8_t *pStr);
extern void CharacterModeSelect(void);


#ifdef __cplusplus
}
#endif

#endif /* __PRTBUF_H */

