/**
 * @file    mg32f10x_rcc.h
 * @author  megawin Application Team
 * @version V0.1.9
 * @date    18-May-2022
 * @brief   This file contains all the functions prototypes for the RCC firmware
 *          library.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MG32F10x_RCC_H
#define __MG32F10x_RCC_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "mg32f10x.h"

/** @addtogroup MG32F10x_StdPeriph_Driver
  * @{
  */

/** @addtogroup RCC
  * @{
  */

/* Exported types ------------------------------------------------------------*/

typedef struct
{
  uint32_t MAINCLK_Frequency;   /*!< returns MAINCLK clock frequency expressed in Hz */
  uint32_t AHBCLK_Frequency;    /*!< returns AHBCLK clock frequency expressed in Hz */
  uint32_t APB1CLK_Frequency;   /*!< returns APB1CLK clock frequency expressed in Hz */
  uint32_t APB2CLK_Frequency;   /*!< returns APB2CLK clock frequency expressed in Hz */
} RCC_ClocksTypeDef;

/* Exported constants --------------------------------------------------------*/

/** @defgroup RCC_Exported_Constants 
  * @{
  */

/** @defgroup PLL_entry_clock_source 
  * @{
  */
#define RCC_PLLSource_HSE_Div1      ((uint32_t)0x00000100)
#define RCC_PLLSource_HSE_Div2      ((uint32_t)0x00000101)
#define RCC_PLLSource_HSE_Div3      ((uint32_t)0x00000103)
#define RCC_PLLSource_HSE_Div4      ((uint32_t)0x00000105)
#define RCC_PLLSource_HSE_Div5      ((uint32_t)0x00000107)
#define RCC_PLLSource_HSE_Div6      ((uint32_t)0x00000109)
#define RCC_PLLSource_HSE_Div7      ((uint32_t)0x0000010B)
#define RCC_PLLSource_HSE_Div8      ((uint32_t)0x0000010D)
#define RCC_PLLSource_HSE_Div9      ((uint32_t)0x0000010F)
#define RCC_PLLSource_HSE_Div10     ((uint32_t)0x00000111)
#define RCC_PLLSource_HSE_Div11     ((uint32_t)0x00000113)
#define RCC_PLLSource_HSE_Div12     ((uint32_t)0x00000115)
#define RCC_PLLSource_HSE_Div13     ((uint32_t)0x00000117)
#define RCC_PLLSource_HSE_Div14     ((uint32_t)0x00000119)
#define RCC_PLLSource_HSE_Div15     ((uint32_t)0x0000011B)
#define RCC_PLLSource_HSE_Div16     ((uint32_t)0x0000011D)
#define RCC_PLLSource_MHSI_Div1     ((uint32_t)0x00000000)
#define RCC_PLLSource_MHSI_Div2     ((uint32_t)0x00000001)
#define RCC_PLLSource_MHSI_Div3     ((uint32_t)0x00000003)
#define RCC_PLLSource_MHSI_Div4     ((uint32_t)0x00000005)
#define RCC_PLLSource_MHSI_Div5     ((uint32_t)0x00000007)
#define RCC_PLLSource_MHSI_Div6     ((uint32_t)0x00000009)
#define RCC_PLLSource_MHSI_Div7     ((uint32_t)0x0000000B)
#define RCC_PLLSource_MHSI_Div8     ((uint32_t)0x0000000D)
#define RCC_PLLSource_MHSI_Div9     ((uint32_t)0x0000000F)
#define RCC_PLLSource_MHSI_Div10    ((uint32_t)0x00000011)
#define RCC_PLLSource_MHSI_Div11    ((uint32_t)0x00000013)
#define RCC_PLLSource_MHSI_Div12    ((uint32_t)0x00000015)
#define RCC_PLLSource_MHSI_Div13    ((uint32_t)0x00000017)
#define RCC_PLLSource_MHSI_Div14    ((uint32_t)0x00000019)
#define RCC_PLLSource_MHSI_Div15    ((uint32_t)0x0000001B)
#define RCC_PLLSource_MHSI_Div16    ((uint32_t)0x0000001D)
/**
  * @}
  */


/** @defgroup MAINCLK_source 
  * @{
  */
#define RCC_MAINCLKSource_MHSI     ((uint32_t)0x00000000)
#define RCC_MAINCLKSource_FHSI     ((uint32_t)0x00000001)
#define RCC_MAINCLKSource_PLLCLK   ((uint32_t)0x00000002)
#define RCC_MAINCLKSource_HSE      ((uint32_t)0x00000003)
/**
  * @}
  */


/** @defgroup USB_clock_source 
  * @{
  */
#define RCC_USBCLKSource_MAINCLK_Div1   ((uint32_t)0x00000000)
#define RCC_USBCLKSource_MAINCLK_1Div5  ((uint32_t)0x00000005)
#define RCC_USBCLKSource_MAINCLK_Div2   ((uint32_t)0x00000001)
#define RCC_USBCLKSource_MAINCLK_Div3   ((uint32_t)0x00000003)
/**
  * @}
  */


/** @defgroup AHB_APB1_APB2_clock_source 
  * @{
  */
#define RCC_MAINCLK_Div1      ((uint32_t)0x00000000)
#define RCC_MAINCLK_Div2      ((uint32_t)0x00000001)
#define RCC_MAINCLK_Div3      ((uint32_t)0x00000003)
#define RCC_MAINCLK_Div4      ((uint32_t)0x00000005)
#define RCC_MAINCLK_Div5      ((uint32_t)0x00000007)
#define RCC_MAINCLK_Div6      ((uint32_t)0x00000009)
#define RCC_MAINCLK_Div7      ((uint32_t)0x0000000B)
#define RCC_MAINCLK_Div8      ((uint32_t)0x0000000D)
#define RCC_MAINCLK_Div9      ((uint32_t)0x0000000F)
#define RCC_MAINCLK_Div10     ((uint32_t)0x00000011)
#define RCC_MAINCLK_Div11     ((uint32_t)0x00000013)
#define RCC_MAINCLK_Div12     ((uint32_t)0x00000015)
#define RCC_MAINCLK_Div13     ((uint32_t)0x00000017)
#define RCC_MAINCLK_Div14     ((uint32_t)0x00000019)
#define RCC_MAINCLK_Div15     ((uint32_t)0x0000001B)
#define RCC_MAINCLK_Div16     ((uint32_t)0x0000001D)
#define RCC_MAINCLK_Div17     ((uint32_t)0x0000001F)
#define RCC_MAINCLK_Div18     ((uint32_t)0x00000021)
#define RCC_MAINCLK_Div19     ((uint32_t)0x00000023)
#define RCC_MAINCLK_Div20     ((uint32_t)0x00000025)
#define RCC_MAINCLK_Div21     ((uint32_t)0x00000027)
#define RCC_MAINCLK_Div22     ((uint32_t)0x00000029)
#define RCC_MAINCLK_Div23     ((uint32_t)0x0000002B)
#define RCC_MAINCLK_Div24     ((uint32_t)0x0000002D)
#define RCC_MAINCLK_Div25     ((uint32_t)0x0000002F)
#define RCC_MAINCLK_Div26     ((uint32_t)0x00000031)
#define RCC_MAINCLK_Div27     ((uint32_t)0x00000033)
#define RCC_MAINCLK_Div28     ((uint32_t)0x00000035)
#define RCC_MAINCLK_Div29     ((uint32_t)0x00000037)
#define RCC_MAINCLK_Div30     ((uint32_t)0x00000039)
#define RCC_MAINCLK_Div31     ((uint32_t)0x0000003B)
#define RCC_MAINCLK_Div32     ((uint32_t)0x0000003D)
#define RCC_MAINCLK_Div33     ((uint32_t)0x0000003F)
#define RCC_MAINCLK_Div34     ((uint32_t)0x00000041)
#define RCC_MAINCLK_Div35     ((uint32_t)0x00000043)
#define RCC_MAINCLK_Div36     ((uint32_t)0x00000045)
#define RCC_MAINCLK_Div37     ((uint32_t)0x00000047)
#define RCC_MAINCLK_Div38     ((uint32_t)0x00000049)
#define RCC_MAINCLK_Div39     ((uint32_t)0x0000004B)
#define RCC_MAINCLK_Div40     ((uint32_t)0x0000004D)
#define RCC_MAINCLK_Div41     ((uint32_t)0x0000004F)
#define RCC_MAINCLK_Div42     ((uint32_t)0x00000051)
#define RCC_MAINCLK_Div43     ((uint32_t)0x00000053)
#define RCC_MAINCLK_Div44     ((uint32_t)0x00000055)
#define RCC_MAINCLK_Div45     ((uint32_t)0x00000057)
#define RCC_MAINCLK_Div46     ((uint32_t)0x00000059)
#define RCC_MAINCLK_Div47     ((uint32_t)0x0000005B)
#define RCC_MAINCLK_Div48     ((uint32_t)0x0000005D)
#define RCC_MAINCLK_Div49     ((uint32_t)0x0000005F)
#define RCC_MAINCLK_Div50     ((uint32_t)0x00000061)
#define RCC_MAINCLK_Div51     ((uint32_t)0x00000063)
#define RCC_MAINCLK_Div52     ((uint32_t)0x00000065)
#define RCC_MAINCLK_Div53     ((uint32_t)0x00000067)
#define RCC_MAINCLK_Div54     ((uint32_t)0x00000069)
#define RCC_MAINCLK_Div55     ((uint32_t)0x0000006B)
#define RCC_MAINCLK_Div56     ((uint32_t)0x0000006D)
#define RCC_MAINCLK_Div57     ((uint32_t)0x0000006F)
#define RCC_MAINCLK_Div58     ((uint32_t)0x00000071)
#define RCC_MAINCLK_Div59     ((uint32_t)0x00000073)
#define RCC_MAINCLK_Div60     ((uint32_t)0x00000075)
#define RCC_MAINCLK_Div61     ((uint32_t)0x00000077)
#define RCC_MAINCLK_Div62     ((uint32_t)0x00000079)
#define RCC_MAINCLK_Div63     ((uint32_t)0x0000007B)
#define RCC_MAINCLK_Div64     ((uint32_t)0x0000007D)
/**
  * @}
  */


/** @defgroup MCLK_clock_source 
  * @{
  */
#define RCC_MCLKSource_MAINCLK_Div1       ((uint32_t)0x00000000)
#define RCC_MCLKSource_MAINCLK_Div2       ((uint32_t)0x00000001)
#define RCC_MCLKSource_MAINCLK_Div3       ((uint32_t)0x00000003)
#define RCC_MCLKSource_MAINCLK_Div4       ((uint32_t)0x00000005)
#define RCC_MCLKSource_MAINCLK_Div5       ((uint32_t)0x00000007)
#define RCC_MCLKSource_MAINCLK_Div6       ((uint32_t)0x00000009)
#define RCC_MCLKSource_MAINCLK_Div7       ((uint32_t)0x0000000B)
#define RCC_MCLKSource_MAINCLK_Div8       ((uint32_t)0x0000000D)
#define RCC_MCLKSource_MAINCLK_Div9       ((uint32_t)0x0000000F)
#define RCC_MCLKSource_MAINCLK_Div10      ((uint32_t)0x00000011)
#define RCC_MCLKSource_MAINCLK_Div11      ((uint32_t)0x00000013)
#define RCC_MCLKSource_MAINCLK_Div12      ((uint32_t)0x00000015)
#define RCC_MCLKSource_MAINCLK_Div13      ((uint32_t)0x00000017)
#define RCC_MCLKSource_MAINCLK_Div14      ((uint32_t)0x00000019)
#define RCC_MCLKSource_MAINCLK_Div15      ((uint32_t)0x0000001B)
#define RCC_MCLKSource_MAINCLK_Div16      ((uint32_t)0x0000001D)
#define RCC_MCLKSource_MAINCLK_Div17      ((uint32_t)0x0000001F)
#define RCC_MCLKSource_MAINCLK_Div18      ((uint32_t)0x00000021)
#define RCC_MCLKSource_MAINCLK_Div19      ((uint32_t)0x00000023)
#define RCC_MCLKSource_MAINCLK_Div20      ((uint32_t)0x00000025)
#define RCC_MCLKSource_MAINCLK_Div21      ((uint32_t)0x00000027)
#define RCC_MCLKSource_MAINCLK_Div22      ((uint32_t)0x00000029)
#define RCC_MCLKSource_MAINCLK_Div23      ((uint32_t)0x0000002B)
#define RCC_MCLKSource_MAINCLK_Div24      ((uint32_t)0x0000002D)
#define RCC_MCLKSource_MAINCLK_Div25      ((uint32_t)0x0000002F)
#define RCC_MCLKSource_MAINCLK_Div26      ((uint32_t)0x00000031)
#define RCC_MCLKSource_MAINCLK_Div27      ((uint32_t)0x00000033)
#define RCC_MCLKSource_MAINCLK_Div28      ((uint32_t)0x00000035)
#define RCC_MCLKSource_MAINCLK_Div29      ((uint32_t)0x00000037)
#define RCC_MCLKSource_MAINCLK_Div30      ((uint32_t)0x00000039)
#define RCC_MCLKSource_MAINCLK_Div31      ((uint32_t)0x0000003B)
#define RCC_MCLKSource_MAINCLK_Div32      ((uint32_t)0x0000003D)
#define RCC_MCLKSource_MAINCLK_Div33      ((uint32_t)0x0000003F)
#define RCC_MCLKSource_MAINCLK_Div34      ((uint32_t)0x00000041)
#define RCC_MCLKSource_MAINCLK_Div35      ((uint32_t)0x00000043)
#define RCC_MCLKSource_MAINCLK_Div36      ((uint32_t)0x00000045)
#define RCC_MCLKSource_MAINCLK_Div37      ((uint32_t)0x00000047)
#define RCC_MCLKSource_MAINCLK_Div38      ((uint32_t)0x00000049)
#define RCC_MCLKSource_MAINCLK_Div39      ((uint32_t)0x0000004B)
#define RCC_MCLKSource_MAINCLK_Div40      ((uint32_t)0x0000004D)
#define RCC_MCLKSource_MAINCLK_Div41      ((uint32_t)0x0000004F)
#define RCC_MCLKSource_MAINCLK_Div42      ((uint32_t)0x00000051)
#define RCC_MCLKSource_MAINCLK_Div43      ((uint32_t)0x00000053)
#define RCC_MCLKSource_MAINCLK_Div44      ((uint32_t)0x00000055)
#define RCC_MCLKSource_MAINCLK_Div45      ((uint32_t)0x00000057)
#define RCC_MCLKSource_MAINCLK_Div46      ((uint32_t)0x00000059)
#define RCC_MCLKSource_MAINCLK_Div47      ((uint32_t)0x0000005B)
#define RCC_MCLKSource_MAINCLK_Div48      ((uint32_t)0x0000005D)
#define RCC_MCLKSource_MAINCLK_Div49      ((uint32_t)0x0000005F)
#define RCC_MCLKSource_MAINCLK_Div50      ((uint32_t)0x00000061)
#define RCC_MCLKSource_MAINCLK_Div51      ((uint32_t)0x00000063)
#define RCC_MCLKSource_MAINCLK_Div52      ((uint32_t)0x00000065)
#define RCC_MCLKSource_MAINCLK_Div53      ((uint32_t)0x00000067)
#define RCC_MCLKSource_MAINCLK_Div54      ((uint32_t)0x00000069)
#define RCC_MCLKSource_MAINCLK_Div55      ((uint32_t)0x0000006B)
#define RCC_MCLKSource_MAINCLK_Div56      ((uint32_t)0x0000006D)
#define RCC_MCLKSource_MAINCLK_Div57      ((uint32_t)0x0000006F)
#define RCC_MCLKSource_MAINCLK_Div58      ((uint32_t)0x00000071)
#define RCC_MCLKSource_MAINCLK_Div59      ((uint32_t)0x00000073)
#define RCC_MCLKSource_MAINCLK_Div60      ((uint32_t)0x00000075)
#define RCC_MCLKSource_MAINCLK_Div61      ((uint32_t)0x00000077)
#define RCC_MCLKSource_MAINCLK_Div62      ((uint32_t)0x00000079)
#define RCC_MCLKSource_MAINCLK_Div63      ((uint32_t)0x0000007B)
#define RCC_MCLKSource_MAINCLK_Div64      ((uint32_t)0x0000007D)
#define RCC_MCLKSource_FHSI_Div1          ((uint32_t)0x00000100)
#define RCC_MCLKSource_FHSI_Div2          ((uint32_t)0x00000101)
#define RCC_MCLKSource_FHSI_Div3          ((uint32_t)0x00000103)
#define RCC_MCLKSource_FHSI_Div4          ((uint32_t)0x00000105)
#define RCC_MCLKSource_FHSI_Div5          ((uint32_t)0x00000107)
#define RCC_MCLKSource_FHSI_Div6          ((uint32_t)0x00000109)
#define RCC_MCLKSource_FHSI_Div7          ((uint32_t)0x0000010B)
#define RCC_MCLKSource_FHSI_Div8          ((uint32_t)0x0000010D)
#define RCC_MCLKSource_FHSI_Div9          ((uint32_t)0x0000010F)
#define RCC_MCLKSource_FHSI_Div10         ((uint32_t)0x00000111)
#define RCC_MCLKSource_FHSI_Div11         ((uint32_t)0x00000113)
#define RCC_MCLKSource_FHSI_Div12         ((uint32_t)0x00000115)
#define RCC_MCLKSource_FHSI_Div13         ((uint32_t)0x00000117)
#define RCC_MCLKSource_FHSI_Div14         ((uint32_t)0x00000119)
#define RCC_MCLKSource_FHSI_Div15         ((uint32_t)0x0000011B)
#define RCC_MCLKSource_FHSI_Div16         ((uint32_t)0x0000011D)
#define RCC_MCLKSource_FHSI_Div17         ((uint32_t)0x0000011F)
#define RCC_MCLKSource_FHSI_Div18         ((uint32_t)0x00000121)
#define RCC_MCLKSource_FHSI_Div19         ((uint32_t)0x00000123)
#define RCC_MCLKSource_FHSI_Div20         ((uint32_t)0x00000125)
#define RCC_MCLKSource_FHSI_Div21         ((uint32_t)0x00000127)
#define RCC_MCLKSource_FHSI_Div22         ((uint32_t)0x00000129)
#define RCC_MCLKSource_FHSI_Div23         ((uint32_t)0x0000012B)
#define RCC_MCLKSource_FHSI_Div24         ((uint32_t)0x0000012D)
#define RCC_MCLKSource_FHSI_Div25         ((uint32_t)0x0000012F)
#define RCC_MCLKSource_FHSI_Div26         ((uint32_t)0x00000131)
#define RCC_MCLKSource_FHSI_Div27         ((uint32_t)0x00000133)
#define RCC_MCLKSource_FHSI_Div28         ((uint32_t)0x00000135)
#define RCC_MCLKSource_FHSI_Div29         ((uint32_t)0x00000137)
#define RCC_MCLKSource_FHSI_Div30         ((uint32_t)0x00000139)
#define RCC_MCLKSource_FHSI_Div31         ((uint32_t)0x0000013B)
#define RCC_MCLKSource_FHSI_Div32         ((uint32_t)0x0000013D)
#define RCC_MCLKSource_FHSI_Div33         ((uint32_t)0x0000013F)
#define RCC_MCLKSource_FHSI_Div34         ((uint32_t)0x00000141)
#define RCC_MCLKSource_FHSI_Div35         ((uint32_t)0x00000143)
#define RCC_MCLKSource_FHSI_Div36         ((uint32_t)0x00000145)
#define RCC_MCLKSource_FHSI_Div37         ((uint32_t)0x00000147)
#define RCC_MCLKSource_FHSI_Div38         ((uint32_t)0x00000149)
#define RCC_MCLKSource_FHSI_Div39         ((uint32_t)0x0000014B)
#define RCC_MCLKSource_FHSI_Div40         ((uint32_t)0x0000014D)
#define RCC_MCLKSource_FHSI_Div41         ((uint32_t)0x0000014F)
#define RCC_MCLKSource_FHSI_Div42         ((uint32_t)0x00000151)
#define RCC_MCLKSource_FHSI_Div43         ((uint32_t)0x00000153)
#define RCC_MCLKSource_FHSI_Div44         ((uint32_t)0x00000155)
#define RCC_MCLKSource_FHSI_Div45         ((uint32_t)0x00000157)
#define RCC_MCLKSource_FHSI_Div46         ((uint32_t)0x00000159)
#define RCC_MCLKSource_FHSI_Div47         ((uint32_t)0x0000015B)
#define RCC_MCLKSource_FHSI_Div48         ((uint32_t)0x0000015D)
#define RCC_MCLKSource_FHSI_Div49         ((uint32_t)0x0000015F)
#define RCC_MCLKSource_FHSI_Div50         ((uint32_t)0x00000161)
#define RCC_MCLKSource_FHSI_Div51         ((uint32_t)0x00000163)
#define RCC_MCLKSource_FHSI_Div52         ((uint32_t)0x00000165)
#define RCC_MCLKSource_FHSI_Div53         ((uint32_t)0x00000167)
#define RCC_MCLKSource_FHSI_Div54         ((uint32_t)0x00000169)
#define RCC_MCLKSource_FHSI_Div55         ((uint32_t)0x0000016B)
#define RCC_MCLKSource_FHSI_Div56         ((uint32_t)0x0000016D)
#define RCC_MCLKSource_FHSI_Div57         ((uint32_t)0x0000016F)
#define RCC_MCLKSource_FHSI_Div58         ((uint32_t)0x00000171)
#define RCC_MCLKSource_FHSI_Div59         ((uint32_t)0x00000173)
#define RCC_MCLKSource_FHSI_Div60         ((uint32_t)0x00000175)
#define RCC_MCLKSource_FHSI_Div61         ((uint32_t)0x00000177)
#define RCC_MCLKSource_FHSI_Div62         ((uint32_t)0x00000179)
#define RCC_MCLKSource_FHSI_Div63         ((uint32_t)0x0000017B)
#define RCC_MCLKSource_FHSI_Div64         ((uint32_t)0x0000017D)
/**
  * @}
  */


/** @defgroup I2SCLK_clock_source 
  * @{
  */
#define RCC_MCLK_Div1     ((uint32_t)0x00000000)
#define RCC_MCLK_Div2     ((uint32_t)0x00000001)
#define RCC_MCLK_Div3     ((uint32_t)0x00000003)
#define RCC_MCLK_Div4     ((uint32_t)0x00000005)
#define RCC_MCLK_Div5     ((uint32_t)0x00000007)
#define RCC_MCLK_Div6     ((uint32_t)0x00000009)
#define RCC_MCLK_Div7     ((uint32_t)0x0000000B)
#define RCC_MCLK_Div8     ((uint32_t)0x0000000D)
#define RCC_MCLK_Div9     ((uint32_t)0x0000000F)
#define RCC_MCLK_Div10    ((uint32_t)0x00000011)
#define RCC_MCLK_Div11    ((uint32_t)0x00000013)
#define RCC_MCLK_Div12    ((uint32_t)0x00000015)
#define RCC_MCLK_Div13    ((uint32_t)0x00000017)
#define RCC_MCLK_Div14    ((uint32_t)0x00000019)
#define RCC_MCLK_Div15    ((uint32_t)0x0000001B)
#define RCC_MCLK_Div16    ((uint32_t)0x0000001D)
#define RCC_MCLK_Div17    ((uint32_t)0x0000001F)
#define RCC_MCLK_Div18    ((uint32_t)0x00000021)
#define RCC_MCLK_Div19    ((uint32_t)0x00000023)
#define RCC_MCLK_Div20    ((uint32_t)0x00000025)
#define RCC_MCLK_Div21    ((uint32_t)0x00000027)
#define RCC_MCLK_Div22    ((uint32_t)0x00000029)
#define RCC_MCLK_Div23    ((uint32_t)0x0000002B)
#define RCC_MCLK_Div24    ((uint32_t)0x0000002D)
#define RCC_MCLK_Div25    ((uint32_t)0x0000002F)
#define RCC_MCLK_Div26    ((uint32_t)0x00000031)
#define RCC_MCLK_Div27    ((uint32_t)0x00000033)
#define RCC_MCLK_Div28    ((uint32_t)0x00000035)
#define RCC_MCLK_Div29    ((uint32_t)0x00000037)
#define RCC_MCLK_Div30    ((uint32_t)0x00000039)
#define RCC_MCLK_Div31    ((uint32_t)0x0000003B)
#define RCC_MCLK_Div32    ((uint32_t)0x0000003D)
#define RCC_MCLK_Div33    ((uint32_t)0x0000003F)
#define RCC_MCLK_Div34    ((uint32_t)0x00000041)
#define RCC_MCLK_Div35    ((uint32_t)0x00000043)
#define RCC_MCLK_Div36    ((uint32_t)0x00000045)
#define RCC_MCLK_Div37    ((uint32_t)0x00000047)
#define RCC_MCLK_Div38    ((uint32_t)0x00000049)
#define RCC_MCLK_Div39    ((uint32_t)0x0000004B)
#define RCC_MCLK_Div40    ((uint32_t)0x0000004D)
#define RCC_MCLK_Div41    ((uint32_t)0x0000004F)
#define RCC_MCLK_Div42    ((uint32_t)0x00000051)
#define RCC_MCLK_Div43    ((uint32_t)0x00000053)
#define RCC_MCLK_Div44    ((uint32_t)0x00000055)
#define RCC_MCLK_Div45    ((uint32_t)0x00000057)
#define RCC_MCLK_Div46    ((uint32_t)0x00000059)
#define RCC_MCLK_Div47    ((uint32_t)0x0000005B)
#define RCC_MCLK_Div48    ((uint32_t)0x0000005D)
#define RCC_MCLK_Div49    ((uint32_t)0x0000005F)
#define RCC_MCLK_Div50    ((uint32_t)0x00000061)
#define RCC_MCLK_Div51    ((uint32_t)0x00000063)
#define RCC_MCLK_Div52    ((uint32_t)0x00000065)
#define RCC_MCLK_Div53    ((uint32_t)0x00000067)
#define RCC_MCLK_Div54    ((uint32_t)0x00000069)
#define RCC_MCLK_Div55    ((uint32_t)0x0000006B)
#define RCC_MCLK_Div56    ((uint32_t)0x0000006D)
#define RCC_MCLK_Div57    ((uint32_t)0x0000006F)
#define RCC_MCLK_Div58    ((uint32_t)0x00000071)
#define RCC_MCLK_Div59    ((uint32_t)0x00000073)
#define RCC_MCLK_Div60    ((uint32_t)0x00000075)
#define RCC_MCLK_Div61    ((uint32_t)0x00000077)
#define RCC_MCLK_Div62    ((uint32_t)0x00000079)
#define RCC_MCLK_Div63    ((uint32_t)0x0000007B)
#define RCC_MCLK_Div64    ((uint32_t)0x0000007D)
#define RCC_MCLK_Div65    ((uint32_t)0x0000007F)
#define RCC_MCLK_Div66    ((uint32_t)0x00000081)
#define RCC_MCLK_Div67    ((uint32_t)0x00000083)
#define RCC_MCLK_Div68    ((uint32_t)0x00000085)
#define RCC_MCLK_Div69    ((uint32_t)0x00000087)
#define RCC_MCLK_Div70    ((uint32_t)0x00000089)
#define RCC_MCLK_Div71    ((uint32_t)0x0000008B)
#define RCC_MCLK_Div72    ((uint32_t)0x0000008D)
#define RCC_MCLK_Div73    ((uint32_t)0x0000008F)
#define RCC_MCLK_Div74    ((uint32_t)0x00000091)
#define RCC_MCLK_Div75    ((uint32_t)0x00000093)
#define RCC_MCLK_Div76    ((uint32_t)0x00000095)
#define RCC_MCLK_Div77    ((uint32_t)0x00000097)
#define RCC_MCLK_Div78    ((uint32_t)0x00000099)
#define RCC_MCLK_Div79    ((uint32_t)0x0000009B)
#define RCC_MCLK_Div80    ((uint32_t)0x0000009D)
#define RCC_MCLK_Div81    ((uint32_t)0x0000009F)
#define RCC_MCLK_Div82    ((uint32_t)0x000000A1)
#define RCC_MCLK_Div83    ((uint32_t)0x000000A3)
#define RCC_MCLK_Div84    ((uint32_t)0x000000A5)
#define RCC_MCLK_Div85    ((uint32_t)0x000000A7)
#define RCC_MCLK_Div86    ((uint32_t)0x000000A9)
#define RCC_MCLK_Div87    ((uint32_t)0x000000AB)
#define RCC_MCLK_Div88    ((uint32_t)0x000000AD)
#define RCC_MCLK_Div89    ((uint32_t)0x000000AF)
#define RCC_MCLK_Div90    ((uint32_t)0x000000B1)
#define RCC_MCLK_Div91    ((uint32_t)0x000000B3)
#define RCC_MCLK_Div92    ((uint32_t)0x000000B5)
#define RCC_MCLK_Div93    ((uint32_t)0x000000B7)
#define RCC_MCLK_Div94    ((uint32_t)0x000000B9)
#define RCC_MCLK_Div95    ((uint32_t)0x000000BB)
#define RCC_MCLK_Div96    ((uint32_t)0x000000BD)
#define RCC_MCLK_Div97    ((uint32_t)0x000000BF)
#define RCC_MCLK_Div98    ((uint32_t)0x000000C1)
#define RCC_MCLK_Div99    ((uint32_t)0x000000C3)
#define RCC_MCLK_Div100   ((uint32_t)0x000000C5)
#define RCC_MCLK_Div101   ((uint32_t)0x000000C7)
#define RCC_MCLK_Div102   ((uint32_t)0x000000C9)
#define RCC_MCLK_Div103   ((uint32_t)0x000000CB)
#define RCC_MCLK_Div104   ((uint32_t)0x000000CD)
#define RCC_MCLK_Div105   ((uint32_t)0x000000CF)
#define RCC_MCLK_Div106   ((uint32_t)0x000000D1)
#define RCC_MCLK_Div107   ((uint32_t)0x000000D3)
#define RCC_MCLK_Div108   ((uint32_t)0x000000D5)
#define RCC_MCLK_Div109   ((uint32_t)0x000000D7)
#define RCC_MCLK_Div110   ((uint32_t)0x000000D9)
#define RCC_MCLK_Div111   ((uint32_t)0x000000DB)
#define RCC_MCLK_Div112   ((uint32_t)0x000000DD)
#define RCC_MCLK_Div113   ((uint32_t)0x000000DF)
#define RCC_MCLK_Div114   ((uint32_t)0x000000E1)
#define RCC_MCLK_Div115   ((uint32_t)0x000000E3)
#define RCC_MCLK_Div116   ((uint32_t)0x000000E5)
#define RCC_MCLK_Div117   ((uint32_t)0x000000E7)
#define RCC_MCLK_Div118   ((uint32_t)0x000000E9)
#define RCC_MCLK_Div119   ((uint32_t)0x000000EB)
#define RCC_MCLK_Div120   ((uint32_t)0x000000ED)
#define RCC_MCLK_Div121   ((uint32_t)0x000000EF)
#define RCC_MCLK_Div122   ((uint32_t)0x000000F1)
#define RCC_MCLK_Div123   ((uint32_t)0x000000F3)
#define RCC_MCLK_Div124   ((uint32_t)0x000000F5)
#define RCC_MCLK_Div125   ((uint32_t)0x000000F7)
#define RCC_MCLK_Div126   ((uint32_t)0x000000F9)
#define RCC_MCLK_Div127   ((uint32_t)0x000000FB)
#define RCC_MCLK_Div128   ((uint32_t)0x000000FD)
#define RCC_MCLK_Div129   ((uint32_t)0x000000FF)
#define RCC_MCLK_Div130   ((uint32_t)0x00000101)
#define RCC_MCLK_Div131   ((uint32_t)0x00000103)
#define RCC_MCLK_Div132   ((uint32_t)0x00000105)
#define RCC_MCLK_Div133   ((uint32_t)0x00000107)
#define RCC_MCLK_Div134   ((uint32_t)0x00000109)
#define RCC_MCLK_Div135   ((uint32_t)0x0000010B)
#define RCC_MCLK_Div136   ((uint32_t)0x0000010D)
#define RCC_MCLK_Div137   ((uint32_t)0x0000010F)
#define RCC_MCLK_Div138   ((uint32_t)0x00000111)
#define RCC_MCLK_Div139   ((uint32_t)0x00000113)
#define RCC_MCLK_Div140   ((uint32_t)0x00000115)
#define RCC_MCLK_Div141   ((uint32_t)0x00000117)
#define RCC_MCLK_Div142   ((uint32_t)0x00000119)
#define RCC_MCLK_Div143   ((uint32_t)0x0000011B)
#define RCC_MCLK_Div144   ((uint32_t)0x0000011D)
#define RCC_MCLK_Div145   ((uint32_t)0x0000011F)
#define RCC_MCLK_Div146   ((uint32_t)0x00000121)
#define RCC_MCLK_Div147   ((uint32_t)0x00000123)
#define RCC_MCLK_Div148   ((uint32_t)0x00000125)
#define RCC_MCLK_Div149   ((uint32_t)0x00000127)
#define RCC_MCLK_Div150   ((uint32_t)0x00000129)
#define RCC_MCLK_Div151   ((uint32_t)0x0000012B)
#define RCC_MCLK_Div152   ((uint32_t)0x0000012D)
#define RCC_MCLK_Div153   ((uint32_t)0x0000012F)
#define RCC_MCLK_Div154   ((uint32_t)0x00000131)
#define RCC_MCLK_Div155   ((uint32_t)0x00000133)
#define RCC_MCLK_Div156   ((uint32_t)0x00000135)
#define RCC_MCLK_Div157   ((uint32_t)0x00000137)
#define RCC_MCLK_Div158   ((uint32_t)0x00000139)
#define RCC_MCLK_Div159   ((uint32_t)0x0000013B)
#define RCC_MCLK_Div160   ((uint32_t)0x0000013D)
#define RCC_MCLK_Div161   ((uint32_t)0x0000013F)
#define RCC_MCLK_Div162   ((uint32_t)0x00000141)
#define RCC_MCLK_Div163   ((uint32_t)0x00000143)
#define RCC_MCLK_Div164   ((uint32_t)0x00000145)
#define RCC_MCLK_Div165   ((uint32_t)0x00000147)
#define RCC_MCLK_Div166   ((uint32_t)0x00000149)
#define RCC_MCLK_Div167   ((uint32_t)0x0000014B)
#define RCC_MCLK_Div168   ((uint32_t)0x0000014D)
#define RCC_MCLK_Div169   ((uint32_t)0x0000014F)
#define RCC_MCLK_Div170   ((uint32_t)0x00000151)
#define RCC_MCLK_Div171   ((uint32_t)0x00000153)
#define RCC_MCLK_Div172   ((uint32_t)0x00000155)
#define RCC_MCLK_Div173   ((uint32_t)0x00000157)
#define RCC_MCLK_Div174   ((uint32_t)0x00000159)
#define RCC_MCLK_Div175   ((uint32_t)0x0000015B)
#define RCC_MCLK_Div176   ((uint32_t)0x0000015D)
#define RCC_MCLK_Div177   ((uint32_t)0x0000015F)
#define RCC_MCLK_Div178   ((uint32_t)0x00000161)
#define RCC_MCLK_Div179   ((uint32_t)0x00000163)
#define RCC_MCLK_Div180   ((uint32_t)0x00000165)
#define RCC_MCLK_Div181   ((uint32_t)0x00000167)
#define RCC_MCLK_Div182   ((uint32_t)0x00000169)
#define RCC_MCLK_Div183   ((uint32_t)0x0000016B)
#define RCC_MCLK_Div184   ((uint32_t)0x0000016D)
#define RCC_MCLK_Div185   ((uint32_t)0x0000016F)
#define RCC_MCLK_Div186   ((uint32_t)0x00000171)
#define RCC_MCLK_Div187   ((uint32_t)0x00000173)
#define RCC_MCLK_Div188   ((uint32_t)0x00000175)
#define RCC_MCLK_Div189   ((uint32_t)0x00000177)
#define RCC_MCLK_Div190   ((uint32_t)0x00000179)
#define RCC_MCLK_Div191   ((uint32_t)0x0000017B)
#define RCC_MCLK_Div192   ((uint32_t)0x0000017D)
#define RCC_MCLK_Div193   ((uint32_t)0x0000017F)
#define RCC_MCLK_Div194   ((uint32_t)0x00000181)
#define RCC_MCLK_Div195   ((uint32_t)0x00000183)
#define RCC_MCLK_Div196   ((uint32_t)0x00000185)
#define RCC_MCLK_Div197   ((uint32_t)0x00000187)
#define RCC_MCLK_Div198   ((uint32_t)0x00000189)
#define RCC_MCLK_Div199   ((uint32_t)0x0000018B)
#define RCC_MCLK_Div200   ((uint32_t)0x0000018D)
#define RCC_MCLK_Div201   ((uint32_t)0x0000018F)
#define RCC_MCLK_Div202   ((uint32_t)0x00000191)
#define RCC_MCLK_Div203   ((uint32_t)0x00000193)
#define RCC_MCLK_Div204   ((uint32_t)0x00000195)
#define RCC_MCLK_Div205   ((uint32_t)0x00000197)
#define RCC_MCLK_Div206   ((uint32_t)0x00000199)
#define RCC_MCLK_Div207   ((uint32_t)0x0000019B)
#define RCC_MCLK_Div208   ((uint32_t)0x0000019D)
#define RCC_MCLK_Div209   ((uint32_t)0x0000019F)
#define RCC_MCLK_Div210   ((uint32_t)0x000001A1)
#define RCC_MCLK_Div211   ((uint32_t)0x000001A3)
#define RCC_MCLK_Div212   ((uint32_t)0x000001A5)
#define RCC_MCLK_Div213   ((uint32_t)0x000001A7)
#define RCC_MCLK_Div214   ((uint32_t)0x000001A9)
#define RCC_MCLK_Div215   ((uint32_t)0x000001AB)
#define RCC_MCLK_Div216   ((uint32_t)0x000001AD)
#define RCC_MCLK_Div217   ((uint32_t)0x000001AF)
#define RCC_MCLK_Div218   ((uint32_t)0x000001B1)
#define RCC_MCLK_Div219   ((uint32_t)0x000001B3)
#define RCC_MCLK_Div220   ((uint32_t)0x000001B5)
#define RCC_MCLK_Div221   ((uint32_t)0x000001B7)
#define RCC_MCLK_Div222   ((uint32_t)0x000001B9)
#define RCC_MCLK_Div223   ((uint32_t)0x000001BB)
#define RCC_MCLK_Div224   ((uint32_t)0x000001BD)
#define RCC_MCLK_Div225   ((uint32_t)0x000001BF)
#define RCC_MCLK_Div226   ((uint32_t)0x000001C1)
#define RCC_MCLK_Div227   ((uint32_t)0x000001C3)
#define RCC_MCLK_Div228   ((uint32_t)0x000001C5)
#define RCC_MCLK_Div229   ((uint32_t)0x000001C7)
#define RCC_MCLK_Div230   ((uint32_t)0x000001C9)
#define RCC_MCLK_Div231   ((uint32_t)0x000001CB)
#define RCC_MCLK_Div232   ((uint32_t)0x000001CD)
#define RCC_MCLK_Div233   ((uint32_t)0x000001CF)
#define RCC_MCLK_Div234   ((uint32_t)0x000001D1)
#define RCC_MCLK_Div235   ((uint32_t)0x000001D3)
#define RCC_MCLK_Div236   ((uint32_t)0x000001D5)
#define RCC_MCLK_Div237   ((uint32_t)0x000001D7)
#define RCC_MCLK_Div238   ((uint32_t)0x000001D9)
#define RCC_MCLK_Div239   ((uint32_t)0x000001DB)
#define RCC_MCLK_Div240   ((uint32_t)0x000001DD)
#define RCC_MCLK_Div241   ((uint32_t)0x000001DF)
#define RCC_MCLK_Div242   ((uint32_t)0x000001E1)
#define RCC_MCLK_Div243   ((uint32_t)0x000001E3)
#define RCC_MCLK_Div244   ((uint32_t)0x000001E5)
#define RCC_MCLK_Div245   ((uint32_t)0x000001E7)
#define RCC_MCLK_Div246   ((uint32_t)0x000001E9)
#define RCC_MCLK_Div247   ((uint32_t)0x000001EB)
#define RCC_MCLK_Div248   ((uint32_t)0x000001ED)
#define RCC_MCLK_Div249   ((uint32_t)0x000001EF)
#define RCC_MCLK_Div250   ((uint32_t)0x000001F1)
#define RCC_MCLK_Div251   ((uint32_t)0x000001F3)
#define RCC_MCLK_Div252   ((uint32_t)0x000001F5)
#define RCC_MCLK_Div253   ((uint32_t)0x000001F7)
#define RCC_MCLK_Div254   ((uint32_t)0x000001F9)
#define RCC_MCLK_Div255   ((uint32_t)0x000001FB)
#define RCC_MCLK_Div256   ((uint32_t)0x000001FD)
#define RCC_MCLK_Div257   ((uint32_t)0x000001FF)
#define RCC_MCLK_Div258   ((uint32_t)0x00000201)
#define RCC_MCLK_Div259   ((uint32_t)0x00000203)
#define RCC_MCLK_Div260   ((uint32_t)0x00000205)
#define RCC_MCLK_Div261   ((uint32_t)0x00000207)
#define RCC_MCLK_Div262   ((uint32_t)0x00000209)
#define RCC_MCLK_Div263   ((uint32_t)0x0000020B)
#define RCC_MCLK_Div264   ((uint32_t)0x0000020D)
#define RCC_MCLK_Div265   ((uint32_t)0x0000020F)
#define RCC_MCLK_Div266   ((uint32_t)0x00000211)
#define RCC_MCLK_Div267   ((uint32_t)0x00000213)
#define RCC_MCLK_Div268   ((uint32_t)0x00000215)
#define RCC_MCLK_Div269   ((uint32_t)0x00000217)
#define RCC_MCLK_Div270   ((uint32_t)0x00000219)
#define RCC_MCLK_Div271   ((uint32_t)0x0000021B)
#define RCC_MCLK_Div272   ((uint32_t)0x0000021D)
#define RCC_MCLK_Div273   ((uint32_t)0x0000021F)
#define RCC_MCLK_Div274   ((uint32_t)0x00000221)
#define RCC_MCLK_Div275   ((uint32_t)0x00000223)
#define RCC_MCLK_Div276   ((uint32_t)0x00000225)
#define RCC_MCLK_Div277   ((uint32_t)0x00000227)
#define RCC_MCLK_Div278   ((uint32_t)0x00000229)
#define RCC_MCLK_Div279   ((uint32_t)0x0000022B)
#define RCC_MCLK_Div280   ((uint32_t)0x0000022D)
#define RCC_MCLK_Div281   ((uint32_t)0x0000022F)
#define RCC_MCLK_Div282   ((uint32_t)0x00000231)
#define RCC_MCLK_Div283   ((uint32_t)0x00000233)
#define RCC_MCLK_Div284   ((uint32_t)0x00000235)
#define RCC_MCLK_Div285   ((uint32_t)0x00000237)
#define RCC_MCLK_Div286   ((uint32_t)0x00000239)
#define RCC_MCLK_Div287   ((uint32_t)0x0000023B)
#define RCC_MCLK_Div288   ((uint32_t)0x0000023D)
#define RCC_MCLK_Div289   ((uint32_t)0x0000023F)
#define RCC_MCLK_Div290   ((uint32_t)0x00000241)
#define RCC_MCLK_Div291   ((uint32_t)0x00000243)
#define RCC_MCLK_Div292   ((uint32_t)0x00000245)
#define RCC_MCLK_Div293   ((uint32_t)0x00000247)
#define RCC_MCLK_Div294   ((uint32_t)0x00000249)
#define RCC_MCLK_Div295   ((uint32_t)0x0000024B)
#define RCC_MCLK_Div296   ((uint32_t)0x0000024D)
#define RCC_MCLK_Div297   ((uint32_t)0x0000024F)
#define RCC_MCLK_Div298   ((uint32_t)0x00000251)
#define RCC_MCLK_Div299   ((uint32_t)0x00000253)
#define RCC_MCLK_Div300   ((uint32_t)0x00000255)
#define RCC_MCLK_Div301   ((uint32_t)0x00000257)
#define RCC_MCLK_Div302   ((uint32_t)0x00000259)
#define RCC_MCLK_Div303   ((uint32_t)0x0000025B)
#define RCC_MCLK_Div304   ((uint32_t)0x0000025D)
#define RCC_MCLK_Div305   ((uint32_t)0x0000025F)
#define RCC_MCLK_Div306   ((uint32_t)0x00000261)
#define RCC_MCLK_Div307   ((uint32_t)0x00000263)
#define RCC_MCLK_Div308   ((uint32_t)0x00000265)
#define RCC_MCLK_Div309   ((uint32_t)0x00000267)
#define RCC_MCLK_Div310   ((uint32_t)0x00000269)
#define RCC_MCLK_Div311   ((uint32_t)0x0000026B)
#define RCC_MCLK_Div312   ((uint32_t)0x0000026D)
#define RCC_MCLK_Div313   ((uint32_t)0x0000026F)
#define RCC_MCLK_Div314   ((uint32_t)0x00000271)
#define RCC_MCLK_Div315   ((uint32_t)0x00000273)
#define RCC_MCLK_Div316   ((uint32_t)0x00000275)
#define RCC_MCLK_Div317   ((uint32_t)0x00000277)
#define RCC_MCLK_Div318   ((uint32_t)0x00000279)
#define RCC_MCLK_Div319   ((uint32_t)0x0000027B)
#define RCC_MCLK_Div320   ((uint32_t)0x0000027D)
#define RCC_MCLK_Div321   ((uint32_t)0x0000027F)
#define RCC_MCLK_Div322   ((uint32_t)0x00000281)
#define RCC_MCLK_Div323   ((uint32_t)0x00000283)
#define RCC_MCLK_Div324   ((uint32_t)0x00000285)
#define RCC_MCLK_Div325   ((uint32_t)0x00000287)
#define RCC_MCLK_Div326   ((uint32_t)0x00000289)
#define RCC_MCLK_Div327   ((uint32_t)0x0000028B)
#define RCC_MCLK_Div328   ((uint32_t)0x0000028D)
#define RCC_MCLK_Div329   ((uint32_t)0x0000028F)
#define RCC_MCLK_Div330   ((uint32_t)0x00000291)
#define RCC_MCLK_Div331   ((uint32_t)0x00000293)
#define RCC_MCLK_Div332   ((uint32_t)0x00000295)
#define RCC_MCLK_Div333   ((uint32_t)0x00000297)
#define RCC_MCLK_Div334   ((uint32_t)0x00000299)
#define RCC_MCLK_Div335   ((uint32_t)0x0000029B)
#define RCC_MCLK_Div336   ((uint32_t)0x0000029D)
#define RCC_MCLK_Div337   ((uint32_t)0x0000029F)
#define RCC_MCLK_Div338   ((uint32_t)0x000002A1)
#define RCC_MCLK_Div339   ((uint32_t)0x000002A3)
#define RCC_MCLK_Div340   ((uint32_t)0x000002A5)
#define RCC_MCLK_Div341   ((uint32_t)0x000002A7)
#define RCC_MCLK_Div342   ((uint32_t)0x000002A9)
#define RCC_MCLK_Div343   ((uint32_t)0x000002AB)
#define RCC_MCLK_Div344   ((uint32_t)0x000002AD)
#define RCC_MCLK_Div345   ((uint32_t)0x000002AF)
#define RCC_MCLK_Div346   ((uint32_t)0x000002B1)
#define RCC_MCLK_Div347   ((uint32_t)0x000002B3)
#define RCC_MCLK_Div348   ((uint32_t)0x000002B5)
#define RCC_MCLK_Div349   ((uint32_t)0x000002B7)
#define RCC_MCLK_Div350   ((uint32_t)0x000002B9)
#define RCC_MCLK_Div351   ((uint32_t)0x000002BB)
#define RCC_MCLK_Div352   ((uint32_t)0x000002BD)
#define RCC_MCLK_Div353   ((uint32_t)0x000002BF)
#define RCC_MCLK_Div354   ((uint32_t)0x000002C1)
#define RCC_MCLK_Div355   ((uint32_t)0x000002C3)
#define RCC_MCLK_Div356   ((uint32_t)0x000002C5)
#define RCC_MCLK_Div357   ((uint32_t)0x000002C7)
#define RCC_MCLK_Div358   ((uint32_t)0x000002C9)
#define RCC_MCLK_Div359   ((uint32_t)0x000002CB)
#define RCC_MCLK_Div360   ((uint32_t)0x000002CD)
#define RCC_MCLK_Div361   ((uint32_t)0x000002CF)
#define RCC_MCLK_Div362   ((uint32_t)0x000002D1)
#define RCC_MCLK_Div363   ((uint32_t)0x000002D3)
#define RCC_MCLK_Div364   ((uint32_t)0x000002D5)
#define RCC_MCLK_Div365   ((uint32_t)0x000002D7)
#define RCC_MCLK_Div366   ((uint32_t)0x000002D9)
#define RCC_MCLK_Div367   ((uint32_t)0x000002DB)
#define RCC_MCLK_Div368   ((uint32_t)0x000002DD)
#define RCC_MCLK_Div369   ((uint32_t)0x000002DF)
#define RCC_MCLK_Div370   ((uint32_t)0x000002E1)
#define RCC_MCLK_Div371   ((uint32_t)0x000002E3)
#define RCC_MCLK_Div372   ((uint32_t)0x000002E5)
#define RCC_MCLK_Div373   ((uint32_t)0x000002E7)
#define RCC_MCLK_Div374   ((uint32_t)0x000002E9)
#define RCC_MCLK_Div375   ((uint32_t)0x000002EB)
#define RCC_MCLK_Div376   ((uint32_t)0x000002ED)
#define RCC_MCLK_Div377   ((uint32_t)0x000002EF)
#define RCC_MCLK_Div378   ((uint32_t)0x000002F1)
#define RCC_MCLK_Div379   ((uint32_t)0x000002F3)
#define RCC_MCLK_Div380   ((uint32_t)0x000002F5)
#define RCC_MCLK_Div381   ((uint32_t)0x000002F7)
#define RCC_MCLK_Div382   ((uint32_t)0x000002F9)
#define RCC_MCLK_Div383   ((uint32_t)0x000002FB)
#define RCC_MCLK_Div384   ((uint32_t)0x000002FD)
#define RCC_MCLK_Div385   ((uint32_t)0x000002FF)
#define RCC_MCLK_Div386   ((uint32_t)0x00000301)
#define RCC_MCLK_Div387   ((uint32_t)0x00000303)
#define RCC_MCLK_Div388   ((uint32_t)0x00000305)
#define RCC_MCLK_Div389   ((uint32_t)0x00000307)
#define RCC_MCLK_Div390   ((uint32_t)0x00000309)
#define RCC_MCLK_Div391   ((uint32_t)0x0000030B)
#define RCC_MCLK_Div392   ((uint32_t)0x0000030D)
#define RCC_MCLK_Div393   ((uint32_t)0x0000030F)
#define RCC_MCLK_Div394   ((uint32_t)0x00000311)
#define RCC_MCLK_Div395   ((uint32_t)0x00000313)
#define RCC_MCLK_Div396   ((uint32_t)0x00000315)
#define RCC_MCLK_Div397   ((uint32_t)0x00000317)
#define RCC_MCLK_Div398   ((uint32_t)0x00000319)
#define RCC_MCLK_Div399   ((uint32_t)0x0000031B)
#define RCC_MCLK_Div400   ((uint32_t)0x0000031D)
#define RCC_MCLK_Div401   ((uint32_t)0x0000031F)
#define RCC_MCLK_Div402   ((uint32_t)0x00000321)
#define RCC_MCLK_Div403   ((uint32_t)0x00000323)
#define RCC_MCLK_Div404   ((uint32_t)0x00000325)
#define RCC_MCLK_Div405   ((uint32_t)0x00000327)
#define RCC_MCLK_Div406   ((uint32_t)0x00000329)
#define RCC_MCLK_Div407   ((uint32_t)0x0000032B)
#define RCC_MCLK_Div408   ((uint32_t)0x0000032D)
#define RCC_MCLK_Div409   ((uint32_t)0x0000032F)
#define RCC_MCLK_Div410   ((uint32_t)0x00000331)
#define RCC_MCLK_Div411   ((uint32_t)0x00000333)
#define RCC_MCLK_Div412   ((uint32_t)0x00000335)
#define RCC_MCLK_Div413   ((uint32_t)0x00000337)
#define RCC_MCLK_Div414   ((uint32_t)0x00000339)
#define RCC_MCLK_Div415   ((uint32_t)0x0000033B)
#define RCC_MCLK_Div416   ((uint32_t)0x0000033D)
#define RCC_MCLK_Div417   ((uint32_t)0x0000033F)
#define RCC_MCLK_Div418   ((uint32_t)0x00000341)
#define RCC_MCLK_Div419   ((uint32_t)0x00000343)
#define RCC_MCLK_Div420   ((uint32_t)0x00000345)
#define RCC_MCLK_Div421   ((uint32_t)0x00000347)
#define RCC_MCLK_Div422   ((uint32_t)0x00000349)
#define RCC_MCLK_Div423   ((uint32_t)0x0000034B)
#define RCC_MCLK_Div424   ((uint32_t)0x0000034D)
#define RCC_MCLK_Div425   ((uint32_t)0x0000034F)
#define RCC_MCLK_Div426   ((uint32_t)0x00000351)
#define RCC_MCLK_Div427   ((uint32_t)0x00000353)
#define RCC_MCLK_Div428   ((uint32_t)0x00000355)
#define RCC_MCLK_Div429   ((uint32_t)0x00000357)
#define RCC_MCLK_Div430   ((uint32_t)0x00000359)
#define RCC_MCLK_Div431   ((uint32_t)0x0000035B)
#define RCC_MCLK_Div432   ((uint32_t)0x0000035D)
#define RCC_MCLK_Div433   ((uint32_t)0x0000035F)
#define RCC_MCLK_Div434   ((uint32_t)0x00000361)
#define RCC_MCLK_Div435   ((uint32_t)0x00000363)
#define RCC_MCLK_Div436   ((uint32_t)0x00000365)
#define RCC_MCLK_Div437   ((uint32_t)0x00000367)
#define RCC_MCLK_Div438   ((uint32_t)0x00000369)
#define RCC_MCLK_Div439   ((uint32_t)0x0000036B)
#define RCC_MCLK_Div440   ((uint32_t)0x0000036D)
#define RCC_MCLK_Div441   ((uint32_t)0x0000036F)
#define RCC_MCLK_Div442   ((uint32_t)0x00000371)
#define RCC_MCLK_Div443   ((uint32_t)0x00000373)
#define RCC_MCLK_Div444   ((uint32_t)0x00000375)
#define RCC_MCLK_Div445   ((uint32_t)0x00000377)
#define RCC_MCLK_Div446   ((uint32_t)0x00000379)
#define RCC_MCLK_Div447   ((uint32_t)0x0000037B)
#define RCC_MCLK_Div448   ((uint32_t)0x0000037D)
#define RCC_MCLK_Div449   ((uint32_t)0x0000037F)
#define RCC_MCLK_Div450   ((uint32_t)0x00000381)
#define RCC_MCLK_Div451   ((uint32_t)0x00000383)
#define RCC_MCLK_Div452   ((uint32_t)0x00000385)
#define RCC_MCLK_Div453   ((uint32_t)0x00000387)
#define RCC_MCLK_Div454   ((uint32_t)0x00000389)
#define RCC_MCLK_Div455   ((uint32_t)0x0000038B)
#define RCC_MCLK_Div456   ((uint32_t)0x0000038D)
#define RCC_MCLK_Div457   ((uint32_t)0x0000038F)
#define RCC_MCLK_Div458   ((uint32_t)0x00000391)
#define RCC_MCLK_Div459   ((uint32_t)0x00000393)
#define RCC_MCLK_Div460   ((uint32_t)0x00000395)
#define RCC_MCLK_Div461   ((uint32_t)0x00000397)
#define RCC_MCLK_Div462   ((uint32_t)0x00000399)
#define RCC_MCLK_Div463   ((uint32_t)0x0000039B)
#define RCC_MCLK_Div464   ((uint32_t)0x0000039D)
#define RCC_MCLK_Div465   ((uint32_t)0x0000039F)
#define RCC_MCLK_Div466   ((uint32_t)0x000003A1)
#define RCC_MCLK_Div467   ((uint32_t)0x000003A3)
#define RCC_MCLK_Div468   ((uint32_t)0x000003A5)
#define RCC_MCLK_Div469   ((uint32_t)0x000003A7)
#define RCC_MCLK_Div470   ((uint32_t)0x000003A9)
#define RCC_MCLK_Div471   ((uint32_t)0x000003AB)
#define RCC_MCLK_Div472   ((uint32_t)0x000003AD)
#define RCC_MCLK_Div473   ((uint32_t)0x000003AF)
#define RCC_MCLK_Div474   ((uint32_t)0x000003B1)
#define RCC_MCLK_Div475   ((uint32_t)0x000003B3)
#define RCC_MCLK_Div476   ((uint32_t)0x000003B5)
#define RCC_MCLK_Div477   ((uint32_t)0x000003B7)
#define RCC_MCLK_Div478   ((uint32_t)0x000003B9)
#define RCC_MCLK_Div479   ((uint32_t)0x000003BB)
#define RCC_MCLK_Div480   ((uint32_t)0x000003BD)
#define RCC_MCLK_Div481   ((uint32_t)0x000003BF)
#define RCC_MCLK_Div482   ((uint32_t)0x000003C1)
#define RCC_MCLK_Div483   ((uint32_t)0x000003C3)
#define RCC_MCLK_Div484   ((uint32_t)0x000003C5)
#define RCC_MCLK_Div485   ((uint32_t)0x000003C7)
#define RCC_MCLK_Div486   ((uint32_t)0x000003C9)
#define RCC_MCLK_Div487   ((uint32_t)0x000003CB)
#define RCC_MCLK_Div488   ((uint32_t)0x000003CD)
#define RCC_MCLK_Div489   ((uint32_t)0x000003CF)
#define RCC_MCLK_Div490   ((uint32_t)0x000003D1)
#define RCC_MCLK_Div491   ((uint32_t)0x000003D3)
#define RCC_MCLK_Div492   ((uint32_t)0x000003D5)
#define RCC_MCLK_Div493   ((uint32_t)0x000003D7)
#define RCC_MCLK_Div494   ((uint32_t)0x000003D9)
#define RCC_MCLK_Div495   ((uint32_t)0x000003DB)
#define RCC_MCLK_Div496   ((uint32_t)0x000003DD)
#define RCC_MCLK_Div497   ((uint32_t)0x000003DF)
#define RCC_MCLK_Div498   ((uint32_t)0x000003E1)
#define RCC_MCLK_Div499   ((uint32_t)0x000003E3)
#define RCC_MCLK_Div500   ((uint32_t)0x000003E5)
#define RCC_MCLK_Div501   ((uint32_t)0x000003E7)
#define RCC_MCLK_Div502   ((uint32_t)0x000003E9)
#define RCC_MCLK_Div503   ((uint32_t)0x000003EB)
#define RCC_MCLK_Div504   ((uint32_t)0x000003ED)
#define RCC_MCLK_Div505   ((uint32_t)0x000003EF)
#define RCC_MCLK_Div506   ((uint32_t)0x000003F1)
#define RCC_MCLK_Div507   ((uint32_t)0x000003F3)
#define RCC_MCLK_Div508   ((uint32_t)0x000003F5)
#define RCC_MCLK_Div509   ((uint32_t)0x000003F7)
#define RCC_MCLK_Div510   ((uint32_t)0x000003F9)
#define RCC_MCLK_Div511   ((uint32_t)0x000003FB)
#define RCC_MCLK_Div512   ((uint32_t)0x000003FD)
/**
  * @}
  */


/** @defgroup USBFIFOCLK_clock_source 
  * @{
  */
#define RCC_USBFIFOCLKSource_AHBCLK   ((uint32_t)0x00000000)
#define RCC_USBFIFOCLKSource_USBCLK   ((uint32_t)0x00000001)
/**
  * @}
  */


/** @defgroup Clock_source_to_output_on_MCO_pin 
  * @{
  */
#define RCC_MCO_NoClock       ((uint32_t)0x00000000)
#define RCC_MCO_AHBCLK        ((uint32_t)0x00000001)
#define RCC_MCO_HSE           ((uint32_t)0x00000002)
#define RCC_MCO_MHSI          ((uint32_t)0x00000004)
#define RCC_MCO_PLLCLK_Div2   ((uint32_t)0x00000008)
#define RCC_MCO_MCLK          ((uint32_t)0x00000010)
/**
  * @}
  */


/** @defgroup AHB_peripheral 
  * @{
  */
#define RCC_AHBPeriph_IWDG              ((uint32_t)0x00000004)
#define RCC_AHBPeriph_USB               ((uint32_t)0x00000200)
#define RCC_AHBPeriph_ISO               ((uint32_t)0x00000400)
#define RCC_AHBPeriph_FLASH             ((uint32_t)0x00000800)
#define RCC_AHBPeriph_CACHE             ((uint32_t)0x00001000)
#define RCC_AHBPeriph_SYS               ((uint32_t)0x00002000)
#define RCC_AHBPeriph_DMAC1Bridge       ((uint32_t)0x00004000)
#define RCC_AHBPeriph_DMAC2Bridge       ((uint32_t)0x00008000)
#define RCC_AHBPeriph_CRC_SFM           ((uint32_t)0x00010000)
#define RCC_AHBPeriph_BKP               ((uint32_t)0x04000000)
/**
  * @}
  */


/** @defgroup APB1_peripheral 
  * @{
  */
#define RCC_APB1Periph_DMAC1      ((uint32_t)0x00000001)
#define RCC_APB1Periph_TIM1       ((uint32_t)0x00000002)
#define RCC_APB1Periph_TIM2       ((uint32_t)0x00000004)
#define RCC_APB1Periph_TIM3       ((uint32_t)0x00000008)
#define RCC_APB1Periph_TIM4       ((uint32_t)0x00000010)
#define RCC_APB1Periph_GPIOA      ((uint32_t)0x00000020)
#define RCC_APB1Periph_GPIOB      ((uint32_t)0x00000040)
#define RCC_APB1Periph_GPIOC      ((uint32_t)0x00000080)
#define RCC_APB1Periph_GPIOD      ((uint32_t)0x00000100)
#define RCC_APB1Periph_EXTI       ((uint32_t)0x00000200)
#define RCC_APB1Periph_AFIO       ((uint32_t)0x00000400)
#define RCC_APB1Periph_ADC        ((uint32_t)0x00000800)
#define RCC_APB1Periph_QSPI       ((uint32_t)0x00001000)
#define RCC_APB1Periph_SPIS1      ((uint32_t)0x00002000)
#define RCC_APB1Periph_UART1      ((uint32_t)0x00004000)
#define RCC_APB1Periph_BMX1       ((uint32_t)0x00008000)
/**
  * @}
  */


/** @defgroup APB2_peripheral 
  * @{
  */
#define RCC_APB2Periph_DMAC2      ((uint32_t)0x00000001)
#define RCC_APB2Periph_WWDG       ((uint32_t)0x00000002)
#define RCC_APB2Periph_UART2      ((uint32_t)0x00000004)
#define RCC_APB2Periph_UART3      ((uint32_t)0x00000008)
#define RCC_APB2Periph_SPIM2      ((uint32_t)0x00000010)
#define RCC_APB2Periph_SPIS2      ((uint32_t)0x00000020)
#define RCC_APB2Periph_I2S        ((uint32_t)0x00000040)
#define RCC_APB2Periph_I2C1       ((uint32_t)0x00000080)
#define RCC_APB2Periph_I2C2       ((uint32_t)0x00000100)
#define RCC_APB2Periph_RNG        ((uint32_t)0x00000200)
#define RCC_APB2Periph_LED        ((uint32_t)0x00000400)
#define RCC_APB2Periph_BMX2       ((uint32_t)0x00000800)
/**
  * @}
  */


/** @defgroup RCC_Reset_Flag 
  * @{
  */
#define RCC_RSTFLAG_LPWRRST     ((uint32_t)0x00000001)
#define RCC_RSTFLAG_WWDGRST     ((uint32_t)0x00000002)
#define RCC_RSTFLAG_IWDGRST     ((uint32_t)0x00000004)
#define RCC_RSTFLAG_SFTRST      ((uint32_t)0x00000008)
#define RCC_RSTFLAG_PORRST      ((uint32_t)0x00000010)
#define RCC_RSTFLAG_PINRST      ((uint32_t)0x00000020)
/**
  * @}
  */

/**
  * @}
  */

/* Exported macro ------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

void RCC_PLLSourceConfig(uint32_t RCC_PLLSource, FunctionalState NewState);
void RCC_MAINCLKConfig(uint32_t RCC_MAINCLKSource);
void RCC_USBCLKConfig(uint32_t RCC_USBCLKSource, FunctionalState NewState);
void RCC_AHBCLKConfig(uint32_t RCC_MAINCLK);
void RCC_APB1CLKConfig(uint32_t RCC_MAINCLK, FunctionalState NewState);
void RCC_APB2CLKConfig(uint32_t RCC_MAINCLK, FunctionalState NewState);
void RCC_MCLKConfig(uint32_t RCC_MCLKSource, FunctionalState NewState);
void RCC_I2SCLKConfig(uint32_t RCC_MCLK, FunctionalState NewState);
void RCC_I2SCLKResetCmd(FunctionalState NewState);
void RCC_RNGCLKCmd(FunctionalState NewState);
void RCC_IWDGCLKCmd(FunctionalState NewState);
void RCC_DCSSCLKCmd(FunctionalState NewState);
void RCC_SPIS1CLKCmd(FunctionalState NewState);
void RCC_SPIS2CLKCmd(FunctionalState NewState);
void RCC_USBFIFOCLKConfig(uint32_t RCC_USBFIFOCLKSource);
void RCC_USBFIFOCLKCmd(FunctionalState NewState);
void RCC_MCOConfig(uint32_t RCC_MCO);
void RCC_GetClocksFreq(RCC_ClocksTypeDef* RCC_Clocks);
void RCC_AHBPeriphClockCmd(uint32_t RCC_AHBPeriph, FunctionalState NewState);
void RCC_APB1PeriphClockCmd(uint32_t RCC_APB1Periph, FunctionalState NewState);
void RCC_APB2PeriphClockCmd(uint32_t RCC_APB2Periph, FunctionalState NewState);
void RCC_AHBPeriphResetCmd(uint32_t RCC_AHBPeriph, FunctionalState NewState);
void RCC_APB1PeriphResetCmd(uint32_t RCC_APB1Periph, FunctionalState NewState);
void RCC_APB2PeriphResetCmd(uint32_t RCC_APB2Periph, FunctionalState NewState);
void RCC_BackupResetCmd(FunctionalState NewState);
FlagStatus RCC_GetResetFlagStatus(uint32_t RCC_RSTFLAG);
void RCC_ClearResetFlags(void);

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* __MG32F10x_RCC_H */
