/**
 * @file    BarCode_app.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the BarCode_app firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BARCODE_APP_H
#define __BARCODE_APP_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"
#include "BarCode.h"
#include "PrtBuf.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode_app.h］
/*************************************************
  Copyright (C), 2013-2113, XXX. Co., Ltd.
  文件名:        barcode_app.C
  Author:        XXX
  Version:       V1.0
  Date:          2013-08-15
  Description:   条码的相关处理头文件
  History:
     <author>      <time>     <version >     <desc>
     XXX        13/8/15     1.0        build this moudle 
*************************************************/
//#ifndef __BARCODE__APP__
//#define __BARCODE__APP__


#define SUCSS_BAR1              0
#define ERROR_CHAR              1
#define ERROR_LEN               2
#define ERROR_NOT_12            3
#define CODE93_INPUT_ERROR      49  //code93码输入不合法
#define CODABAR_INPUT_ERROR     20  //code93码输入不合法

#define HRI_NO                  0   //HRI在条码位置-无HRI
#define HRI_UP                  1   //HRI在条码位置-上
#define HRI_DN                  2   //HRI在条码位置-下
#define HRI_UP_DN               3   //HRI在条码位置-上下

#define CODE39_LEN              12  //code39条码的长度
#define CODE_GAP                1   //字符条码的宽度

#define CODE93_LEN              9   //code93条码的长度
#define CODE93_LASTLEN          1   //code93最后一位附加一个1

#define CODABAR_THIN_LEN        1   //codabar 细条宽度为1
#define CODABAR_THICK_LEN       2   //codabar 宽条宽度为2

#define CODABAR_BLACK_SINGLE    0   //codabar 黑色线条细
#define CODABAR_BLACK_DOUBLE    1   //codabar 黑色线条粗

#define UPCE_LEN                7   //UPCE条码的长度
#define UPCE_START_LEN          3   //UPCE开始条码长度
#define UPCE_END_LEN            6   //UPCE结束条码长度

#define CODE128_LEN             11  //CODE128条码长度
#define CODE128_END_LEN         13  //CODE128码的结束符长度

#define ITF_BLACK_WITDH         0   //codabar 黑色线条细
#define ITF_BLACK_NARROW        1   //codabar 黑色线条粗

#define ITF_WIDTH_LEN           2
#define ITF_NARROW_LEN          1

#define EAN_LEN                 7   //EAN13条码长度
#define EAN_SEG_LEN             3   //EAN13开始及结束条码长度
#define EAN_MID_LEN             5   //EAN13中间条码长度


#define UPCA                    0x41
#define UPCE                    0x42
#define EAN13                   0x43
#define EAN8                    0x44
#define CODE39                  0x45
#define ITF                     0x46
#define CODABAR                 0x47
#define CODE93                  0x48
#define CODE128                 0x49  

#define CODE128_START_A         208  
#define CODE128_START_B         209  
#define CODE128_START_C         210  
#define CODE128_START_STOP      211 

#define EAN_START               30
#define EAN_MID                 31  
#define EAN_END                 32  

#define CODE93_START_END        47
#define CODE93_LASTONEDOT       48  

#define ITF_START               10
#define ITF_END                 11

#define UPCE_START              20
#define UPCE_END                21

uint32_t GetCode39Dat(uint8_t Dat);
uint32_t GetCode128Dat(uint8_t Dat);
uint32_t GetEanDat(uint8_t Dat);
//uint32_t GetEan8Dat(uint8_t Dat);
extern void PrintOneBarCode39(void);
extern void PrintOneBarCode128(void);
extern void PrintOneBarEan8(void);
extern void PrintOneBarEan13(void);
extern void PrintOneBarUPCA(void);
extern void PrintOneBarUPCE(void);
extern void PrintOneBarITF(void);
extern void PrintOneBarCodaBar(void);
extern void PrintOneBarCode93(void);


#ifdef __cplusplus
}
#endif

#endif /* __BARCODE_APP_H */

