
#define		uCHAR	unsigned char
#define		uINT	unsigned short

#include "REG_MG82G5Exx.H"

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

uCHAR tmp;

bit ESF_Flag;


void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}



void Stop_WDT(void)
{
	tmp = ENW | CLRW;
	PageP_Write(0xE1, tmp);			//WDTCR is 0xE1.
}

void Start_WDT(void)
{
	WDTCR = (NSW | ENW | CLRW);
}

void Initial_WDT(void)
{
	PCON1 |= WDTF;			//clear WDTF
	Start_WDT();
	EIE1 |= ESF;																					//enable interrupt
	SFIE |= WDTFIE;
}

void INT_SYS(void)	interrupt	11	using	1
{
	PCON1 |= WDTF;			//clear WDTF
	ESF_Flag = 1;			//set ESF flag

}

void main(void)
{
	Initial_WDT();
	EA = 1;
	


	while(1)
	{
		if(ESF_Flag)
		{
			ESF_Flag = 0;
			// to do...
			P30 = ~P30;
		}
		
		PCON0 = PD;
	}
}
