//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"

#define BUSY 	0x08
#define START 	0x01

//********************************************************************************
//								   ADC INIT
//********************************************************************************
void Adc_Init (void){
	ADCCONT = ADCCONT_REGS;
	ADCSTR = ADCSTR_REGS | OPA_GAIN_REGS;
	ADCDLY = 0x30;
	IA_AD_OFFSET(512);		//512 = 2.5V; 1023 = 5V
	IB_AD_OFFSET(512);
}
//********************************************************************************
//								  ADC Channel
//********************************************************************************
unsigned int Adc_Channel (unsigned char Channel){
	uint16 Temp;
	ADCCONT = (ADCCONT | Channel);
	ADCSTR = (ADCSTR | START);
	while((ADCSTR & BUSY) == BUSY){}; //Check ADC Busy end
	Temp = ADCD1;
	Temp = Temp << 8;
	Temp |= ADCD2;
	ADCCONT = (ADCCONT & 0xF8);
	return Temp;
}
//********************************************************************************
//							  Correction Current
//********************************************************************************
xdata	signed int OPA_Offset;
// xdata	signed int OPA_Offset_ia;
// xdata	signed int OPA_Offset_ib;
xdata	signed int OPA_OffsetTemp;
// xdata	signed int OPA_OffsetTemp_ia;
// xdata	signed int OPA_OffsetTemp_ib;

xdata	signed int OPA_Offset_C = 0;
// xdata	signed int OPA_Offset_C_ia = 0;
// xdata	signed int OPA_Offset_C_ib = 0;

xdata	unsigned int OffsetCount;

void Correction_Current_AD_offset(void){
	signed long Tmp = Ibus_avg;

	// OPA_Offset_ia = DATA_FILTER(Adc_Channel(0), OPA_Offset_C_ia, OPA_OffsetTemp_ia, unsigned short, 1);
	// OPA_Offset_ib = DATA_FILTER(Adc_Channel(1), OPA_Offset_C_ib, OPA_OffsetTemp_ib, unsigned short, 1);
	OPA_OffsetTemp = DATA_FILTER(Tmp, OPA_Offset_C, OPA_OffsetTemp, signed short, 8);
	
	OffsetCount++;
	if(OffsetCount >= 500){
		OffsetCount = 0;
		
		OPA_Offset = OPA_OffsetTemp;
		OPA_OffsetTemp = 0;
		// OPA_OffsetTemp_ia = 0;
		// OPA_OffsetTemp_ib = 0;
		OPA_Offset_C = 0;
		// OPA_Offset_C_ia = 0;
		// OPA_Offset_C_ib = 0;
		FLAG.Current_offset = 1;
	}
}
