//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//data定義的變量放在單片機前128字節（0x00~0x7F）地址空間中
//idata定義的變量放在（0x00~0xFF）地址空間中
//xdata定義的變量則是放在單片機片上外部擴展RAM空間中（一般指外部0xF000~0xF1FF空間，具體空間大小因單片機而異，有的單片機沒有外部RAM）

//data定義的變量速度最快，idata次之，xdata較前兩者慢
//常被使用的變數用data/idata宣告; 不常使用的變數用xdata宣告.
//無特別宣告的變數，預設都是data


unsigned int  CaptureTotal;
unsigned int  CaptureTotalTemp;
//********************************************************************************
//							  Internal Capture Init
//********************************************************************************
#if (I_CAPTURE_MODE==1)
	void CAP_Init (void){
		SFR_PAGE = 1; // Internal 
		CAPCONT = I_CAPCONT_REGS;
	}
#endif
//********************************************************************************
//							  External Capture Init
//********************************************************************************
#if (E_CAPTURE_MODE==1)
	void EXCAP_Init (void){
		SFR_PAGE = 0; // External 
		CAPCONT = E_CAPCONT_REGS;
	}
#endif