/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			UART0 TX&RX interrupt
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46


#define UART0_RX_BUFF_SIZE   32   		 //Rx Buffer
#define UART0_TX_BUFF_SIZE   32   		 //Tx Buffer
xdata u8 RcvBuf[UART0_RX_BUFF_SIZE];
u8 Uart0RxIn =0;
u8 Uart0RxOut =0;
xdata u8 TxBuf[UART0_TX_BUFF_SIZE];
u8 Uart0TxIn =0;
u8 Uart0TxOut =0;
bit bUart0TxFlag;

u8 LedTime;

/***********************************************************************************
*Function:   void INT_UART0(void)
*Description:UART0 Interrupt handler
		 
*Input:   
*Output:     
*************************************************************************************/
void INT_UART0(void) interrupt INT_VECTOR_UART0
{
	_push_(SFRPI);		   //Save SFRPI

	SFR_SetPage(0);		   //S0CON 0 Only
	if(TI0)					// 
	{
	   TI0 = 0;	   
		if(Uart0TxIn==Uart0TxOut)
		{
			bUart0TxFlag=FALSE;
		}
		else
		{
			S0BUF=TxBuf[Uart0TxOut];
			bUart0TxFlag=TRUE;
			Uart0TxOut++;
			if(Uart0TxOut>=UART0_TX_BUFF_SIZE)
			{
				Uart0TxOut=0;
			}
		}
	}
	if(RI0)					//
	{
		RI0 = 0;				// Clear flag
		RcvBuf[Uart0RxIn] = S0BUF;
		Uart0RxIn++;
		if(Uart0RxIn >=UART0_RX_BUFF_SIZE)
		{
			Uart0RxIn =0;
		}
		
	}
	_pop_(SFRPI);		   // Restore SFRPI
}

/***********************************************************************************
*Function:   void INT_T0(void)
*Description:T0 Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;

	if(LedTime!=0) LedTime--;
}

/***********************************************************************************
*Function:void Uart0SendByteByInt(u8 tByte)
*Description:Uart0 send byte (by interrupt)
*Input:u8 tByte: the data to be send
*Output:     
*************************************************************************************/
void Uart0SendByteByInt(u8 tByte)
{
	u8 i;
	
	if(bUart0TxFlag==FALSE)
	{
		Uart0TxOut=0;
		Uart0TxIn=1;
		TxBuf[0]=tByte;
		TI0=1;
	}
	else
	{
		i=Uart0TxIn;
		TxBuf[i]=tByte;
		i++;
		if(i>=UART0_TX_BUFF_SIZE)
		{
			i=0;
		}
		while(i==Uart0TxOut)
		{
		}
		ES0=0;
		Uart0TxIn=i;
		ES0=1;
	}
}

/***********************************************************************************
*Function:void Uart0SendStrByInt(u8* PStr)
*Description:Uart0Uart send string (by interrupt)
*Input: u8* PStr:the string to be send
*Output:     
*************************************************************************************/
void Uart0SendStrByInt(u8* PStr)
{
	while(*PStr != 0)
	{
		Uart0SendByteByInt(*PStr);
		PStr ++;
	}
}


/***********************************************************************************
*Function:void Uart0SendByte(u8 tByte)
*Description:Uart0 send byte
*Input:u8 tByte: the data to be send
*Output:     
*************************************************************************************/
void Uart0SendByte(u8 tByte)
{
	bit bES0;
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
*Function:void Uart0SendStr(u8* PStr)
*Description:Uart0Uart send string
*Input: u8* PStr:the string to be send
*Output:     
*************************************************************************************/
void Uart0SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		Uart0SendByte(*PStr);
		PStr ++;
	}
}

/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitUart0_S0BRG(void)
*Description:   Initialize Uart0, The source of baud rate was S0BRG
*Input:   
*Output:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// Set SFR 0xB9 address to access S0CR1
	UART0_SetMode8bitUARTVar();			// 8-bit, Variable B.R.
	UART0_EnReception();				// Enable reception
	UART0_SetBRGFromS0BRG();			// B.R. source: S0BRG
	UART0_SetS0BRGBaudRateX2();			// S0BRG x2
	UART0_SetS0BRGSelSYSCLK();			// S0BRG clock source:SYSCLK
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);

	UART0_EnS0BRG();					// Enable S0BRG
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as Quasi-Bidirectional,for RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				// Set P46 as Open-Drain with pull-up resistor,for LED
}

/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}

/***********************************************************************************
*Function:   void InitInterrupt(void)
*Description:   Initialize Interrupt 
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();			//	Enable T0 interrupt
	INT_EnUART0();			//	Enable Uart0 interrupt
	INT_EnAll();			//  Enable global interrupt
	
}	

/***********************************************************************************
*Function:   void InitTimer0(void)
*Description:Initialize Timer0
*Input:   
*Output:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// TIMER0 Mode: 16-bit
	TM_SetT0Clock_SYSCLKDiv12();			// TIMER0 Clock source: SYSCLK/12
	TM_SetT0Gate_Disable();	
				
	TM_SetT0LowByte(TIMER_12T_1ms_TL);		// Set TL0 value
	TM_SetT0HighByte(TIMER_12T_1ms_TH);		// Set TH0 value

	TM_EnableT0();							// Enable T0
}

/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitTimer0();
	InitUart0_S0BRG();
	InitInterrupt();
}

void main()
{
	InitSystem();

	
	Uart0RxIn=0;
	Uart0RxOut=0;
	Uart0TxIn=0;
	Uart0TxOut=0;
	bUart0TxFlag=0;
	
	Uart0SendStrByInt("\nUart0 Send By INT");
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;	

	Uart0SendStr("\nUart0 Send Hello..");


	while(1)
	{
		if(LedTime==0)
		{
			LedTime=100;
			LED_G_0 = !LED_G_0;
		}
		if(Uart0RxIn != Uart0RxOut)
		{
			Uart0SendByteByInt(RcvBuf[Uart0RxOut]);
			Uart0RxOut++;
			if(Uart0RxOut>=UART0_RX_BUFF_SIZE)
			{
				Uart0RxOut=0;
			}
		}

	}

}


